//
//  HTMLFormDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/15.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLFormDialog extends HTMLDialog {
	private JLabel actionLabel = new JLabel("action属性", JLabel.RIGHT);
	private JLabel methodLabel = new JLabel("method属性", JLabel.RIGHT);
	private JCheckBox encTypeBtn = new JCheckBox("enctype属性");

	private JTextField actionField = new JTextField(30);
	private String[] method_str = {"get", "post"};
	private JComboBox methodBox = new JComboBox(method_str);
	private String[] encType_str = {"application/x-www-form-urlencoded", "multipart/form-data"};
	private JComboBox encTypeBox = new JComboBox(encType_str);
	
	public HTMLFormDialog (TextView view) {
		super(view);
		setDialog(view, "form要素定義", 550, 180);
	}

	protected JPanel createHTMLDocumentPanel() {
		encTypeBox.setEditable(true);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, actionLabel,	0, 0, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, actionField,	1, 0, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, methodLabel,	0, 1, true);
		gridLayoutComponent(pane, layout, gc, methodBox,	1, 1, true);
		gridLayoutComponent(pane, layout, gc, encTypeBtn,	0, 2, true);
		gridLayoutComponent(pane, layout, gc, encTypeBox,	1, 2, false);

		encTypeBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, encTypeBox);
			}
		});

		return pane;
	}

	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		buff.append("<form");
		buff.append(" action=\"" + (String)actionField.getText() + "\"");
		buff.append(" method=\"" + (String)methodBox.getSelectedItem() + "\"");
		if (encTypeBtn.isSelected()) {
			buff.append(" enctype=\"" + (String)encTypeBox.getSelectedItem() + "\"");
		}
		buff.append(">\n");

		return buff.toString();
	}

	public String getStringEnd() {
		return "</form>\n";
	}
}