//
//  HTMLInputDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/15.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLInputDialog extends HTMLDialog {
/*
type	text password checkbox radio submit reset file hidden image button
name
value
checked
disabled
readonly
size
maxlength
src
alt
*/
	int index;
	String[] type_str		= {"text",		"password",	"checkbox",	"radio",
							   "submit",	"reset",	"file",		"hidden",
							   "image",		"button"};
	boolean[] nameFlag		= {false,		false,		false,		false,
							   true,		true,		false,		false,
							   false,		false};
	boolean[] checkedFlag	= {false,		false,		true,		true,
							   false,		false,		false,		false,
							   false,		false};
	boolean[] maxLengthFlag = {true,		true,		false,		false,
							   false,		false,		false,		false,
							   false,		false};
	boolean[] srcFlag		= {false,		false,		false,		false,
							   false,		false,		false,		false,
							   true,		false};

	private JLabel typeLabel = new JLabel("type属性", JLabel.RIGHT);
	private JLabel nameLabel = new JLabel("name属性", JLabel.RIGHT);
	private JCheckBox nameBtn = new JCheckBox("name属性", true);
	private JLabel valueLabel = new JLabel("value属性", JLabel.RIGHT);
	private JCheckBox checkedBtn = new JCheckBox("checked属性");
	private JCheckBox disabledBtn = new JCheckBox("disabled属性");
	private JCheckBox readOnlyBtn = new JCheckBox("readonly属性");
	private JCheckBox sizeBtn = new JCheckBox("size属性");
	private JCheckBox maxLengthBtn = new JCheckBox("maxlength属性");
	private JLabel srcLabel = new JLabel("src属性", JLabel.RIGHT);
	private JLabel altLabel = new JLabel("alt属性", JLabel.RIGHT);

	private JTextField typeField = new JTextField(10);
	private JTextField nameField = new JTextField(10);
	private JTextField valueField = new JTextField(25);
	private JTextField sizeField = new JTextField(10);
	private JTextField maxLengthField = new JTextField(10);
	private JTextField srcField = new JTextField(25);
	private JButton srcLinkBtn = new JButton("参照");
	private JTextField altField = new JTextField(25);
		
	public HTMLInputDialog (TextView view, String command) {
		super(view);
		index = 0;
		for (int i = 0; i < type_str.length; i++) {
			if (type_str[i].equals(command)) {
				index = i;
				break;
			}
		}
		setDialog(view, "input要素定義", 600, 400);
	}

	protected JPanel createHTMLDocumentPanel() {
		typeField.setText(type_str[index]);
		typeField.setEditable(false);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, typeLabel,		0, 0, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, typeField,		1, 0, true);
		gc.gridwidth = 1;
		if (nameFlag[index]) {
			gridLayoutComponent(pane, layout, gc, nameBtn,	0, 1, true);
			nameBtn.addItemListener(new ItemListener(){
				public void itemStateChanged(ItemEvent e) {
					enabledSetting(e, nameField);
				}
			});
		} else {
			gridLayoutComponent(pane, layout, gc, nameLabel,0, 1, true);
		}
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, nameField,		1, 1, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, valueLabel,		0, 2, true);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, valueField,		1, 2, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, checkedBtn,		0, 3, checkedFlag[index]);
		gridLayoutComponent(pane, layout, gc, disabledBtn,		0, 4, true);
		gridLayoutComponent(pane, layout, gc, readOnlyBtn,		0, 5, true);
		gridLayoutComponent(pane, layout, gc, sizeBtn,			0, 6, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, sizeField,		2, 6, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, maxLengthBtn,		0, 7, maxLengthFlag[index]);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, maxLengthField,	2, 7, maxLengthFlag[index]);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, srcLabel,			0, 8, srcFlag[index]);
		gridLayoutComponent(pane, layout, gc, srcField,			2, 8, srcFlag[index]);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, srcLinkBtn,		4, 8, srcFlag[index]);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, altLabel,			0, 9, srcFlag[index]);
		gridLayoutComponent(pane, layout, gc, altField,			2, 9, srcFlag[index]);

		sizeBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, sizeField);
			}
		});
		maxLengthBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, maxLengthField);
			}
		});
		srcLinkBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.JPEG_GROUP};
				fileSelect(srcField, filter);
			}
		});

		return pane;
	}

	public String getString() {
		StringBuffer buff = new StringBuffer();

		buff.append("<input");
		buff.append(" type=\"" + typeField.getText() + "\"");
		if (nameBtn.isSelected()) {
			buff.append(" name=\"" + nameField.getText() + "\"");
		}
		buff.append(" value=\"" + valueField.getText() + "\"");
		if (checkedBtn.isSelected()) {
			buff.append(" checked=\"checked\"");
		}
		if (disabledBtn.isSelected()) {
			buff.append(" disabled=\"disabled\"");
		}
		if (readOnlyBtn.isSelected()) {
			buff.append(" readonly=\"readonly\"");
		}
		if (sizeBtn.isSelected()) {
			buff.append(" size=\"" + sizeField.getText() + "\"");
		}
		if (maxLengthBtn.isSelected()) {
			buff.append(" maxlength=\"" + maxLengthField.getText() + "\"");
		}
		if (srcFlag[index]) {
			buff.append(" src=\"" + srcField.getText() + "\"");
			buff.append(" alt=\"" + altField.getText() + "\"");
		}

		buff.append(" />\n");

		return buff.toString();
	}
}