//
//  HTMLObjectDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/14.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLObjectDialog extends HTMLDialog {
	private JCheckBox codeBaseBtn = new JCheckBox("codebase属性");
	private JCheckBox classIdBtn = new JCheckBox("classid属性");
	private JCheckBox codeTypeBtn = new JCheckBox("codetype属性");
	private JCheckBox dataBtn = new JCheckBox("data属性");
	private JCheckBox typeBtn = new JCheckBox("type属性");
	private JCheckBox heightBtn = new JCheckBox("height属性");
	private JCheckBox widthBtn = new JCheckBox("width属性");

	private JTextField codeBaseField = new JTextField(30);
	private String[] classId_str = {"", "QuickTime", "Flash Player", "Shockwave", "Real Player", "Windows Media Player"};
	private JComboBox classIdBox = new JComboBox(classId_str);
	private String[] type_str = {"application/pdf", "application/xml", "application/xhtml+xml",
								 "application/x-shockwave-flash", "application/rss+xml",
								 "audio/midi", "audio/mp3", "audio/mpeg", "audio/wave", "audio/x-aiff",
								 "image/gif", "image/jpeg", "image/png",
								 "text/css", "text/html", "text/plain", "text/xml",
								 "video/mpeg", "video/quicktime"};
	private JComboBox codeTypeBox = new JComboBox(type_str);
	private JTextField dataField = new JTextField(30);
	private JButton dataLinkBtn = new JButton("参照");
	private JComboBox typeBox = new JComboBox(type_str);
	private JTextField heightField = new JTextField(10);
	private JTextField widthField = new JTextField(10);
	
	public HTMLObjectDialog (TextView view) {
		super(view);
		setDialog(view, "object要素定義", 600, 350);
	}

	private void classIdSetting() {
		String idType = (String)classIdBox.getSelectedItem();
		if (idType.equals("QuickTime")) {
			classIdBox.setSelectedItem("clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B");
		} else if (idType.equals("Flash Player")) {
			classIdBox.setSelectedItem("clsid:D27CDB6E-AE6D-11cf-96B8-444553540000");
		} else if (idType.equals("Shockwave")) {
			classIdBox.setSelectedItem("clsid:166B1BCA-3F9C-11CF-8075-444553540000");
		} else if (idType.equals("Real Player")) {
			classIdBox.setSelectedItem("clsid:CFCDAA03-8BE4-11CF-B84B-0020AFBBCCFA");
		} else if (idType.equals("Windows Media Player")) {
			classIdBox.setSelectedItem("clsid:6BF52A52-394A-11d3-B153-00C04F79FAA6");
		}
	}

	protected JPanel createHTMLDocumentPanel() {
		classIdBox.setEditable(true);
		codeTypeBox.setEditable(true);
		typeBox.setEditable(true);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, codeBaseBtn,		0, 0, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, codeBaseField,	1, 0, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, classIdBtn,		0, 1, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, classIdBox,		1, 1, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, codeTypeBtn,		0, 2, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, codeTypeBox,		1, 2, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, dataBtn,			0, 3, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, dataField,		1, 3, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, dataLinkBtn,		3, 3, false);
		gridLayoutComponent(pane, layout, gc, typeBtn,			0, 4, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, typeBox,			1, 4, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, heightBtn,		0, 5, true);
		gridLayoutComponent(pane, layout, gc, heightField,		1, 5, false);
		gridLayoutComponent(pane, layout, gc, widthBtn,			0, 6, true);
		gridLayoutComponent(pane, layout, gc, widthField,		1, 6, false);

		codeBaseBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, codeBaseField);
			}
		});
		classIdBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, classIdBox);
			}
		});
		classIdBox.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				classIdSetting();
			}
		});
		codeTypeBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, codeTypeBox);
			}
		});
		dataBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, dataLinkBtn);
				enabledSetting(e, dataField);
			}
		});
		dataLinkBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.MOV_GROUP, FileIOFilter.AUDIO_GROUP,
								   FileIOFilter.JPEG_GROUP};
				fileSelect(dataField, filter);
			}
		});
		typeBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, typeBox);
			}
		});
		heightBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, heightField);
			}
		});
		widthBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, widthField);
			}
		});

		return pane;
	}

	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		buff.append("<object");
		if (codeBaseBtn.isSelected()) {
			buff.append(" codebase=\"" + (String)codeBaseField.getText() + "\"");
		}
		if (classIdBtn.isSelected()) {
			buff.append(" classid=\"" + (String)classIdBox.getSelectedItem() + "\"");
		}
		if (codeTypeBtn.isSelected()) {
			buff.append(" codetype=\"" + (String)codeTypeBox.getSelectedItem() + "\"");
		}
		if (dataBtn.isSelected()) {
			buff.append(" data=\"" + (String)dataField.getText() + "\"");
		}
		if (typeBtn.isSelected()) {
			buff.append(" type=\"" + (String)typeBox.getSelectedItem() + "\"");
		}
		if (heightBtn.isSelected()) {
			buff.append(" height=\"" + (String)heightField.getText() + "\"");
		}
		if (widthBtn.isSelected()) {
			buff.append(" width=\"" + (String)widthField.getText() + "\"");
		}
		buff.append(">\n");

		return buff.toString();
	}

	public String getStringEnd() {
		return "</object>\n";
	}
}