//
//  HTMLOptionDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/16.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLOptionDialog extends HTMLDialog {
	private JCheckBox selectedBtn = new JCheckBox("selected属性");
	private JCheckBox disabledBtn = new JCheckBox("disabled属性");
	private JCheckBox labelBtn = new JCheckBox("label属性");
	private JCheckBox valueBtn = new JCheckBox("value属性");

	private JTextField labelField = new JTextField(20);
	private JTextField valueField = new JTextField(20);
		
	public HTMLOptionDialog (TextView view) {
		super(view);
		setDialog(view, "option要素定義", 400, 200);
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, selectedBtn,	0, 0, true);
		gridLayoutComponent(pane, layout, gc, disabledBtn,	0, 1, true);
		gridLayoutComponent(pane, layout, gc, labelBtn,		0, 2, true);
		gridLayoutComponent(pane, layout, gc, labelField,	1, 2, false);
		gridLayoutComponent(pane, layout, gc, valueBtn,		0, 3, true);
		gridLayoutComponent(pane, layout, gc, valueField,	1, 3, false);

		labelBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, labelField);
			}
		});
		valueBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, valueField);
			}
		});

		return pane;
	}

	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		buff.append("<option");
		if (selectedBtn.isSelected()) {
			buff.append(" selected=\"selected\"");
		}
		if (disabledBtn.isSelected()) {
			buff.append(" disabled=\"disabled\"");
		}
		if (labelBtn.isSelected()) {
			buff.append(" label=\"" + labelField.getText() + "\"");
		}
		if (valueBtn.isSelected()) {
			buff.append(" value=\"" + valueField.getText() + "\"");
		}
		buff.append(">");

		return buff.toString();
	}

	public String getStringEnd() {
		return "</option>\n";
	}
}