//
//  HTMLParamDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/15.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLParamDialog extends HTMLDialog {
	private JCheckBox idBtn = new JCheckBox("id属性");
	private JCheckBox nameBtn = new JCheckBox("name属性");
	private JCheckBox valueBtn = new JCheckBox("value属性");
	private JCheckBox valueTypeBtn = new JCheckBox("valuetype属性");
	private JCheckBox typeBtn = new JCheckBox("type属性");

	private JTextField idField = new JTextField(30);
	private JTextField nameField = new JTextField(30);
	private JTextField valueField = new JTextField(30);
	private String[] valueType_str = {"data", "ref", "object"};
	private JComboBox valueTypeBox = new JComboBox(valueType_str);
	private String[] type_str = {"application/pdf", "application/xml", "application/xhtml+xml",
								 "application/x-shockwave-flash", "application/rss+xml",
								 "audio/midi", "audio/mp3", "audio/mpeg", "audio/wave", "audio/x-aiff",
								 "image/gif", "image/jpeg", "image/png",
								 "text/css", "text/html", "text/plain", "text/xml",
								 "video/mpeg", "video/quicktime"};
	private JComboBox typeBox = new JComboBox(type_str);
	
	public HTMLParamDialog (TextView view) {
		super(view);
		setDialog(view, "param要素定義", 550, 250);
	}

	protected JPanel createHTMLDocumentPanel() {
		typeBox.setEditable(true);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, idBtn,		0, 0, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, idField,		1, 0, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, nameBtn,		0, 1, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, nameField,	1, 1, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, valueBtn,		0, 2, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, valueField,	1, 2, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, valueTypeBtn,	0, 3, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, valueTypeBox,	1, 3, false);
		gridLayoutComponent(pane, layout, gc, typeBtn,		0, 4, true);
		gridLayoutComponent(pane, layout, gc, typeBox,		1, 4, false);

		idBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, idField);
			}
		});
		nameBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, nameField);
			}
		});
		valueBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, valueField);
			}
		});
		valueTypeBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, valueTypeBox);
			}
		});
		typeBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, typeBox);
			}
		});

		return pane;
	}

	public String getString() {
		StringBuffer buff = new StringBuffer();

		buff.append("<param");
		if (idBtn.isSelected()) {
			buff.append(" id=\"" + (String)idField.getText() + "\"");
		}
		if (nameBtn.isSelected()) {
			buff.append(" name=\"" + (String)nameField.getText() + "\"");
		}
		if (valueBtn.isSelected()) {
			buff.append(" value=\"" + (String)valueField.getText() + "\"");
		}
		if (valueTypeBtn.isSelected()) {
			buff.append(" valuetype=\"" + (String)valueTypeBox.getSelectedItem() + "\"");
		}
		if (typeBtn.isSelected()) {
			buff.append(" type=\"" + (String)typeBox.getSelectedItem() + "\"");
		}
		buff.append(" />\n");

		return buff.toString();
	}
}