//
//  HTMLStyleDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/10.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLStyleDialog extends HTMLDialog {
	private boolean linkFlag;
	private JLabel relLabel    = new JLabel("rel属性", JLabel.RIGHT);
	private JLabel typeLabel   = new JLabel("type属性", JLabel.RIGHT);
	private JLabel hrefLabel   = new JLabel("href属性", JLabel.RIGHT);
	private JCheckBox mediaBtn = new JCheckBox("media属性");
	private JCheckBox titleBtn = new JCheckBox("title属性");

	private String[] rel_str = {"stylesheet", "alternate-stylesheet"};
	private JComboBox relBox = new JComboBox(rel_str);
	private JTextField typeField = new JTextField("text/css");
	private JTextField hrefField = new JTextField(30);
	private JButton hrefBtn = new JButton("参照");
	private JTextField titleField = new JTextField(30);
	private String[] media_str = {"screen", "print", "aural", "brille", "embossed",
								  "tv", "projection", "handheld", "tty"};
	private JComboBox mediaBox = new JComboBox(media_str);

	public HTMLStyleDialog (TextView view, String command) {
		super(view);
		String title;
		if (command.equals("link")) {
			linkFlag = true;
			title = "外部スタイルシート定義";
		} else {
			linkFlag = false;
			title = "内部スタイルシート定義";
		}
		setDialog(view, title, 600, 250);
	}

	protected JPanel createHTMLDocumentPanel() {
		mediaBox.setEditable(true);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, relLabel,		0, 0, linkFlag);
		gridLayoutComponent(pane, layout, gc, relBox,		1, 0, linkFlag);
		gridLayoutComponent(pane, layout, gc, typeLabel,	0, 1, true);
		gridLayoutComponent(pane, layout, gc, typeField,	1, 1, true);
		gridLayoutComponent(pane, layout, gc, hrefLabel,	0, 2, linkFlag);
		gc.fill = GridBagConstraints.NONE;
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, hrefField,	1, 2, linkFlag);
		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, hrefBtn,		3, 2, linkFlag);
		gridLayoutComponent(pane, layout, gc, mediaBtn,		0, 3, true);
		gridLayoutComponent(pane, layout, gc, mediaBox,		1, 3, false);
		gridLayoutComponent(pane, layout, gc, titleBtn,		0, 4, true);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, titleField,	1, 4, false);

		hrefBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.CSS};
				fileSelect(hrefField, filter);
			}
		});
		mediaBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, mediaBox);
			}
		});
		titleBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, titleField);
			}
		});

		return pane;
	}

	public String getString() {
		StringBuffer buff = new StringBuffer();

		buff.append("<link");
		buff.append(" rel=\"" + (String)relBox.getSelectedItem() + "\"");
		buff.append(" type=\"" + (String)typeField.getText() + "\"");
		buff.append(" href=\"" + (String)hrefField.getText() + "\"");
		if (mediaBtn.isSelected()) {
			buff.append(" media=\"" + (String)mediaBox.getSelectedItem() + "\"");
		}
		if (titleBtn.isSelected()) {
			buff.append(" title=\"" + (String)titleField.getText() + "\"");
		}
		buff.append(" />\n");

		return buff.toString();
	}

	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		buff.append("<style");
		buff.append(" type=\"" + (String)typeField.getText() + "\"");
		if (mediaBtn.isSelected()) {
			buff.append(" media=\"" + (String)mediaBox.getSelectedItem() + "\"");
		}
		if (titleBtn.isSelected()) {
			buff.append(" title=\"" + (String)titleField.getText() + "\"");
		}
		buff.append(">\n");

		return buff.toString();
	}
	
	public String getStringEnd() {
		return "</style>\n";
	}
}