//
//  HTMLTableCellDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/14.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLTableCellDialog extends HTMLDialog {
	private boolean thFlag;

	private JCheckBox rowspanBtn = new JCheckBox("rowspan属性");
	private JCheckBox colspanBtn = new JCheckBox("colspan属性");

	private JTextField rowspanField = new JTextField(10);
	private JTextField colspanField = new JTextField(10);

	public HTMLTableCellDialog (TextView view, String tag) {
		super(view);
		String title;
		if (tag.equals("th")) {
			thFlag = true;
			title = "th要素定義";
		} else {
			thFlag = false;
			title = "td要素定義";
		}
		setDialog(view, title, 300, 150);
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, colspanBtn,	0, 0, true);
		gridLayoutComponent(pane, layout, gc, colspanField,	1, 0, false);
		gridLayoutComponent(pane, layout, gc, rowspanBtn,	0, 1, true);
		gridLayoutComponent(pane, layout, gc, rowspanField,	1, 1, false);

		colspanBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, colspanField);
			}
		});
		rowspanBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, rowspanField);
			}
		});

		return pane;
	}

	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		if (thFlag) {
			buff.append("<th");
		} else {
			buff.append("<td");
		}
		if (colspanBtn.isSelected()) {
			buff.append(" colspan=\"" + (String)colspanField.getText() + "\"");
		}
		if (rowspanBtn.isSelected()) {
			buff.append(" rowspan=\"" + (String)rowspanField.getText() + "\"");
		}
		buff.append(">");

		return buff.toString();
	}
	
	public String getStringEnd() {
		if (thFlag) {
			return "</th>\n";
		} else {
			return "</td>\n";
		}
	}

}