//
//  HTMLTextAreaDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/16.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLTextAreaDialog extends HTMLDialog {
	private JCheckBox nameBtn = new JCheckBox("name属性", true);
	private JLabel rowsLabel = new JLabel("rows属性", JLabel.RIGHT);
	private JLabel colsLabel = new JLabel("cols属性", JLabel.RIGHT);
	private JCheckBox disabledBtn = new JCheckBox("disabled属性");
	private JCheckBox readOnlyBtn = new JCheckBox("readonly属性");

	private JTextField nameField = new JTextField(10);
	private JTextField rowsField = new JTextField(10);
	private JTextField colsField = new JTextField(10);
		
	public HTMLTextAreaDialog (TextView view) {
		super(view);
		setDialog(view, "textarea要素定義", 300, 250);
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, nameBtn,		0, 0, true);
		gridLayoutComponent(pane, layout, gc, nameField,	1, 0, true);
		gridLayoutComponent(pane, layout, gc, rowsLabel,	0, 1, true);
		gridLayoutComponent(pane, layout, gc, rowsField,	1, 1, true);
		gridLayoutComponent(pane, layout, gc, colsLabel,	0, 2, true);
		gridLayoutComponent(pane, layout, gc, colsField,	1, 2, true);
		gridLayoutComponent(pane, layout, gc, disabledBtn,	0, 3, true);
		gridLayoutComponent(pane, layout, gc, readOnlyBtn,	0, 4, true);

		nameBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, nameField);
			}
		});

		return pane;
	}

	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		buff.append("<textarea");
		if (nameBtn.isSelected()) {
			buff.append(" name=\"" + nameField.getText() + "\"");
		}
		buff.append(" rows=\"" + rowsField.getText() + "\"");
		buff.append(" cols=\"" + colsField.getText() + "\"");
		if (disabledBtn.isSelected()) {
			buff.append(" disabled=\"disabled\"");
		}
		if (readOnlyBtn.isSelected()) {
			buff.append(" readonly=\"readonly\"");
		}
		buff.append(">");

		return buff.toString();
	}

	public String getStringEnd() {
		return "</textarea>\n";
	}
}