//
//  InfoDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/05/12.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.io.*;
import java.util.*;

import java.awt.BorderLayout;
import java.awt.FlowLayout;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.XMLReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class InfoDialog extends JDialog implements WindowListener {

	private static final int WARNING_ERROR		 = 1;
	private static final int STANDARD_ERROR		 = 2;
	private static final int FATAL_ERROR		 = 4;
	private static final int CONFIGURATION_ERROR = 8;
	private static final int IO_ERROR			 = 16;
	
	private TextView view;
	private JTextArea resultArea = new JTextArea();
	private int errorFlag;


	public InfoDialog (TextView view) {
		super(view, null, false);
		this.view = view;
	}

	public void setDialog(String title, int width, int height) {
		setTitle(title);

		resultArea.setEditable(false);
		resultArea.setLineWrap(true);
		JScrollPane pane = new JScrollPane(resultArea);
		getContentPane().add(pane, BorderLayout.CENTER);
		JButton btn1 = new JButton("閉じる");

		btn1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				dispose();
			}
		});

		JPanel btnPane = new JPanel();
		btnPane.add(btn1);
		getContentPane().add(btnPane, BorderLayout.SOUTH);

		this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);

		int x = view.getLocationOnScreen().x;
		int y = view.getLocationOnScreen().y;
		x = x + view.getSize().width / 2 - (width / 2);
		if (x < 0) {
			x = view.getLocationOnScreen().x;
		}

//		System.out.println("w=" + dim.width + " ww=" + width);
//		System.out.println("h=" + dim.height + " hh=" + height);

		this.setBounds(x, y, width, height);
//		this.setResizable(false);
		this.setVisible(true);
	}

	public void xmlValidation(String str, boolean valid) {
		errorFlag = 0;
		if (valid) {
			resultArea.setText("XML 妥当性検証 開始...\n\n");
		} else {
			resultArea.setText("XML 整形式検証 開始...\n\n");
		}
		try {
			SAXParserFactory factory = SAXParserFactory.newInstance();
			factory.setNamespaceAware(valid);
			factory.setValidating(valid);
			XMLReader xml = factory.newSAXParser().getXMLReader();
			xml.setFeature("http://xml.org/sax/features/validation", valid);
			xml.setErrorHandler(new XMLHandler());

			if (!valid) {
				StringBuffer buff = new StringBuffer(str);
				int dtdStart, dtdEnd;
				dtdStart = buff.indexOf("<!DOCTYPE");
				if (dtdStart > 0) {
					dtdEnd = buff.indexOf(">", dtdStart);
					if (dtdEnd > dtdStart) {
						buff.insert(dtdEnd, " --");
						buff.insert(dtdStart + 2, "-- ");
						str = buff.toString();
//						String str1 = str.substring(0, dtdStart - 1);
//						String str2 = str.substring(dtdEnd + 1);
//						str = str1 + str2;
					}
				}
			}

			StringReader sb = new StringReader(str);
			InputSource is = new InputSource(sb);
			xml.parse(is);
		} catch (FactoryConfigurationError e) {
		} catch (ParserConfigurationException e) {
			errorFlag |= InfoDialog.CONFIGURATION_ERROR;
			resultArea.append("パーサーエラー\n" + e.getMessage() + "\n");
		} catch (IOException e) {
			errorFlag |= InfoDialog.IO_ERROR;
			resultArea.append("アクセスエラー\n" + e.getMessage() + "\n");
		} catch (Exception e) { }
		if (errorFlag == 0) {
			resultArea.append("エラーはありませんでした。\n検証終了\n");
		} else if ((errorFlag & InfoDialog.CONFIGURATION_ERROR) != 0 ||
				   (errorFlag & InfoDialog.IO_ERROR) != 0 ||
				   (errorFlag & InfoDialog.FATAL_ERROR) != 0) {
			resultArea.append("\n検証を中止しました。\n");
		} else {
			resultArea.append("\n検証終了\n");
		}
	}

	public void windowActivated(WindowEvent e) { }
	public void	windowClosed(WindowEvent e) { }
	public void	windowClosing(WindowEvent e) { }
	public void	windowDeactivated(WindowEvent e) { }
	public void	windowDeiconified(WindowEvent e) { }
	public void	windowIconified(WindowEvent e) { }
	public void	windowOpened(WindowEvent e)  { }


	class XMLHandler extends DefaultHandler {
		public void error (SAXParseException e) {
			errorFlag |= InfoDialog.STANDARD_ERROR;
			resultArea.append("エラー: (line " + e.getLineNumber() + ")\n");
			resultArea.append(e.getMessage() + "\n");
		}
		public void fatalError (SAXParseException e) {
			errorFlag |= InfoDialog.FATAL_ERROR;
			resultArea.append("致命的エラー: (line " + e.getLineNumber() + ")\n");
			resultArea.append(e.getMessage() + "\n");
		}
		public void warning (SAXParseException e) {
			errorFlag |= InfoDialog.WARNING_ERROR;
			resultArea.append("警告: (line " + e.getLineNumber() + ")\n");
			resultArea.append(e.getMessage() + "\n");
		}
	}

}