//
//  JHimeOptionDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/22.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Font;
import java.awt.Insets;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class JHimeOptionDialog extends HTMLDialog {
	private JLabel tabSizeLabel  = new JLabel("タブ幅", JLabel.RIGHT);
	private JLabel fontSizeLabel = new JLabel("フォントサイズ", JLabel.RIGHT);
	private JLabel tabCountLabel = new JLabel("CSSタブ数", JLabel.RIGHT);
	private JLabel urlLabel		 = new JLabel("基底URL", JLabel.RIGHT);
	private JLabel urlLinkLabel  = new JLabel("参照方式", JLabel.RIGHT);

	private JTextField tabSizeField  = new JTextField(Integer.toString(JHime.TAB_SIZE), 10);
	private JTextField fontSizeField = new JTextField(Integer.toString(JHime.FONT_SIZE), 10);
	private JTextField tabCountField = new JTextField(Integer.toString(JHime.CSS_TAB_COUNT), 10);
	private JTextField urlField		 = new JTextField(JHime.BASEURL, 30);

	private JRadioButton fileBtn = new JRadioButton("ファイル名", JHime.LINK_FILE);
	private JRadioButton pathBtn = new JRadioButton("フルパス名", JHime.LINK_PATH);
	private JRadioButton urlBtn = new JRadioButton("基底URL + ファイル名", JHime.LINK_URL);
	
	private TextView view;

	public JHimeOptionDialog (TextView view) {
		super(view);
		setDialog(view, "エディタ設定", 550, 180);
		this.view = view;
	}

	protected JPanel createHTMLDocumentPanel() {
		ButtonGroup btnGroup = new ButtonGroup();
		btnGroup.add(fileBtn);
		btnGroup.add(pathBtn);
		btnGroup.add(urlBtn);
		JPanel pan = new JPanel();
		pan.add(fileBtn);
		pan.add(pathBtn);
		pan.add(urlBtn);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, tabSizeLabel,		0, 0, true);
		gridLayoutComponent(pane, layout, gc, tabSizeField,		1, 0, true);
		gridLayoutComponent(pane, layout, gc, fontSizeLabel,	0, 1, true);
		gridLayoutComponent(pane, layout, gc, fontSizeField,	1, 1, true);
		gridLayoutComponent(pane, layout, gc, tabCountLabel,	0, 2, true);
		gridLayoutComponent(pane, layout, gc, tabCountField,	1, 2, true);
		gridLayoutComponent(pane, layout, gc, urlLabel,			0, 3, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, urlField,			1, 3, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, urlLinkLabel,		0, 4, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, pan,				1, 4, true);

		return pane;
	}

	public void setOption() {
		try {
			JHime.TAB_SIZE  = Integer.parseInt(tabSizeField.getText());
			JHime.FONT_SIZE = Integer.parseInt(fontSizeField.getText());
			JHime.CSS_TAB_COUNT = Integer.parseInt(tabCountField.getText());
			JHime.BASEURL = urlField.getText().trim();
			JHime.LINK_FILE = fileBtn.isSelected();
			JHime.LINK_PATH = pathBtn.isSelected();
			JHime.LINK_URL = urlBtn.isSelected();

			view.getDocumentView().setFont(new Font("Monospaced", Font.PLAIN, JHime.FONT_SIZE));
			view.getDocumentView().setTabSize(JHime.TAB_SIZE);
		} catch (Exception e) { }
	}
}