//
//  RSSChannelItunesDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/05/09.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.util.*;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSpinner.DateEditor;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import javax.swing.SpinnerDateModel;

import javax.swing.border.LineBorder;

public class RSSChannelItunesDialog extends RSSDialog {

	public RSSChannelItunesDialog (TextView view) {
		super(view);

		setDialog(view, "RSSチャネル itunes要素", 100, 100);
	}

	protected JPanel createHTMLDocumentPanel() {
		JScrollPane ituneSummaryPane = new JScrollPane(ituneSummaryField);
		ituneDurationBox.setEditable(true);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, ituneAuthorBtn,			0, 0, true);
		gc.gridwidth = 4;
		gridLayoutComponent(pane, layout, gc, ituneAuthorField,			1, 0, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, ituneCategoryBtn,			0, 1, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, ituneCategoryBox,			1, 1, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, ituneSubCategoryBox,		3, 1, false);
		gridLayoutComponent(pane, layout, gc, ituneImageBtn,			0, 2, true);
		gc.gridwidth = 4;
		gridLayoutComponent(pane, layout, gc, ituneImageField,			1, 2, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, ituneImageLinkBtn,		5, 2, false);
//		gridLayoutComponent(pane, layout, gc, ituneDurationBtn,			0, 3, true);
//		gridLayoutComponent(pane, layout, gc, ituneDurationBox,			1, 3, false);
		gridLayoutComponent(pane, layout, gc, ituneExplicitBtn,			0, 3, true);
		gridLayoutComponent(pane, layout, gc, ituneExplicitBox,			1, 3, false);
		gridLayoutComponent(pane, layout, gc, ituneKeywordsBtn,			0, 4, true);
		gc.gridwidth = 4;
		gridLayoutComponent(pane, layout, gc, ituneKeywordsField,		1, 4, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, ituneOwnerBtn,			0, 5, true);
		gridLayoutComponent(pane, layout, gc, ituneNameLabel,			1, 5, false);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, ituneNameField,			2, 5, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, ituneEmailLabel,			1, 6, false);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, ituneEmailField,			2, 6, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, ituneSubTitleBtn,			0, 7, true);
		gc.gridwidth = 4;
		gridLayoutComponent(pane, layout, gc, ituneSubTitleField,		1, 7, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, ituneSummaryBtn,			0, 8, true);
		gc.gridwidth = 4;
		gridLayoutComponent(pane, layout, gc, ituneSummaryPane,			1, 8, false);


		ituneAuthorBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, ituneAuthorField);
			}
		});
		ituneCategoryBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, ituneSubCategoryBox);
				enabledSetting(e, ituneCategoryBox);
			}
		});
		ituneImageBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, ituneImageLinkBtn);
				enabledSetting(e, ituneImageField);
			}
		});
		ituneImageLinkBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.JPEG_GROUP};
				fileSelect(ituneImageField, filter);
			}
		});
/*
		ituneDurationBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, ituneDurationBox);
			}
		});
*/
		ituneExplicitBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, ituneExplicitBox);
			}
		});
		ituneKeywordsBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, ituneKeywordsField);
			}
		});
		ituneOwnerBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, ituneNameLabel);
				enabledSetting(e, ituneEmailLabel);
				enabledSetting(e, ituneEmailField);
				enabledSetting(e, ituneNameField);
			}
		});
		ituneSubTitleBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, ituneSubTitleField);
			}
		});
		ituneSummaryBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, ituneSummaryField);
			}
		});
		ituneCategoryBox.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int idx = ituneCategoryBox.getSelectedIndex();
				ituneSubCategoryBox.setModel((DefaultComboBoxModel)ituneCategorySubBoxModel.get(idx));
			}
		});

		return pane;
	}


	public String getString() {
		StringBuffer buff = new StringBuffer();

		if (ituneAuthorBtn.isSelected()) {
			buff.append("<itunes:author>" + ituneAuthorField.getText() + "</itunes:author>\n");
		}
		if (ituneCategoryBtn.isSelected()) {
			int mainIdx = ituneCategoryBox.getSelectedIndex();
			int subIdx  = ituneSubCategoryBox.getSelectedIndex();
			buff.append("<itunes:category text=\"" + category_main_str_en[mainIdx] + "\"");
			if (subIdx == 0) {
				buff.append(" />\n");
			} else {
				buff.append(">\n");
				buff.append("<itunes:category text=\"" + category_sub_str_en[mainIdx][subIdx] + "\" />\n");
				buff.append("</itunes:category>\n");
			}
		}
		if (ituneImageBtn.isSelected()) {
			buff.append("<itunes:image href=\"" + ituneImageField.getText() + "\" />\n");
		}
//		if (ituneDurationBtn.isSelected()) {
//			buff.append("<itunes:duration>" + ituneDurationBox.getSelectedItem() + "</itunes:duration>\n");
//		}
		if (ituneExplicitBtn.isSelected()) {
			buff.append("<itunes:explicit>" + ituneExplicitBox.getSelectedItem() + "</itunes:explicit>\n");
		}
		if (ituneKeywordsBtn.isSelected()) {
			buff.append("<itunes:keywords>" + ituneKeywordsField.getText() + "</itunes:keywords>\n");
		}
		if (ituneOwnerBtn.isSelected()) {
			buff.append("<itunes:owner>\n");
			buff.append("<itunes:name>" + ituneNameField.getText() + "</itunes:name>\n");
			buff.append("<itunes:email>" + ituneEmailField.getText() + "</itunes:email>\n");
			buff.append("</itunes:owner>\n");
		}
		if (ituneSubTitleBtn.isSelected()) {
			buff.append("<itunes:subtitle>" + ituneSubTitleField.getText() + "</itunes:subtitle>\n");
		}
		if (ituneSummaryBtn.isSelected()) {
			buff.append("<itunes:summary>" + ituneSummaryField.getText() + "</itunes:summary>\n");
		}

		return buff.toString();
	}
}