//
//  RSSDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/05/08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.util.*;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSpinner.DateEditor;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import javax.swing.SpinnerDateModel;

import javax.swing.border.LineBorder;

public abstract class RSSDialog extends HTMLDialog {
	protected JTabbedPane tabPane = new JTabbedPane();

	protected JCheckBox ituneBtn				= new JCheckBox("iTunesタグを含む", true);
	protected JLabel channelTitleLabel			= new JLabel("title要素", JLabel.RIGHT);
	protected JLabel channelLinkLabel			= new JLabel("link要素", JLabel.RIGHT);
	protected JLabel channelDescriptionLabel	= new JLabel("description要素", JLabel.RIGHT);
	//
	protected JTextField channelTitleField			= new JTextField(30);
	protected JTextField channelLinkField			= new JTextField(30);
	protected JButton channelLinkBtn				= new JButton("参照");
	protected JTextArea channelDescriptionField		= new JTextArea(8, 50);
	protected JCheckBox channelDescriptionCopyBtn	= new JCheckBox("description要素とitunes:summary要素を同一内容にする");

	protected JCheckBox channelLanguageBtn			= new JCheckBox("language要素");
	protected JCheckBox channelCopyrightBtn			= new JCheckBox("copyright要素");
	protected JCheckBox channelManagingEditorBtn	= new JCheckBox("managingEditor要素");
	protected JCheckBox channelWebMasterBtn			= new JCheckBox("webMaster要素");
	protected JCheckBox channelLastBuildBtn			= new JCheckBox("lastBuild要素");
	protected JCheckBox channelCategoryBtn			= new JCheckBox("category要素");
	protected JCheckBox channelGeneratorBtn			= new JCheckBox("generator要素");
	protected JCheckBox channelDocsBtn				= new JCheckBox("docs要素");
	protected JCheckBox channelTtlBtn				= new JCheckBox("ttl要素");
	protected JCheckBox channelImageBtn				= new JCheckBox("image要素");
	//
	protected JTextField channelLanguageField			= new JTextField("ja", 5);
	protected JTextField channelCopyrightField			=	new JTextField(30);
	protected JTextField channelManagingEditorField		= new JTextField(30);
	protected JTextField channelWebMasterField			= new JTextField(30);
	protected SpinnerDateModel channelLlastBuildDateModel
						= new SpinnerDateModel(new Date(), null, null, Calendar.DAY_OF_YEAR);
	protected JSpinner channelLastBuildField			= new JSpinner(channelLlastBuildDateModel);

	protected String[] category_main_str_jp = {
		"アート",						//0
		"ビジネス",						//1
		"コメディ",						//2
		"教育",							//3
		"ゲーム／趣味",					//4
		"行政／団体",						//5
		"健康",							//6
		"キッズ／ファミリー",				//7
		"ミュージック",					//8
		"ニュース／政治",					//9
		"宗教／スピリチュアル",				//10
		"科学／医学",						//11
		"社会／文化",						//12
		"スポーツ／レクリエーション",		//13
		"テクノロジー",					//14
		"テレビ／映画"					//15
	};
	protected String[][] category_sub_str_jp = {
		{"", "デザイン", "ファッション／美容", "フード", "文学", "パフォーミングアート", "ビジュアルアート",},
		{"", "ビジネスニュース", "キャリア", "投資", "経営／マーケティング", "ショッピング",},
		{"",},
		{"", "教育技術", "大学以上", "幼稚園〜高校", "言語コース", "トレーニング",},
		{"", "自動車", "航空", "趣味", "その他のゲーム", "ビデオゲーム",},
		{"", "ローカル", "国", "非営利", "地方自治体",},
		{"", "代替療法", "フィットネス／栄養", "セルフヘルプ", "セクシャリティ",},
		{"",},
		{"",},
		{"",},
		{"", "仏教", "キリスト教", "ヒンズー教", "イスラム教", "ユダヤ教", "その他", "スピリチュアリティ",},
		{"", "医学", "自然科学", "社会科学",},
		{"", "歴史", "個人ジャーナル", "哲学", "地域情報／トラベル",},
		{"", "アマチュア", "大学／高校", "アウトドア", "プロ",},
		{"", "ガジェット", "Techニュース", "ポッドキャスティング", "ソフトウェア ハウトゥ",},
		{"",},
	};
	protected String[] category_main_str_en = {
		"Arts",								//0
		"Business",							//1
		"Comedy",							//2
		"Education",						//3
		"Games &amp; Hobbies",				//4
		"Government &amp; Organization",	//5
		"Health",							//6
		"Kids &amp; Family",				//7
		"Music",							//8
		"News &amp; Politics",				//9
		"Religion &amp; Spirituality",		//10
		"Science &amp; Medicine",			//11
		"Society &amp; Culture",			//12
		"Sports &amp; Recreation",			//13
		"Technology",						//14
		"TV &amp; Film"						//15
	};
	protected String[][] category_sub_str_en = {
		{"", "Design", "Fashion &amp; Beauty", "Food", "Literature", "Performing Arts", "Visual Arts",},
		{"", "Business News", "Careers", "Investing", "Management &amp; Marketing", "Shopping",},
		{"",},
		{"", "Education Technology", "Higher Education", "K-12", "Language Curses", "Training",},
		{"", "Automotive", "Aviation", "Hobbies", "Other Games", "Video Games",},
		{"", "Local", "National", "Non-Profit", "Regional",},
		{"", "Alternative Health", "Fitness &amp; Nutrition", "Sellf-Help", "Sexuality",},
		{"",},
		{"",},
		{"",},
		{"", "Buddhism", "Christianity", "Hinduism", "Islam", "Judaism", "Other", "Spirituality",},
		{"", "Medicine", "Natural Sciences", "Social Sciences",},
		{"", "History", "Personal Journals", "Philosophy", "Places &amp; Travel",},
		{"", "Amateur", "College &amp; High School", "Outdoor", "Professional",},
		{"", "Gadgets", "Tech News", "Podcasting", "Software How-To",},
		{"",},
		{"",},
	};

	protected JComboBox channelCategoryBox				= new JComboBox(category_main_str_jp);
	protected JTextField channelTtlField				= new JTextField("60", 5);
	protected JLabel channelImageUrlLabel				= new JLabel("url要素", JLabel.RIGHT);
	protected JTextField channelImageUrlField			= new JTextField(30);
	protected JButton channelImageUrlBtn				= new JButton("参照");
	protected JLabel channelImageTitleLabel				= new JLabel("title要素", JLabel.RIGHT);
	protected JTextField channelImageTitleField			= new JTextField(30);
	protected JLabel channelImageLinkLabel				= new JLabel("link要素", JLabel.RIGHT);
	protected JTextField channelImageLinkField			= new JTextField(30);
	protected JButton channelImageLinkBtn				= new JButton("参照");
	protected JCheckBox channelImageDescriptionBtn		= new JCheckBox("description要素");
	protected JTextField channelImageDescriptionField	= new JTextField(30);
	protected JCheckBox channelImageWidthBtn			= new JCheckBox("width要素");
	protected JTextField channelImageWidthField			= new JTextField(10);
	protected JCheckBox channelImageHeightBtn			= new JCheckBox("height要素");
	protected JTextField channelImageHeightField		= new JTextField(10);

	protected JCheckBox ituneAuthorBtn			= new JCheckBox("itunes:author要素");
	protected JCheckBox ituneCategoryBtn		= new JCheckBox("itunes:category要素");
	protected JCheckBox ituneImageBtn			= new JCheckBox("itunes:image要素");
	protected JCheckBox ituneDurationBtn		= new JCheckBox("itunes:duration要素");
	protected JCheckBox ituneExplicitBtn		= new JCheckBox("itunes:explicit要素");
	protected JCheckBox ituneKeywordsBtn		= new JCheckBox("itunes:keywords要素");
	protected JCheckBox ituneOwnerBtn			= new JCheckBox("itunes:owner要素");
	protected JCheckBox ituneSubTitleBtn		= new JCheckBox("itunes:subtitle要素");
	protected JCheckBox ituneSummaryBtn			= new JCheckBox("itunes:summary要素");

	protected JTextField ituneAuthorField		= new JTextField(35);
	protected JComboBox ituneCategoryBox		= new JComboBox(category_main_str_jp);
	protected JComboBox ituneSubCategoryBox		= new JComboBox(category_sub_str_jp[0]);

	protected Vector ituneCategorySubBoxModel	= new Vector();// = new DefaultComboBoxModel[20];
	protected JTextField ituneImageField		= new JTextField(30);
	protected JButton ituneImageLinkBtn			= new JButton("参照");
	protected String[] itune_duration_str = {
		"HH:MM:SS", "H:MM:SS", "MM:SS", "M:SS",
	};
	protected JComboBox ituneDurationBox		= new JComboBox(itune_duration_str);
	protected String[] itune_explicit_str = {
		"yes", "no", "clean",
	};
	protected JComboBox ituneExplicitBox		= new JComboBox(itune_explicit_str);
	protected JTextField ituneKeywordsField		= new JTextField(30);
	protected JLabel ituneEmailLabel			= new JLabel("itunes:email要素");
	protected JTextField ituneEmailField		= new JTextField(30);
	protected JLabel ituneNameLabel				= new JLabel("itunes:name要素");
	protected JTextField ituneNameField			= new JTextField(30);
	protected JTextField ituneSubTitleField		= new JTextField(30);
	protected JTextArea ituneSummaryField		= new JTextArea(6, 30);

	protected JCheckBox itemTitleBtn				= new JCheckBox("title要素");
	protected JCheckBox itemLinkBtn					= new JCheckBox("link要素");
	protected JCheckBox itemDescriptionBtn			= new JCheckBox("description要素");
	protected JCheckBox itemAuthorBtn				= new JCheckBox("author要素");
	protected JTextField itemAuthorField			= new JTextField(30);
	protected JCheckBox itemCommentsBtn				= new JCheckBox("comments要素");
	protected JTextField itemCommentsField			= new JTextField(30);
	protected JButton itemCommentsLinkBtn			= new JButton("参照");
	protected JCheckBox itemEnclosureBtn			= new JCheckBox("enclosure要素");
	protected JLabel itemEnclosureUrlLabel			= new JLabel("url属性", JLabel.RIGHT);
	protected JTextField itemEnclosureUrlField		= new JTextField(30);
	protected JButton itemEnclosureUrlLinkBtn		= new JButton("参照");
	protected JLabel itemEnclosureLengthLabel		= new JLabel("length属性", JLabel.RIGHT);
	protected JTextField itemEnclosureLengthField	= new JTextField(10);
	protected JLabel itemEnclosureTypeLabel			= new JLabel("type属性", JLabel.RIGHT);
	private String[] item_enclosure_type_str = {
		"audio/mpeg", "audio/x-m4a", "video/mp4", "video/x-m4v", "video/quicktime", "application/pdf",
	};
	protected JComboBox itemEnclosureTypeBox		= new JComboBox(item_enclosure_type_str);
	protected JCheckBox itemGuidBtn					= new JCheckBox("guid要素");
	protected JTextField itemGuidField				= new JTextField(30);
	protected JCheckBox itemPubdateBtn				= new JCheckBox("pubDate要素");


	public RSSDialog (TextView view) {
		super(view);

		for (int i = 0; i < category_sub_str_jp.length; i++) {
			ituneCategorySubBoxModel.add(i, new DefaultComboBoxModel(category_sub_str_jp[i]));
		}
	}

	protected String getDateTime(Date dObj) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(dObj);
		StringBuffer dateStr = new StringBuffer();
		switch (cal.get(Calendar.DAY_OF_WEEK)) {
			case Calendar.MONDAY:
				dateStr.append("Mon,");
				break;
			case Calendar.TUESDAY:
				dateStr.append("Tue,");
				break;
			case Calendar.WEDNESDAY:
				dateStr.append("Wed,");
				break;
			case Calendar.THURSDAY:
				dateStr.append("Thu,");
				break;
			case Calendar.FRIDAY:
				dateStr.append("Fri,");
				break;
			case Calendar.SATURDAY:
				dateStr.append("Sat,");
				break;
			case Calendar.SUNDAY:
				dateStr.append("Sun,");
				break;
		}
		dateStr.append(" " + cal.get(Calendar.DAY_OF_MONTH));
		switch (cal.get(Calendar.MONTH)) {
			case Calendar.JANUARY:
				dateStr.append(" Jan");
				break;
			case Calendar.FEBRUARY:
				dateStr.append(" Feb");
				break;
			case Calendar.MARCH:
				dateStr.append(" Mar");
				break;
			case Calendar.APRIL:
				dateStr.append(" Apr");
				break;
			case Calendar.MAY:
				dateStr.append(" May");
				break;
			case Calendar.JUNE:
				dateStr.append(" Jun");
				break;
			case Calendar.JULY:
				dateStr.append(" Jul");
				break;
			case Calendar.AUGUST:
				dateStr.append(" Aug");
				break;
			case Calendar.SEPTEMBER:
				dateStr.append(" Sep");
				break;
			case Calendar.OCTOBER:
				dateStr.append(" Oct");
				break;
			case Calendar.NOVEMBER:
				dateStr.append(" Nov");
				break;
			case Calendar.DECEMBER:
				dateStr.append(" Dec");
				break;
		}
		String year = "000" + cal.get(Calendar.YEAR);
		dateStr.append(" " + year.substring(year.length() - 4));
		String hour = "0" + cal.get(Calendar.HOUR_OF_DAY);
		String min  = "0" + cal.get(Calendar.MINUTE);
		String sec  = "0" + cal.get(Calendar.SECOND);
		dateStr.append(" " + hour.substring(hour.length() - 2));
		dateStr.append(":" + min.substring(min.length() - 2));
		dateStr.append(":" + sec.substring(sec.length() - 2));

		int zoneVal = cal.get(Calendar.ZONE_OFFSET) / 36000;
		boolean flag = zoneVal < 0 ? false : true;
		zoneVal = Math.abs(zoneVal);
		String zone = "000" + zoneVal;
		if (flag) {
			dateStr.append(" +");
		} else {
			dateStr.append(" -");
		}
		dateStr.append(zone.substring(zone.length() - 4));

		return dateStr.toString();
	}
}