//
//  RSSItemItunesDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/05/09.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.util.*;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSpinner.DateEditor;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import javax.swing.SpinnerDateModel;

import javax.swing.border.LineBorder;

public class RSSItemItunesDialog extends RSSDialog {

	public RSSItemItunesDialog (TextView view) {
		super(view);

		setDialog(view, "RSS項目 itunes要素", 100, 100);
	}

	protected JPanel createHTMLDocumentPanel() {
		JScrollPane scrollPane = new JScrollPane(channelDescriptionField);
		ituneDurationBox.setEditable(true);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, ituneAuthorBtn,			0, 0, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, ituneAuthorField,			1, 0, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, ituneDurationBtn,			0, 1, true);
		gridLayoutComponent(pane, layout, gc, ituneDurationBox,			1, 1, false);
		gridLayoutComponent(pane, layout, gc, ituneExplicitBtn,			0, 2, true);
		gridLayoutComponent(pane, layout, gc, ituneExplicitBox,			1, 2, false);
		gridLayoutComponent(pane, layout, gc, ituneKeywordsBtn,			0, 3, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, ituneKeywordsField,		1, 3, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, ituneSubTitleBtn,			0, 4, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, ituneSubTitleField,		1, 4, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, ituneSummaryBtn,			0, 5, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, scrollPane,				1, 5, false);
/*
		gridLayoutComponent(pane, layout, gc, itemTitleBtn,				0, 0, true);
		gc.gridwidth = 5;
		gridLayoutComponent(pane, layout, gc, channelTitleField,		1, 0, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, itemLinkBtn,				0, 1, true);
		gc.gridwidth = 5;
		gridLayoutComponent(pane, layout, gc, channelLinkField,			1, 1, false);
		gridLayoutComponent(pane, layout, gc, channelLinkBtn,			6, 1, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, itemDescriptionBtn,		0, 2, true);
		gc.gridwidth = 5;
		gridLayoutComponent(pane, layout, gc, scrollPane,				1, 2, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, channelCategoryBtn,		0, 4, true);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, channelCategoryBox,		1, 4, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, itemCommentsBtn,			0, 5, true);
		gc.gridwidth = 5;
		gridLayoutComponent(pane, layout, gc, itemCommentsField,		1, 5, false);
		gridLayoutComponent(pane, layout, gc, itemCommentsLinkBtn,		6, 5, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, itemEnclosureBtn,			0, 6, true);
		gridLayoutComponent(pane, layout, gc, itemEnclosureUrlLabel,	1, 6, false);
		gc.gridwidth = 4;
		gridLayoutComponent(pane, layout, gc, itemEnclosureUrlField,	2, 6, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, itemEnclosureUrlLinkBtn,	6, 6, false);
		gridLayoutComponent(pane, layout, gc, itemEnclosureLengthLabel,	1, 7, false);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, itemEnclosureLengthField,	2, 7, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, itemEnclosureTypeLabel,	1, 8, false);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, itemEnclosureTypeBox,		2, 8, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, itemGuidBtn,				0, 9, true);
		gc.gridwidth = 5;
		gridLayoutComponent(pane, layout, gc, itemGuidField,			1, 9, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, itemPubdateBtn,			0,10, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, channelLastBuildField,	1,10, false);
*/
		ituneAuthorBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, ituneAuthorField);
			}
		});
		ituneDurationBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, ituneDurationBox);
			}
		});
		ituneExplicitBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, ituneExplicitBox);
			}
		});
		ituneKeywordsBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, ituneKeywordsField);
			}
		});
		ituneSubTitleBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, ituneSubTitleField);
			}
		});
		ituneSummaryBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelDescriptionField);
			}
		});
/*
		itemLinkBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelLinkBtn);
				enabledSetting(e, channelLinkField);
			}
		});
		itemDescriptionBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelDescriptionField);
			}
		});
		itemAuthorBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, itemAuthorField);
			}
		});
		channelCategoryBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelCategoryBox);
			}
		});
		itemCommentsBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, itemCommentsLinkBtn);
				enabledSetting(e, itemCommentsField);
			}
		});
		itemEnclosureBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, itemEnclosureTypeLabel);
				enabledSetting(e, itemEnclosureTypeBox);
				enabledSetting(e, itemEnclosureLengthLabel);
				enabledSetting(e, itemEnclosureLengthField);
				enabledSetting(e, itemEnclosureUrlLabel);
				enabledSetting(e, itemEnclosureUrlLinkBtn);
				enabledSetting(e, itemEnclosureUrlField);
			}
		});
		itemGuidBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, itemGuidField);
			}
		});
		itemPubdateBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelLastBuildField);
			}
		});

		channelLinkBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.HTML_GROUP};
				fileSelect(channelLinkField, filter);
			}
		});
		itemCommentsLinkBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.HTML_GROUP};
				fileSelect(itemCommentsField, filter);
			}
		});
		itemEnclosureUrlLinkBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.ITUNES_GROUP};
				fileSelect(itemEnclosureUrlField, itemEnclosureLengthField, filter);
			}
		});
*/
		return pane;
	}


	public String getString() {
		StringBuffer buff = new StringBuffer();

		if (ituneAuthorBtn.isSelected()) {
			buff.append("<itunes:author>" + ituneAuthorField.getText() + "</itunes:author>\n");
		}
		if (ituneDurationBtn.isSelected()) {
			buff.append("<itunes:duration>" + ituneDurationBox.getSelectedItem() + "</itunes:duration>\n");
		}
		if (ituneExplicitBtn.isSelected()) {
			buff.append("<itunes:explicit>" + ituneExplicitBox.getSelectedItem() + "</itunes:explicit>\n");
		}
		if (ituneKeywordsBtn.isSelected()) {
			buff.append("<itunes:keywords>" + ituneKeywordsField.getText() + "</itunes:keywords>\n");
		}
		if (ituneSubTitleBtn.isSelected()) {
			buff.append("<itunes:subtitle>" + ituneSubTitleField.getText() + "</itunes:subtitle>\n");
		}
		if (ituneSummaryBtn.isSelected()) {
			buff.append("<itunes:summary>" + channelDescriptionField.getText() + "</itunes:summary>\n");
		}
/*
		if (itemTitleBtn.isSelected()) {
			buff.append("<title>" + channelTitleField.getText() + "</title>\n");
		}
		if (itemLinkBtn.isSelected()) {
			buff.append("<link>" + channelLinkField.getText() + "</link>\n");
		}
		if (itemDescriptionBtn.isSelected()) {
			buff.append("<description>" + channelDescriptionField.getText() + "</description>\n");
		}
		if (itemAuthorBtn.isSelected()) {
			buff.append("<author>" + itemAuthorField.getText() + "</author>\n");
		}
		if (channelCategoryBtn.isSelected()) {
			if (channelCategoryBox.getSelectedIndex() >= 0) {
				buff.append("<category>" + category_main_str_en[channelCategoryBox.getSelectedIndex()] + "</category>\n");
			} else {
				buff.append("<category>" + channelCategoryBox.getSelectedItem() + "</category>\n");
			}
		}
		if (itemCommentsBtn.isSelected()) {
			buff.append("<comments>" + itemCommentsField.getText() + "</comments>\n");
		}
		if (itemEnclosureBtn.isSelected()) {
			buff.append("<enclosure");
			buff.append(" url=\"" + itemEnclosureUrlField.getText() + "\"");
			buff.append(" length=\"" + itemEnclosureLengthField.getText() + "\"");
			buff.append(" type=\"" + itemEnclosureTypeBox.getSelectedItem() + "\"");
			buff.append(" />\n");
		}
		if (itemGuidBtn.isSelected()) {
			buff.append("<guid>" + itemGuidField.getText() + "</guid>\n");
		}
		if (itemPubdateBtn.isSelected()) {
			Date dObj = (Date)channelLastBuildField.getValue();
			String dateStr = getDateTime(dObj);
			buff.append("<pubDate>" + dateStr + "</pubDate>\n");
		}
*/
		return buff.toString();
	}
}