//
//  TextView.java
//  JHime
//
//  Created by HIROTAKA YAMASHITA on 08/04/03.
//  Copyright 2008 HIROTAKA_YAMASHITA. All rights reserved.
//

import java.io.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

import javax.swing.text.*;
import javax.swing.text.Highlighter.HighlightPainter;
import javax.swing.text.DefaultHighlighter.DefaultHighlightPainter;

import javax.print.*;
import javax.print.attribute.*;
import javax.print.event.*;

import javax.xml.parsers.*;
import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;

public class TextView extends JFrame implements WindowListener {
//================================================================================
//	メンバ変数
//================================================================================
	private String userDir = JHime.USER_DIR; //System.getProperty("user.home");
	private InfoDialog infoDialog = null;
	private TextView textView;
	private JTextArea textArea;
	private JLabel statusLine = new JLabel("   line: 1");

	private	String[] encoding_str = {"UTF-8", "UTF-16", "Shift_JIS", "EUC-JP", "ISO-2022-JP"};
	private String pathName = null;
	private String encodingName = "UTF-8";
	private boolean changeFlag = false;

	private static int cnt = 0;
	private boolean comboFlag;

	private static HTMLTag[] BLOCK_ELEMENTS = {
		new HTMLTag("段落",			"p",			HTMLTag.BLOCK, false, true),
		new HTMLTag("見出し１",		"h1",			HTMLTag.BLOCK, false, true),
		new HTMLTag("見出し２",		"h2",			HTMLTag.BLOCK, false, true),
		new HTMLTag("見出し３",		"h3",			HTMLTag.BLOCK, false, true),
		new HTMLTag("見出し４",		"h4",			HTMLTag.BLOCK, false, true),
		new HTMLTag("見出し５",		"h5",			HTMLTag.BLOCK, false, true),
		new HTMLTag("見出し６",		"h6",			HTMLTag.BLOCK, false, true),
		new HTMLTag("作成者情報",		"address",		HTMLTag.BLOCK, false, true),
		new HTMLTag("水平区画線",		"hr",			HTMLTag.EMPTY, true,  true),
		new HTMLTag("引用文",		"blockquote",	HTMLTag.BLOCK, true,  true),
		new HTMLTag("整形テキスト",	"pre",			HTMLTag.BLOCK, false, true),
	};
	
	private static HTMLTag[] INLINE_ELEMENTS = {
		new HTMLTag("改行",			"br",			HTMLTag.EMPTY, false, false),
		new HTMLTag("強調",			"em",			HTMLTag.BLOCK, false, false),
		new HTMLTag("最強調",		"strong",		HTMLTag.BLOCK, false, false),
		new HTMLTag("用語",			"dfn",			HTMLTag.BLOCK, false, false),
		new HTMLTag("コード",		"code",			HTMLTag.BLOCK, false, false),
		new HTMLTag("変数・引数",		"var",			HTMLTag.BLOCK, false, false),
		new HTMLTag("出力サンプル",	"samp",			HTMLTag.BLOCK, false, false),
		new HTMLTag("キーボード入力",	"kbd",			HTMLTag.BLOCK, false, false),
		new HTMLTag("上付き文字",		"sup",			HTMLTag.BLOCK, false, false),
		new HTMLTag("下付き文字",		"sub",			HTMLTag.BLOCK, false, false),
		new HTMLTag("引用元",		"cite",			HTMLTag.BLOCK, false, false),
		new HTMLTag("引用文",		"q",			HTMLTag.BLOCK, false, false),
		new HTMLTag("省略語",		"abbr",			HTMLTag.BLOCK, false, false),
		new HTMLTag("頭字語",		"acronym",		HTMLTag.BLOCK, false, false),
		new HTMLTag("追加文",		"ins",			HTMLTag.BLOCK, false, false),
		new HTMLTag("削除文",		"del",			HTMLTag.BLOCK, false, false),
	};

	private static HTMLTag[] LIST_ELEMENTS = {
		new HTMLTag("無順序リスト",	"ul",			HTMLTag.BLOCK, true, true),
		new HTMLTag("順序リスト",		"ol",			HTMLTag.BLOCK, true, true),
		new HTMLTag("リスト項目",		"li",			HTMLTag.BLOCK, false, true),
		new HTMLTag("定義リスト",		"dl",			HTMLTag.BLOCK, true, true),
		new HTMLTag("用語項目",		"dt",			HTMLTag.BLOCK, false, true),
		new HTMLTag("説明項目",		"dd",			HTMLTag.BLOCK, false, true),
	};

	private static HTMLTag[] TABLE_ELEMENTS = {
		new HTMLTag("表組",			"table",		HTMLTag.BLOCK, true, true),
		new HTMLTag("表見出し",		"caption",		HTMLTag.BLOCK, false, true),
		new HTMLTag("行",			"tr",			HTMLTag.BLOCK, true, true),
		new HTMLTag("見出しセル",		"th",			HTMLTag.BLOCK, true, true),
		new HTMLTag("データセル",		"td",			HTMLTag.BLOCK, true, true),
	};

//================================================================================
//	コンストラクタ
//================================================================================
	public TextView () {
		super("名称未設定");

		GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
		Point cPoint = ge.getCenterPoint();
//		setBounds(cPoint.x - 400, 0, 800, 600);

		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);

		Container cnt = getContentPane();
		setJMenuBar(createMenuBar());
		Box ppan = Box.createVerticalBox();

		JTabbedPane tabPane = new JTabbedPane();
		tabPane.add("HTML", createHtmlToolBar2());
		tabPane.add("CSS(1)", createCssToolBar());
		tabPane.add("CSS(2)", createCssToolBar2());
		tabPane.add("RSS", createRssToolBar());


		ppan.add(createHtmlToolBar());
		ppan.add(tabPane);
		cnt.add(ppan, BorderLayout.NORTH);

		textArea = new JTextArea(25, 100);
		textArea.setFont(new Font("Monospaced", Font.PLAIN, JHime.FONT_SIZE));
		textArea.setTabSize(JHime.TAB_SIZE);
		textArea.setLineWrap(false);
		textArea.setMargin(new Insets(1,5,1,5));
		textArea.getDocument().putProperty("EndOfLineStringProperty", "\r\n");
		textArea.addCaretListener(new CaretListener(){
			public void caretUpdate(CaretEvent e) {
				getLineAtCaret();
			}
		});


		JScrollPane pane = new JScrollPane(textArea);
		cnt.add(pane, BorderLayout.CENTER);
		cnt.add(statusLine, BorderLayout.SOUTH);
//view
		int h = getPreferredSize().height + 20;
		int w = getPreferredSize().width + 20;

		if (h > 700) {	h = 600; }
		if (w > 1000) {	w = 800; }

		setBounds(cPoint.x - w / 2, 0, w, h);

		setVisible(true);
		textArea.requestFocusInWindow();

		textView = this;
		TextView.cnt++;
		JHime.ViewVector.add(this);
		addDocumentChangeListener(textView);
		addWindowListener(this);

	}

//================================================================================
//	private メソッド
//================================================================================
/*
    private void printText(TextView view) {
            try {

        PrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        DocFlavor flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
        PrintService[] printService = PrintServiceLookup.lookupPrintServices(flavor, pras);
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        PrintService service = ServiceUI.printDialog(null, 200,200,printService,defaultService,flavor,pras);

        if (service != null) {
            System.out.println(service.getName());
            Class[] cl = service.getSupportedAttributeCategories();
            for (int i = 0; i < cl.length; i++) {
                System.out.println(cl[i].getName());
            }

            DocPrintJob job = service.createPrintJob();
            job.addPrintJobListener(new PrintJobListener() {
                public void printDataTransferCompleted(PrintJobEvent e) {
                    System.out.println("trans ok " + e);
                }
                public void printJobCanceled(PrintJobEvent e) {
                    System.out.println("cancel " + e);
                }
                public void printJobCompleted(PrintJobEvent e) {
                    System.out.println("complete " + e);
                }
                public void printJobFailed(PrintJobEvent e) {
                    System.out.println("failed " + e);
                }
                public void printJobNoMoreEvents(PrintJobEvent e) {
                    System.out.println("no event " + e);
                }
                public void printJobRequiresAttention(PrintJobEvent e) {
                    System.out.println("attention " + e);
                }
            });

            FileInputStream isr = new FileInputStream("JHime.xml");
//            String sr = new String(view.getDocumentView().getText());
            DocAttributeSet das = new HashDocAttributeSet();
            Doc doc = new SimpleDoc(isr, flavor, das);
            job.print(doc, pras);
        }

            } catch(Exception ex) {
                System.out.println(ex);
            }
    }
*/
	//--------------------------------------------------------------------------------
	//	キャレット位置（行）
	//--------------------------------------------------------------------------------
	private void getLineAtCaret() {
		int pos = textArea.getCaretPosition();
		Element root = textArea.getDocument().getDefaultRootElement();
//		String str = "   line: " + (root.getElementIndex(pos) + 1);

		statusLine.setText("   line: " + (root.getElementIndex(pos) + 1));
	}

	//--------------------------------------------------------------------------------
	//	XML文書の検証
	//--------------------------------------------------------------------------------
	private void xmlValidation(boolean valid) {
		JWindow win = new JWindow(this);
		JLabel label = new JLabel("XML 検証中...", JLabel.CENTER);
		win.getContentPane().add(label);

		int x = getLocationOnScreen().x;
		int y = getLocationOnScreen().y;
		x = x + getSize().width / 2 - (200 / 2);
		if (x < 0) {
			x = getLocationOnScreen().x;
		}
		win.setBounds(x, y, 200, 100);
		win.setVisible(true);

		if (infoDialog == null) {
			infoDialog = new InfoDialog(this);
			infoDialog.setDialog("XML検証", 600, 400);
		}
		infoDialog.xmlValidation(textArea.getText(), valid);

		win.dispose();
		infoDialog.setVisible(true);
		setTextFocus();
	}

	//--------------------------------------------------------------------------------
	//	ハイライト設定
	//--------------------------------------------------------------------------------
	private void tagHighlight() {
		Highlighter.HighlightPainter painter;
		Highlighter.HighlightPainter rPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(255,  0,   0, 127));
		Highlighter.HighlightPainter gPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(  0,255,   0, 127));
		Highlighter.HighlightPainter bPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(  0,  0, 255, 127));

		resetHighlight();
        try{
            Highlighter hilite = textArea.getHighlighter();
            Document doc = textArea.getDocument();
            String text = doc.getText(0, doc.getLength());
			int textLength = text.length();
            int pos = 0, ePos, len;
            while((pos = text.indexOf("<", pos)) >= 0) {
				ePos = text.indexOf(">", pos + 1);
				if (ePos < 0) {
					ePos = textLength - 1;
				}
				len = ePos - pos + 1;
				painter = gPainter;
				if (pos + 1 < textLength) {
					char c = text.charAt(pos + 1);
					if (c == '!' || c == '?') {
						painter = rPainter;
					} else if (ePos > 1) {
						c = text.charAt(ePos - 1);
						if (c == '/') {
							painter = bPainter;
						}
					}
				}
                hilite.addHighlight(pos, pos+len, painter);
                pos += len;
            }
        }catch(BadLocationException e) { }

	}

	//--------------------------------------------------------------------------------
	//	ハイライト解除
	//--------------------------------------------------------------------------------
    private void resetHighlight() {
        Highlighter hilite = textArea.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        for(int i = 0; i < hilites.length; i++) {
            if(hilites[i].getPainter() instanceof DefaultHighlighter.DefaultHighlightPainter) {
                hilite.removeHighlight(hilites[i]);
            }
        }
    }

	//--------------------------------------------------------------------------------
	//	Documentモデル変更リスナー
	//--------------------------------------------------------------------------------
	private void addDocumentChangeListener(TextView view) {
		Document doc = view.textArea.getDocument();
		doc.addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				changeFlag = true;
			}
			public void insertUpdate(DocumentEvent e) {
				changeFlag = true;
			}
			public void removeUpdate(DocumentEvent e) {
				changeFlag = true;
			}
		});
	}

	//--------------------------------------------------------------------------------
	//	ファイルオープン
	//--------------------------------------------------------------------------------
	private void openFile() {
		if (changeFlag) {
			int ret = JOptionPane.showConfirmDialog(null, getTitle() + " を保存しますか?", "保存確認", JOptionPane.YES_NO_CANCEL_OPTION);
			switch (ret) {
				case JOptionPane.YES_OPTION:
					if (pathName == null) {
						saveAsFile();
					} else {
						saveFile();
					}
				case JOptionPane.NO_OPTION:
					break;
				case JOptionPane.CANCEL_OPTION:
					return;
			}
		}
		JPanel pane = new JPanel(new GridLayout(encoding_str.length, 1));
		pane.setBorder(BorderFactory.createLoweredBevelBorder());
		ButtonGroup bg = new ButtonGroup();
		JRadioButton[] encodingBtn = new JRadioButton[encoding_str.length];
		for (int i = 0; i < encoding_str.length; i++) {
			if (i == 0) {
				encodingBtn[i] = new JRadioButton(encoding_str[i], true);
			} else {
				encodingBtn[i] = new JRadioButton(encoding_str[i]);
			}
			pane.add(encodingBtn[i]);
			bg.add(encodingBtn[i]);
		}
		
		JFileChooser fc = new JFileChooser(this.userDir);
		FileFilter fl = new FileIOFilter(FileIOFilter.HTML);
		fc.addChoosableFileFilter(fl);
		fc.addChoosableFileFilter(new FileIOFilter(FileIOFilter.CSS));
		fc.addChoosableFileFilter(new FileIOFilter(FileIOFilter.XML));
		fc.addChoosableFileFilter(new FileIOFilter(FileIOFilter.JAVASCRIPT));
		fc.setFileFilter(fl);

		JPanel pPane = new JPanel(new BorderLayout(2, 2));
		pPane.add(new JLabel(""), BorderLayout.WEST);
		pPane.add(new JLabel(" "), BorderLayout.EAST);
		pPane.add(new JLabel("エンコーディング", JLabel.CENTER), BorderLayout.NORTH);
		pPane.add(pane, BorderLayout.CENTER);
		fc.setAccessory(pPane);

		int ret = fc.showOpenDialog(this);
		if (ret == JFileChooser.APPROVE_OPTION) {
			setUserDir(fc.getSelectedFile().getParent());
			pathName = fc.getSelectedFile().getPath();
			for (int i = 0; i < encoding_str.length; i++) {
				if (encodingBtn[i].isSelected()) {
					encodingName = encoding_str[i];
					break;
				}
			}
			try {
				Reader r = new InputStreamReader(new FileInputStream(pathName), encodingName);
				textArea.read(r, null);
				textArea.setTabSize(JHime.TAB_SIZE);
				addDocumentChangeListener(textView);
				setTitle(pathName);
				changeFlag = false;
			} catch (Exception e) {
				JOptionPane.showMessageDialog(this, "ファイルの入力に失敗しました", "エラー", JOptionPane.ERROR_MESSAGE);
			}
		}
		setTextFocus();
	}

	//--------------------------------------------------------------------------------
	//	名前を付けて保存
	//--------------------------------------------------------------------------------
	private void saveAsFile() {
		JPanel pane = new JPanel(new GridLayout(encoding_str.length, 1));
		pane.setBorder(BorderFactory.createLoweredBevelBorder());
		ButtonGroup bg = new ButtonGroup();
		JRadioButton[] encodingBtn = new JRadioButton[encoding_str.length];
		for (int i = 0; i < encoding_str.length; i++) {
			if (encodingName.equals(encoding_str[i])) {
				encodingBtn[i] = new JRadioButton(encoding_str[i], true);
			} else {
				encodingBtn[i] = new JRadioButton(encoding_str[i]);
			}
			pane.add(encodingBtn[i]);
			bg.add(encodingBtn[i]);
		}
		
		JFileChooser fc = new JFileChooser(this.userDir);
		FileFilter fl = new FileIOFilter(FileIOFilter.HTML);
		fc.addChoosableFileFilter(fl);
		fc.addChoosableFileFilter(new FileIOFilter(FileIOFilter.CSS));
		fc.addChoosableFileFilter(new FileIOFilter(FileIOFilter.XML));
		fc.setFileFilter(fl);

		JPanel pPane = new JPanel(new BorderLayout(2, 2));
		pPane.add(new JLabel(""), BorderLayout.WEST);
		pPane.add(new JLabel(" "), BorderLayout.EAST);
		pPane.add(new JLabel("エンコーディング", JLabel.CENTER), BorderLayout.NORTH);
		pPane.add(pane, BorderLayout.CENTER);
		fc.setAccessory(pPane);

		int ret = fc.showSaveDialog(this);
		if (ret == JFileChooser.APPROVE_OPTION) {
			setUserDir(fc.getSelectedFile().getParent());
			File f = new File(fc.getSelectedFile().getPath());
			if (f.canRead()) {
				ret = JOptionPane.showConfirmDialog(null, "ファイルがすでに存在します。書き換えてもよろしいですか？", "上書き確認", JOptionPane.YES_NO_OPTION);
				if (ret == JOptionPane.NO_OPTION) {
					setTextFocus();
					return;
				}
			}
			for (int i = 0; i < encoding_str.length; i++) {
				if (encodingBtn[i].isSelected()) {
					encodingName = encoding_str[i];
					break;
				}
			}
			try {
				Writer w = new OutputStreamWriter(new FileOutputStream(fc.getSelectedFile().getPath()), encodingName);
				textArea.write(w);
				pathName = fc.getSelectedFile().getPath();
				setTitle(pathName);
				changeFlag = false;
			} catch (Exception e) {
				JOptionPane.showMessageDialog(this, "ファイルの出力に失敗しました", "エラー", JOptionPane.ERROR_MESSAGE);
			}
		}
		setTextFocus();
	}

	//--------------------------------------------------------------------------------
	//	上書き保存
	//--------------------------------------------------------------------------------
	private void saveFile() {
		try {
			Writer w = new OutputStreamWriter(new FileOutputStream(pathName), encodingName);
			textArea.write(w);
			changeFlag = false;
		} catch (Exception e) {
			JOptionPane.showMessageDialog(this, "ファイルの出力に失敗しました", "エラー", JOptionPane.ERROR_MESSAGE);
		}
		setTextFocus();
	}

	//--------------------------------------------------------------------------------
	//	メニューバー（ファイル）
	//--------------------------------------------------------------------------------
	private JMenu createFileMenu() {
		JMenuItem newItem = new JMenuItem("新規");
		newItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + "N"));
		newItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				new TextView();
			}
		});

		JMenuItem openItem = new JMenuItem("開く...");
		openItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + "O"));
		openItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				openFile();
			}
		});

		JMenuItem closeItem = new JMenuItem("閉じる");
		closeItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				textView.dispatchEvent(new WindowEvent(textView, WindowEvent.WINDOW_CLOSING));
			}
		});


		JMenuItem saveItem = new JMenuItem("保存");
		saveItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + "S"));
		saveItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (changeFlag) {
					if (pathName == null) {
						saveAsFile();
					} else {
						saveFile();
					}
				}
				setTextFocus();
			}
		});

		JMenuItem saveAsItem = new JMenuItem("名前を付けて保存...");
		saveAsItem.setAccelerator(KeyStroke.getKeyStroke("shift " + JHime.CTRL + "S"));
		saveAsItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				saveAsFile();
			}
		});

/*
		JMenuItem printItem = new JMenuItem("印刷");
		printItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
                printText(textView);
			}
		});
*/
		JMenuItem quitItem = new JMenuItem("終了");
		quitItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int n = JHime.ViewVector.size();
				for (int i = n - 1; i > 0; i--) {
					TextView view = (TextView)JHime.ViewVector.get(i);
					view.dispatchEvent(new WindowEvent(view, WindowEvent.WINDOW_CLOSING));
				}
			}
		});

		JMenu fileMenu = new JMenu("ファイル");

		fileMenu.add(newItem);
		fileMenu.addSeparator();
		fileMenu.add(openItem);
		fileMenu.add(closeItem);
		fileMenu.add(saveItem);
		fileMenu.add(saveAsItem);
//		fileMenu.addSeparator();
//		fileMenu.add(printItem);
		fileMenu.addSeparator();
		fileMenu.add(quitItem);

		return fileMenu;
	}

	//--------------------------------------------------------------------------------
	//	メニューバー（編集）
	//--------------------------------------------------------------------------------
	private JMenu createEditMenu() {
		JMenu editMenu = new JMenu("編集");

		JMenuItem cutItem = new JMenuItem("カット");
		cutItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + "X"));
		cutItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				textArea.cut();
				setTextFocus();
			}
		});

		JMenuItem copyItem = new JMenuItem("コピー");
		copyItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + "C"));
		copyItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				textArea.copy();
				setTextFocus();
			}
		});

		JMenuItem pasteItem = new JMenuItem("ペースト");
		pasteItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + "V"));
		pasteItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				textArea.paste();
				setTextFocus();
			}
		});

		JMenuItem selectAllItem = new JMenuItem("すべてを選択");
		selectAllItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + "A"));
		selectAllItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				textArea.selectAll();
				setTextFocus();
			}
		});

		JMenuItem optionItem = new JMenuItem("エディタ設定");
		optionItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + ","));
		optionItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JHimeOptionDialog dlg = new JHimeOptionDialog(textView);

				if (dlg.getResult()) {
					dlg.setOption();
				}
			}
		});

		editMenu.add(cutItem);
		editMenu.add(copyItem);
		editMenu.add(pasteItem);
		editMenu.addSeparator();
		editMenu.add(selectAllItem);
		editMenu.addSeparator();
		editMenu.add(optionItem);

		return editMenu;
	}

	//--------------------------------------------------------------------------------
	//	メニューバー（表示）
	//--------------------------------------------------------------------------------
	private JMenu createViewMenu() {
		JMenu menu = new JMenu("表示");
		JMenu subMenu;
		JMenuItem item;
		JCheckBoxMenuItem cItem;

		cItem = new JCheckBoxMenuItem("行の折り返し");
		cItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (((JCheckBoxMenuItem)e.getSource()).getState()) {
					textArea.setLineWrap(true);
				} else {
					textArea.setLineWrap(false);
				}
			}
		});
		menu.add(cItem);
		menu.addSeparator();

		item = new JMenuItem("XML簡易ハイライト検証");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				tagHighlight();
				setTextFocus();
			}
		});
		menu.add(item);

		item = new JMenuItem("ハイライトクリア");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				resetHighlight();
				setTextFocus();
			}
		});
		menu.add(item);

		item = new JMenuItem("XML整形式検証");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				xmlValidation(false);
				setTextFocus();
			}
		});
		menu.add(item);

		item = new JMenuItem("XML妥当性検証");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				xmlValidation(true);
				setTextFocus();
			}
		});
		menu.add(item);

		return menu;
	}

	//--------------------------------------------------------------------------------
	//	メニューバー（HTML）
	//--------------------------------------------------------------------------------
	private JMenu createHtmlMenu() {
		JMenuItem item;
		JMenu subMenu;
		JMenu htmlMenu = new JMenu("HTML");
		//
		item = new JMenuItem("汎用属性...");			
		item.setActionCommand("attr");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericAttribute(textView);
			}
		});
		htmlMenu.add(item);
		htmlMenu.addSeparator();
		//
		item = new JMenuItem("html文書...");			
		item.setActionCommand("html");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericHtml(textView, e.getActionCommand());
			}
		});
		htmlMenu.add(item);
		//
		subMenu = new JMenu("html文書ヘッダ");
		item = new JMenuItem("ヘッダ");
		item.setActionCommand("head");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), true, true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("タイトル");
		item.setActionCommand("title");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("MIMEタイプ...");
		item.setActionCommand("meta");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericMetaMime(textView, e.getActionCommand());
			}
		});
		subMenu.add(item);
		item = new JMenuItem("メタ情報...");
		item.setActionCommand("meta");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericMeta(textView, e.getActionCommand());
			}
		});
		subMenu.add(item);
		JMenu styleMenu = new JMenu("スタイル");
		String[] style_str = {"外部スタイルシート...", "内部スタイルシート..."};
		String[] style_tag = {"link", "style"};
		for (int i = 0; i < style_str.length; i++) {
			item = new JMenuItem(style_str[i]);			
			item.setActionCommand(style_tag[i]);
			styleMenu.add(item);
			item.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					HTMLAction.genericStyle(textView, e.getActionCommand());
				}
			});
		}
		subMenu.add(styleMenu);
		JMenu scriptMenu = new JMenu("スクリプト");
		String[] script_str = {"スクリプト指定...", "非スクリプト指定"};
		String[] script_tag = {"script", "noscript"};
		for (int i = 0; i < script_str.length; i++) {
			item = new JMenuItem(script_str[i]);			
			item.setActionCommand(script_tag[i]);
			scriptMenu.add(item);
			item.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					HTMLAction.genericScript(textView, e.getActionCommand());
				}
			});
		}
		subMenu.add(scriptMenu);
		htmlMenu.add(subMenu);
		//
		item = new JMenuItem("html文書ボディ");		
		item.setActionCommand("body");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), true, true);
			}
		});
		htmlMenu.add(item);
		htmlMenu.addSeparator();
		//
		subMenu = new JMenu("ブロック要素");
		JMenu headingMenu = new JMenu("見出し");
		String[] heading_str = {"見出し１", "見出し２", "見出し３", "見出し４", "見出し５", "見出し６"};
		String[] heading_tag = {"h1", "h2", "h3", "h4", "h5", "h6"};
		for (int i = 0; i < heading_str.length; i++) {
			item = new JMenuItem(heading_str[i]);			
			item.setActionCommand(heading_tag[i]);
			headingMenu.add(item);
			item.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, true);
				}
			});
		}
		subMenu.add(headingMenu);
		item = new JMenuItem("段落");			
		item.setActionCommand("p");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("作成者情報");
		item.setActionCommand("address");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("水平区画線");
		item.setActionCommand("hr");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertSimpleTag(textView, e.getActionCommand(), true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("引用文...");
		item.setActionCommand("blockquote");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericBlockquote(textView, e.getActionCommand());
			}
		});
		subMenu.add(item);
		item = new JMenuItem("整形テキスト");
		item.setActionCommand("pre");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, true);
			}
		});
		subMenu.add(item);
		htmlMenu.add(subMenu);
		//
		subMenu = new JMenu("インライン要素");
		item = new JMenuItem("改行");
		item.setActionCommand("br");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertSimpleTag(textView, e.getActionCommand(), false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("強調");
		item.setActionCommand("em");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("最強調");
		item.setActionCommand("strong");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("用語");
		item.setActionCommand("dfn");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("コード");
		item.setActionCommand("code");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("変数・引数");
		item.setActionCommand("var");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("出力サンプル");
		item.setActionCommand("samp");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("キーボード入力");
		item.setActionCommand("kbd");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("上付き文字");
		item.setActionCommand("sup");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("下付き文字");
		item.setActionCommand("sub");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("引用元");
		item.setActionCommand("cite");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("引用文");
		item.setActionCommand("q");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("省略語");
		item.setActionCommand("abbr");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("頭字語");
		item.setActionCommand("acronym");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("追加文...");
		item.setActionCommand("ins");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericInsDel(textView, e.getActionCommand());
			}
		});
		subMenu.add(item);
		item = new JMenuItem("削除文...");
		item.setActionCommand("del");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericInsDel(textView, e.getActionCommand());
			}
		});
		subMenu.add(item);
		htmlMenu.add(subMenu);
		//
		subMenu = new JMenu("箇条書き");
		item = new JMenuItem("無順序リスト");
		item.setActionCommand("ul");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), true, true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("順序リスト");
		item.setActionCommand("ol");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), true, true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("リスト項目");
		item.setActionCommand("li");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("定義リスト");
		item.setActionCommand("dl");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), true, true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("用語項目");
		item.setActionCommand("dt");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("説明項目");
		item.setActionCommand("dd");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, true);
			}
		});
		subMenu.add(item);
		htmlMenu.add(subMenu);
		//
		subMenu = new JMenu("テーブル");
		item = new JMenuItem("表組...");
		item.setActionCommand("table");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericTable(textView, e.getActionCommand());
			}
		});
		subMenu.add(item);
		item = new JMenuItem("表見出し");
		item.setActionCommand("caption");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("行");
		item.setActionCommand("tr");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), true, true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("見出しセル...");
		item.setActionCommand("th");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericTableCell(textView, e.getActionCommand());
			}
		});
		subMenu.add(item);
		item = new JMenuItem("データセル...");
		item.setActionCommand("td");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericTableCell(textView, e.getActionCommand());
			}
		});
		subMenu.add(item);
		htmlMenu.add(subMenu);
		//
		item = new JMenuItem("リンク...");
		item.setActionCommand("a");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericA(textView, e.getActionCommand());
			}
		});
		htmlMenu.add(item);
		//
		item = new JMenuItem("画像...");
		item.setActionCommand("img");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericImg(textView, e.getActionCommand());
			}
		});
		htmlMenu.add(item);
		//
		subMenu = new JMenu("組込みオブジェクト");
		item = new JMenuItem("オブジェクト...");
		item.setActionCommand("object");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericObject(textView, e.getActionCommand());
			}
		});
		subMenu.add(item);
		item = new JMenuItem("パラメータ...");
		item.setActionCommand("param");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericParam(textView, e.getActionCommand());
			}
		});
		subMenu.add(item);
		htmlMenu.add(subMenu);
		//
		subMenu = new JMenu("フォーム");
		item = new JMenuItem("フォーム...");
		item.setActionCommand("form");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericForm(textView, e.getActionCommand());
			}
		});
		subMenu.add(item);
		JMenu buttonMenu = new JMenu("ボタン");
		String[] button_str = {"送信ボタン...", "リセットボタン...", "汎用ボタン...", "チェックボックス...", "ラジオボタン...", "画像ボタン..."};
		String[] button_tag = {"submit", "reset", "button", "checkbox", "radio", "image"};
		for (int i = 0; i < button_str.length; i++) {
			item = new JMenuItem(button_str[i]);			
			item.setActionCommand(button_tag[i]);
			buttonMenu.add(item);
			item.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					HTMLAction.genericInput(textView, e.getActionCommand());
				}
			});
		}
		subMenu.add(buttonMenu);
		JMenu textMenu = new JMenu("フィールド");
		String[] text_str = {"テキストフィールド...", "パスワードフィールド...", "隠しフィールド...", "テキストエリア...", "ファイル選択..."};
		String[] text_tag = {"text", "password", "hidden", "textarea", "file"};
		for (int i = 0; i < text_str.length; i++) {
			item = new JMenuItem(text_str[i]);			
			item.setActionCommand(text_tag[i]);
			textMenu.add(item);
			item.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					HTMLAction.genericInput(textView, e.getActionCommand());
				}
			});
		}
		subMenu.add(textMenu);
		JMenu selectMenu = new JMenu("選択ボックス");
		String[] select_str = {"選択ボックス...", "選択項目..."};
		String[] select_tag = {"select", "option"};
		for (int i = 0; i < select_str.length; i++) {
			item = new JMenuItem(select_str[i]);			
			item.setActionCommand(select_tag[i]);
			selectMenu.add(item);
			item.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					HTMLAction.genericSelectOption(textView, e.getActionCommand());
				}
			});
		}
		subMenu.add(selectMenu);
		item = new JMenuItem("ラベル...");
		item.setActionCommand("label");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericLabel(textView);
			}
		});
		subMenu.add(item);
		JMenu fieldsetMenu = new JMenu("グループ");
		String[] fieldset_str = {"フィールドセット", "グループラベル"};
		String[] fieldset_tag = {"fieldset", "legend"};
		for (int i = 0; i < fieldset_str.length; i++) {
			item = new JMenuItem(fieldset_str[i]);			
			item.setActionCommand(fieldset_tag[i]);
			fieldsetMenu.add(item);
			item.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					HTMLAction.genericFormGroup(textView, e.getActionCommand());
				}
			});
		}
		subMenu.add(fieldsetMenu);
		htmlMenu.add(subMenu);
		//
		subMenu = new JMenu("コンテナ");
		item = new JMenuItem("ブロックコンテナ");
		item.setActionCommand("div");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), true, true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("インラインコンテナ");
		item.setActionCommand("span");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		subMenu.add(item);
		htmlMenu.add(subMenu);

		return htmlMenu;
	}

	//--------------------------------------------------------------------------------
	//	メニューバー（CSS）
	//--------------------------------------------------------------------------------
	private JMenu createCssMenu() {
		JMenuItem item;
		JMenu subMenu;
		JMenu cssMenu = new JMenu("CSS");
		//
		item = new JMenuItem("セレクタ...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericSelector(textView);
			}
		});
		cssMenu.add(item);
		//
		subMenu = new JMenu("＠規則");
		item = new JMenuItem("@charset...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericAtCharset(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("@import...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericAtImport(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("@media...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericAtMedia(textView);
			}
		});
		subMenu.add(item);
		cssMenu.add(subMenu);

		item = new JMenuItem("ブロック");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				textView.insert(" {\n", "}\n");
			}
		});
		cssMenu.add(item);
		cssMenu.addSeparator();

		subMenu = new JMenu("色・背景");
		item = new JMenuItem("前景色...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericColor(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("背景個別指定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericBackground(textView, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("背景一括指定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericBackground(textView, true);
			}
		});
		subMenu.add(item);
		cssMenu.add(subMenu);
		subMenu = new JMenu("フォント");
		item = new JMenuItem("フォント個別指定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericFont(textView, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("フォント一括指定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericFont(textView, true);
			}
		});
		subMenu.add(item);
		cssMenu.add(subMenu);
		item = new JMenuItem("テキスト...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericText(textView);
			}
		});
		cssMenu.add(item);
		subMenu = new JMenu("ボックスモデル");
		item = new JMenuItem("マージン個別指定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericMargin(textView, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("マージン一括指定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericMargin(textView, true);
			}
		});
		subMenu.add(item);
		subMenu.addSeparator();
		item = new JMenuItem("パディング個別指定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericPadding(textView, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("パディング一括指定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericPadding(textView, true);
			}
		});
		subMenu.add(item);
		subMenu.addSeparator();
		item = new JMenuItem("四角ボーダー指定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericBorder(textView, true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("ボーダー個別指定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericBorder(textView, false);
			}
		});
		subMenu.add(item);
		cssMenu.add(subMenu);

		subMenu = new JMenu("視覚表現");
		item = new JMenuItem("内容領域幅...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericWidth(textView, true);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("内容領域高さ...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericWidth(textView, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("行の高さ...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericLineHeight(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("垂直位置指定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericVerticalAlign(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("ボックス生成...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericDisplay(textView);
			}
		});
		subMenu.add(item);
		cssMenu.add(subMenu);

		subMenu = new JMenu("視覚整形");
		item = new JMenuItem("配置方法...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericPosition(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("位置指定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericBoxPosition(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("フロート配置...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericFloat(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("フロート制御...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericClear(textView);
			}
		});
		subMenu.add(item);
		cssMenu.add(subMenu);

		subMenu = new JMenu("視覚効果");
		item = new JMenuItem("オーバーフロー制御...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericOverflow(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("可視制御...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericVisibility(textView);
			}
		});
		subMenu.add(item);
		cssMenu.add(subMenu);

		subMenu = new JMenu("リスト");
		item = new JMenuItem("リスト個別指定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericList(textView, false);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("リスト一括指定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericList(textView, true);
			}
		});
		subMenu.add(item);
		cssMenu.add(subMenu);

		subMenu = new JMenu("テーブル");
		item = new JMenuItem("キャプション位置...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericCaptionSide(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("テーブル設定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericTable(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("空セル設定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericEmptyCell(textView);
			}
		});
		subMenu.add(item);
		cssMenu.add(subMenu);

//		cssMenu.addSeparator();


		return cssMenu;
	}

	//--------------------------------------------------------------------------------
	//	メニューバー（RSS 2.0）
	//--------------------------------------------------------------------------------
	private JMenu createRssMenu() {
		JMenuItem item;
		JMenu subMenu;
		JMenu menu = new JMenu("RSS");
		//
		subMenu = new JMenu("チャネル設定");
		item = new JMenuItem("必須要素設定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				RSSAction.genericRssChannelBasicText(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("任意要素設定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				RSSAction.genericRssChannelOptionalText(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("itunes要素設定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				RSSAction.genericRssChannelItunesText(textView);
			}
		});
		subMenu.add(item);
		menu.add(subMenu);
		menu.addSeparator();

		subMenu = new JMenu("項目設定");
		item = new JMenuItem("item要素");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				RSSAction.genericRssItemText(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("任意要素設定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				RSSAction.genericRssItemOptionalText(textView);
			}
		});
		subMenu.add(item);
		item = new JMenuItem("itunes要素設定...");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				RSSAction.genericRssItemItunesText(textView);
			}
		});
		subMenu.add(item);
		menu.add(subMenu);

		return menu;
	}

	//--------------------------------------------------------------------------------
	//	メニューバー作成
	//--------------------------------------------------------------------------------
	private JMenuBar createMenuBar() {
		JMenuBar menuBar = new JMenuBar();
		menuBar.add(createFileMenu());
		menuBar.add(createEditMenu());
		menuBar.add(createViewMenu());
		menuBar.add(createHtmlMenu());
		menuBar.add(createCssMenu());
		menuBar.add(createRssMenu());

		JMenu menu = new JMenu("ヘルプ");
		JMenuItem item = new JMenuItem("情報");
		item.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				String[] msg = {"JHime version 0.4a (XHTML 1.0 & CSS 2.1 & RSS)",
								"    XML Well-formed Validator & DTD Validator",
								" ",
								"    Copyright (C) HIROTAKA YAMASHITA.",
								"    2008-06-07. All Rights Reserved.",
								" ",
								"    Java version:" + System.getProperty("java.version"),
								" ",
								};
				JOptionPane help = new JOptionPane();
				help.showMessageDialog(null, msg, "バージョン情報", JOptionPane.INFORMATION_MESSAGE);
			}
		});
		menu.add(item);
		menuBar.add(menu);


		return menuBar;
	}

	//--------------------------------------------------------------------------------
	//	ツールバー（標準）
	//--------------------------------------------------------------------------------
	private JToolBar createHtmlToolBar() {
		JPanel newPane = new JPanel(new BorderLayout(0, 2));
		JButton newBtn = new JButton(new ImageIcon("icons/new.gif"));
		newBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				new TextView();
			}
		});
		JLabel newLabel = new JLabel("新規", JLabel.CENTER);
		newLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		newPane.add(newBtn, BorderLayout.CENTER);
		newPane.add(newLabel, BorderLayout.SOUTH);
		newPane.setMaximumSize(newPane.getPreferredSize());

		JPanel openPane = new JPanel(new BorderLayout(0, 2));
		JButton openBtn = new JButton(new ImageIcon("icons/open.gif"));
		openBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				openFile();
			}
		});
		JLabel openLabel = new JLabel("開く", JLabel.CENTER);
		openLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		openPane.add(openBtn, BorderLayout.CENTER);
		openPane.add(openLabel, BorderLayout.SOUTH);
		openPane.setMaximumSize(openPane.getPreferredSize());

		JPanel savePane = new JPanel(new BorderLayout(0, 2));
		JButton saveBtn = new JButton(new ImageIcon("icons/save.gif"));
		saveBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (changeFlag) {
					if (pathName == null) {
						saveAsFile();
					} else {
						saveFile();
					}
				}
				setTextFocus();
			}
		});
		JLabel saveLabel = new JLabel("保存", JLabel.CENTER);
		saveLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		savePane.add(saveBtn, BorderLayout.CENTER);
		savePane.add(saveLabel, BorderLayout.SOUTH);
		savePane.setMaximumSize(savePane.getPreferredSize());

		JPanel cutPane = new JPanel(new BorderLayout(0, 2));
		JButton cutBtn = new JButton(new ImageIcon("icons/cut.gif"));
		cutBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				textArea.cut();
				setTextFocus();
			}
		});
		JLabel cutLabel = new JLabel("カット", JLabel.CENTER);
		cutLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		cutPane.add(cutBtn, BorderLayout.CENTER);
		cutPane.add(cutLabel, BorderLayout.SOUTH);
		cutPane.setMaximumSize(cutPane.getPreferredSize());

		JPanel copyPane = new JPanel(new BorderLayout(0, 2));
		JButton copyBtn = new JButton(new ImageIcon("icons/copy.gif"));
		copyBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				textArea.copy();
				setTextFocus();
			}
		});
		JLabel copyLabel = new JLabel("コピー", JLabel.CENTER);
		copyLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		copyPane.add(copyBtn, BorderLayout.CENTER);
		copyPane.add(copyLabel, BorderLayout.SOUTH);
		copyPane.setMaximumSize(copyPane.getPreferredSize());

		JPanel pastePane = new JPanel(new BorderLayout(0, 2));
		JButton pasteBtn = new JButton(new ImageIcon("icons/paste.gif"));
		pasteBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				textArea.paste();
				setTextFocus();
			}
		});
		JLabel pasteLabel = new JLabel("ペースト", JLabel.CENTER);
		pasteLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		pastePane.add(pasteBtn, BorderLayout.CENTER);
		pastePane.add(pasteLabel, BorderLayout.SOUTH);
		pastePane.setMaximumSize(pastePane.getPreferredSize());

		JPanel htmlAttrPane = new JPanel(new BorderLayout(0, 2));
		JButton attrBtn = new JButton(new ImageIcon("icons/attr.gif"));
		attrBtn.setActionCommand("attr");
		attrBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericAttribute(textView);
				setTextFocus();
			}
		});
		JLabel attrLabel = new JLabel("属性", JLabel.CENTER);
		attrLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		htmlAttrPane.add(attrBtn, BorderLayout.CENTER);
		htmlAttrPane.add(attrLabel, BorderLayout.SOUTH);
		htmlAttrPane.setMaximumSize(htmlAttrPane.getPreferredSize());

		JPanel htmlLinkPane = new JPanel(new BorderLayout(0, 2));
		JButton linkBtn = new JButton(new ImageIcon("icons/link.gif"));
		linkBtn.setActionCommand("a");
		linkBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericA(textView, e.getActionCommand());
			}
		});
		JLabel linkLabel = new JLabel("リンク", JLabel.CENTER);
		linkLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		htmlLinkPane.add(linkBtn, BorderLayout.CENTER);
		htmlLinkPane.add(linkLabel, BorderLayout.SOUTH);
		htmlLinkPane.setMaximumSize(htmlLinkPane.getPreferredSize());

		JPanel htmlImgPane = new JPanel(new BorderLayout(0, 2));
		JButton imgBtn = new JButton(new ImageIcon("icons/img.gif"));
		imgBtn.setActionCommand("img");
		imgBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.genericImg(textView, e.getActionCommand());
			}
		});
		JLabel imgLabel = new JLabel("画像", JLabel.CENTER);
		imgLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		htmlImgPane.add(imgBtn, BorderLayout.CENTER);
		htmlImgPane.add(imgLabel, BorderLayout.SOUTH);
		htmlImgPane.setMaximumSize(htmlImgPane.getPreferredSize());

		JPanel htmlDivPane = new JPanel(new BorderLayout(0, 2));
		JButton divBtn = new JButton(new ImageIcon("icons/div.gif"));
		divBtn.setActionCommand("div");
		divBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), true, true);
			}
		});
		JLabel divLabel = new JLabel("DIV", JLabel.CENTER);
		divLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		htmlDivPane.add(divBtn, BorderLayout.CENTER);
		htmlDivPane.add(divLabel, BorderLayout.SOUTH);
		htmlDivPane.setMaximumSize(htmlDivPane.getPreferredSize());

		JPanel htmlSpanPane = new JPanel(new BorderLayout(0, 2));
		JButton spanBtn = new JButton(new ImageIcon("icons/span.gif"));
		spanBtn.setActionCommand("span");
		spanBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HTMLAction.insertBlockTag(textView, e.getActionCommand(), false, false);
			}
		});
		JLabel spanLabel = new JLabel("SPAN", JLabel.CENTER);
		spanLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		htmlSpanPane.add(spanBtn, BorderLayout.CENTER);
		htmlSpanPane.add(spanLabel, BorderLayout.SOUTH);
		htmlSpanPane.setMaximumSize(htmlSpanPane.getPreferredSize());

		//セレクタ
		JPanel selectPane = new JPanel(new BorderLayout(0, 2));
		JButton selectBtn = new JButton(new ImageIcon("icons/cssSelect.gif"));
		selectBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CSSAction.genericSelector(textView);
			}
		});
		JLabel selectLabel = new JLabel("セレクタ", JLabel.CENTER);
		selectLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		selectPane.add(selectBtn, BorderLayout.CENTER);
		selectPane.add(selectLabel, BorderLayout.SOUTH);
		selectPane.setMaximumSize(selectPane.getPreferredSize());
		//ブロック
		JPanel blockPane = new JPanel(new BorderLayout(0, 2));
		JButton blockBtn = new JButton(new ImageIcon("icons/cssBlock.gif"));
		blockBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				textView.insert(" {\n", "}\n");
			}
		});
		JLabel blockLabel = new JLabel("ブロック", JLabel.CENTER);
		blockLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		blockPane.add(blockBtn, BorderLayout.CENTER);
		blockPane.add(blockLabel, BorderLayout.SOUTH);
		blockPane.setMaximumSize(blockPane.getPreferredSize());


		JToolBar toolBar = new JToolBar("標準");
		toolBar.add(newPane);
		toolBar.add(openPane);
		toolBar.add(savePane);
		toolBar.addSeparator(new Dimension(10,10));
		toolBar.add(cutPane);
		toolBar.add(copyPane);
		toolBar.add(pastePane);
		toolBar.addSeparator(new Dimension(10,10));
		toolBar.add(htmlAttrPane);
		toolBar.add(htmlLinkPane);
		toolBar.add(htmlImgPane);
		toolBar.add(htmlDivPane);
		toolBar.add(htmlSpanPane);
		toolBar.addSeparator(new Dimension(10,10));
		toolBar.add(selectPane);
		toolBar.add(blockPane);

		toolBar.add(Box.createHorizontalGlue());
		toolBar.setFloatable(false);

		return toolBar;
	}

	//--------------------------------------------------------------------------------
	//	ツールバー（HTML要素）
	//--------------------------------------------------------------------------------
	private JToolBar createHtmlToolBar2() {
		//ブロック要素
		JPanel htmlBlockPane = new JPanel(new BorderLayout(0, 1));
		JComboBox htmlBlockBox = new JComboBox(getElementsLabel(BLOCK_ELEMENTS));
		htmlBlockBox.addPopupMenuListener(new PopupMenuListener(){
			public void popupMenuCanceled(PopupMenuEvent e) {
				comboFlag = false;
				setTextFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				comboFlag = true;
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
				if (!comboFlag) return;
				String label = (String)((JComboBox)e.getSource()).getSelectedItem();
				HTMLTag command = getElementsTag(label, BLOCK_ELEMENTS);
				if (command.getName().equals("blockquote")) {
					HTMLAction.genericBlockquote(textView, command.getName());
				} else {
					if (command.getType()) {
						HTMLAction.insertBlockTag(textView,
												command.getName(),
												command.getStartBr(),
												command.getEndBr());
					} else {
						HTMLAction.insertSimpleTag(textView,
												command.getName(),
												command.getStartBr());
					}
				}
				setTextFocus();
			}
		});
		JLabel htmlBlockLabel = new JLabel("ブロック要素", JLabel.CENTER);
		htmlBlockLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		htmlBlockPane.add(htmlBlockBox, BorderLayout.CENTER);
		htmlBlockPane.add(htmlBlockLabel, BorderLayout.SOUTH);
		htmlBlockPane.setMaximumSize(htmlBlockPane.getPreferredSize());
		//インライン要素
		JPanel htmlInlinePane = new JPanel(new BorderLayout(0, 1));
		JComboBox htmlInlineBox = new JComboBox(getElementsLabel(INLINE_ELEMENTS));
		htmlInlineBox.addPopupMenuListener(new PopupMenuListener(){
			public void popupMenuCanceled(PopupMenuEvent e) {
				comboFlag = false;
				setTextFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				comboFlag = true;
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
				if (!comboFlag) return;
				String label = (String)((JComboBox)e.getSource()).getSelectedItem();
				HTMLTag command = getElementsTag(label, INLINE_ELEMENTS);
				if (command.getName().equals("ins") || command.getName().equals("del")) {
					HTMLAction.genericInsDel(textView, command.getName());
				} else {
					if (command.getType()) {
						HTMLAction.insertBlockTag(textView,
												command.getName(),
												command.getStartBr(),
												command.getEndBr());
					} else {
						HTMLAction.insertSimpleTag(textView,
												command.getName(),
												command.getStartBr());
					}
				}
				setTextFocus();
			}
		});
		JLabel htmlInlineLabel = new JLabel("インライン要素", JLabel.CENTER);
		htmlInlineLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		htmlInlinePane.add(htmlInlineBox, BorderLayout.CENTER);
		htmlInlinePane.add(htmlInlineLabel, BorderLayout.SOUTH);
		htmlInlinePane.setMaximumSize(htmlInlinePane.getPreferredSize());
		//リスト要素
		JPanel htmlListPane = new JPanel(new BorderLayout(0, 1));
		JComboBox htmlListBox = new JComboBox(getElementsLabel(LIST_ELEMENTS));
		htmlListBox.addPopupMenuListener(new PopupMenuListener(){
			public void popupMenuCanceled(PopupMenuEvent e) {
				comboFlag = false;
				setTextFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				comboFlag = true;
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
				if (!comboFlag) return;
				String label = (String)((JComboBox)e.getSource()).getSelectedItem();
				HTMLTag command = getElementsTag(label, LIST_ELEMENTS);
				if (command.getType()) {
					HTMLAction.insertBlockTag(textView,
											command.getName(),
											command.getStartBr(),
											command.getEndBr());
				} else {
					HTMLAction.insertSimpleTag(textView,
											command.getName(),
											command.getStartBr());
				}
				setTextFocus();
			}
		});
		JLabel htmlListLabel = new JLabel("箇条書き", JLabel.CENTER);
		htmlListLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		htmlListPane.add(htmlListBox, BorderLayout.CENTER);
		htmlListPane.add(htmlListLabel, BorderLayout.SOUTH);
		htmlListPane.setMaximumSize(htmlListPane.getPreferredSize());
		//テーブル要素
		JPanel htmlTablePane = new JPanel(new BorderLayout(0, 1));
		JComboBox htmlTableBox = new JComboBox(getElementsLabel(TABLE_ELEMENTS));
		htmlTableBox.addPopupMenuListener(new PopupMenuListener(){
			public void popupMenuCanceled(PopupMenuEvent e) {
				comboFlag = false;
				setTextFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				comboFlag = true;
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
				if (!comboFlag) return;
				String label = (String)((JComboBox)e.getSource()).getSelectedItem();
				HTMLTag command = getElementsTag(label, TABLE_ELEMENTS);
				if (command.getName().equals("table")) {
					HTMLAction.genericTable(textView, command.getName());
				} else if (command.getName().equals("th") || command.getName().equals("td")) {
					HTMLAction.genericTableCell(textView, command.getName());
				} else {
					if (command.getType()) {
						HTMLAction.insertBlockTag(textView,
												command.getName(),
												command.getStartBr(),
												command.getEndBr());
					} else {
						HTMLAction.insertSimpleTag(textView,
												command.getName(),
												command.getStartBr());
					}
				}
				setTextFocus();
			}
		});
		JLabel htmlTableLabel = new JLabel("テーブル", JLabel.CENTER);
		htmlTableLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		htmlTablePane.add(htmlTableBox, BorderLayout.CENTER);
		htmlTablePane.add(htmlTableLabel, BorderLayout.SOUTH);
		htmlTablePane.setMaximumSize(htmlTablePane.getPreferredSize());

		JToolBar toolBar = new JToolBar("HTML");
		toolBar.add(htmlInlinePane);
		toolBar.add(htmlBlockPane);
		toolBar.add(htmlListPane);
		toolBar.add(htmlTablePane);
		toolBar.add(Box.createHorizontalGlue());
		toolBar.setFloatable(false);

		return toolBar;
	}

	//--------------------------------------------------------------------------------
	//	ツールバー（CSS）
	//--------------------------------------------------------------------------------
	private JToolBar createCssToolBar() {
		//色・背景
		JPanel cssColorPane = new JPanel(new BorderLayout(0, 1));
		String[] cssColorStr = {"前景色", "背景個別指定", "背景一括指定"};
		JComboBox cssColorBox = new JComboBox(cssColorStr);
		cssColorBox.addPopupMenuListener(new PopupMenuListener(){
			public void popupMenuCanceled(PopupMenuEvent e) {
				comboFlag = false;
				setTextFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				comboFlag = true;
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
				if (!comboFlag) return;
				int idx = ((JComboBox)e.getSource()).getSelectedIndex();
				switch(idx) {
					case 0:
						CSSAction.genericColor(textView);
						break;
					case 1:
						CSSAction.genericBackground(textView, false);
						break;
					case 2:
						CSSAction.genericBackground(textView, true);
						break;
				}
				setTextFocus();
			}
		});
		JLabel cssColorLabel = new JLabel("色・背景", JLabel.CENTER);
		cssColorLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		cssColorPane.add(cssColorBox, BorderLayout.CENTER);
		cssColorPane.add(cssColorLabel, BorderLayout.SOUTH);
		cssColorPane.setMaximumSize(cssColorPane.getPreferredSize());
		//フォント・テキスト
		JPanel cssFontPane = new JPanel(new BorderLayout(0, 1));
		String[] cssFontStr = {"フォント個別指定", "フォント一括指定", "テキスト"};
		JComboBox cssFontBox = new JComboBox(cssFontStr);
		cssFontBox.addPopupMenuListener(new PopupMenuListener(){
			public void popupMenuCanceled(PopupMenuEvent e) {
				comboFlag = false;
				setTextFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				comboFlag = true;
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
				if (!comboFlag) return;
				int idx = ((JComboBox)e.getSource()).getSelectedIndex();
				switch(idx) {
					case 0:
						CSSAction.genericFont(textView, false);
						break;
					case 1:
						CSSAction.genericFont(textView, true);
						break;
					case 2:
						CSSAction.genericText(textView);
						break;
				}
				setTextFocus();
			}
		});
		JLabel cssFontLabel = new JLabel("フォント・テキスト", JLabel.CENTER);
		cssFontLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		cssFontPane.add(cssFontBox, BorderLayout.CENTER);
		cssFontPane.add(cssFontLabel, BorderLayout.SOUTH);
		cssFontPane.setMaximumSize(cssFontPane.getPreferredSize());
		//ボックス
		JPanel cssBoxPane = new JPanel(new BorderLayout(0, 1));
		String[] cssBoxStr = {"マージン個別指定", "マージン一括指定",
							  "パディング個別指定", "パディング一括指定",
							  "四角ボーダー指定", "ボーダー個別指定"};		
		JComboBox cssBoxBox = new JComboBox(cssBoxStr);
		cssBoxBox.addPopupMenuListener(new PopupMenuListener(){
			public void popupMenuCanceled(PopupMenuEvent e) {
				comboFlag = false;
				setTextFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				comboFlag = true;
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
				if (!comboFlag) return;
				int idx = ((JComboBox)e.getSource()).getSelectedIndex();
				switch(idx) {
					case 0:
						CSSAction.genericMargin(textView, false);
						break;
					case 1:
						CSSAction.genericMargin(textView, true);
						break;
					case 2:
						CSSAction.genericPadding(textView, false);
						break;
					case 3:
						CSSAction.genericPadding(textView, true);
						break;
					case 4:
						CSSAction.genericBorder(textView, true);
						break;
					case 5:
						CSSAction.genericBorder(textView, false);
						break;
				}
				setTextFocus();
			}
		});
		JLabel cssBoxLabel = new JLabel("ボックスモデル", JLabel.CENTER);
		cssBoxLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		cssBoxPane.add(cssBoxBox, BorderLayout.CENTER);
		cssBoxPane.add(cssBoxLabel, BorderLayout.SOUTH);
		cssBoxPane.setMaximumSize(cssBoxPane.getPreferredSize());
		//視覚整形
		JPanel cssVisualPane = new JPanel(new BorderLayout(0, 1));
		String[] cssVisualStr = {"内容領域幅", "内容領域高さ",
							  "行の高さ", "垂直位置指定", "ボックス生成",};

		JComboBox cssVisualBox = new JComboBox(cssVisualStr);
		cssVisualBox.addPopupMenuListener(new PopupMenuListener(){
			public void popupMenuCanceled(PopupMenuEvent e) {
				comboFlag = false;
				setTextFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				comboFlag = true;
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
				if (!comboFlag) return;
				int idx = ((JComboBox)e.getSource()).getSelectedIndex();
				switch(idx) {
					case 0:
						CSSAction.genericWidth(textView, true);
						break;
					case 1:
						CSSAction.genericWidth(textView, false);
						break;
					case 2:
						CSSAction.genericLineHeight(textView);
						break;
					case 3:
						CSSAction.genericVerticalAlign(textView);
						break;
					case 4:
						CSSAction.genericDisplay(textView);
						break;
					case 5:
						CSSAction.genericPosition(textView);
						break;
				}
				setTextFocus();
			}
		});
		JLabel cssVisualLabel = new JLabel("視覚表現", JLabel.CENTER);
		cssVisualLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		cssVisualPane.add(cssVisualBox, BorderLayout.CENTER);
		cssVisualPane.add(cssVisualLabel, BorderLayout.SOUTH);
		cssVisualPane.setMaximumSize(cssVisualPane.getPreferredSize());


		JToolBar toolBar = new JToolBar("CSS");
		toolBar.add(cssColorPane);
		toolBar.add(cssFontPane);
		toolBar.add(cssBoxPane);
		toolBar.add(cssVisualPane);

		toolBar.add(Box.createHorizontalGlue());
		toolBar.setFloatable(false);

		return toolBar;
	}

	//--------------------------------------------------------------------------------
	//	ツールバー2（CSS-2）
	//--------------------------------------------------------------------------------
	private JToolBar createCssToolBar2() {
		JPanel cssVisualFormatPane = new JPanel(new BorderLayout(0, 1));
		String[] cssVisualFormatStr = {"配置方法", "位置指定", "フロート配置", "フロート制御"};

		JComboBox cssVisualFormatBox = new JComboBox(cssVisualFormatStr);
		cssVisualFormatBox.addPopupMenuListener(new PopupMenuListener(){
			public void popupMenuCanceled(PopupMenuEvent e) {
				comboFlag = false;
				setTextFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				comboFlag = true;
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
				if (!comboFlag) return;
				int idx = ((JComboBox)e.getSource()).getSelectedIndex();
				switch(idx) {
					case 0:
						CSSAction.genericPosition(textView);
						break;
					case 1:
						CSSAction.genericBoxPosition(textView);
						break;
					case 2:
						CSSAction.genericFloat(textView);
						break;
					case 3:
						CSSAction.genericClear(textView);
						break;
				}
				setTextFocus();
			}
		});
		JLabel cssVisualFormatLabel = new JLabel("視覚整形", JLabel.CENTER);
		cssVisualFormatLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		cssVisualFormatPane.add(cssVisualFormatBox, BorderLayout.CENTER);
		cssVisualFormatPane.add(cssVisualFormatLabel, BorderLayout.SOUTH);
		cssVisualFormatPane.setMaximumSize(cssVisualFormatPane.getPreferredSize());

		JPanel cssVisualEffectPane = new JPanel(new BorderLayout(0, 1));
		String[] cssVisualEffectStr = {"オーバーフロー制御", "可視制御"};
		JComboBox cssVisualEffectBox = new JComboBox(cssVisualEffectStr);
		cssVisualEffectBox.addPopupMenuListener(new PopupMenuListener(){
			public void popupMenuCanceled(PopupMenuEvent e) {
				comboFlag = false;
				setTextFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				comboFlag = true;
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
				if (!comboFlag) return;
				int idx = ((JComboBox)e.getSource()).getSelectedIndex();
				switch(idx) {
					case 0:
						CSSAction.genericOverflow(textView);
						break;
					case 1:
						CSSAction.genericVisibility(textView);
						break;
				}
				setTextFocus();
			}
		});
		JLabel cssVisualEffectLabel = new JLabel("視覚効果", JLabel.CENTER);
		cssVisualEffectLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		cssVisualEffectPane.add(cssVisualEffectBox, BorderLayout.CENTER);
		cssVisualEffectPane.add(cssVisualEffectLabel, BorderLayout.SOUTH);
		cssVisualEffectPane.setMaximumSize(cssVisualEffectPane.getPreferredSize());

		JPanel cssListPane = new JPanel(new BorderLayout(0, 1));
		String[] cssListStr = {"リスト個別指定", "リスト一括指定"};
		JComboBox cssListBox = new JComboBox(cssListStr);
		cssListBox.addPopupMenuListener(new PopupMenuListener(){
			public void popupMenuCanceled(PopupMenuEvent e) {
				comboFlag = false;
				setTextFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				comboFlag = true;
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
				if (!comboFlag) return;
				int idx = ((JComboBox)e.getSource()).getSelectedIndex();
				switch(idx) {
					case 0:
						CSSAction.genericList(textView, false);
						break;
					case 1:
						CSSAction.genericList(textView, true);
						break;
				}
				setTextFocus();
			}
		});
		JLabel cssListLabel = new JLabel("リスト", JLabel.CENTER);
		cssListLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		cssListPane.add(cssListBox, BorderLayout.CENTER);
		cssListPane.add(cssListLabel, BorderLayout.SOUTH);
		cssListPane.setMaximumSize(cssListPane.getPreferredSize());

		JPanel cssTablePane = new JPanel(new BorderLayout(0, 1));
		String[] cssTableStr = {"キャプション位置", "テーブル設定", "空セル設定"};

		JComboBox cssTableBox = new JComboBox(cssTableStr);
		cssTableBox.addPopupMenuListener(new PopupMenuListener(){
			public void popupMenuCanceled(PopupMenuEvent e) {
				comboFlag = false;
				setTextFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				comboFlag = true;
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
				if (!comboFlag) return;
				int idx = ((JComboBox)e.getSource()).getSelectedIndex();
				switch(idx) {
					case 0:
						CSSAction.genericCaptionSide(textView);
						break;
					case 1:
						CSSAction.genericTable(textView);
						break;
					case 2:
						CSSAction.genericEmptyCell(textView);
						break;
				}
				setTextFocus();
			}
		});
		JLabel cssTableLabel = new JLabel("テーブル", JLabel.CENTER);
		cssTableLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		cssTablePane.add(cssTableBox, BorderLayout.CENTER);
		cssTablePane.add(cssTableLabel, BorderLayout.SOUTH);
		cssTablePane.setMaximumSize(cssTablePane.getPreferredSize());




		JToolBar toolBar = new JToolBar("CSS2");
		toolBar.add(cssVisualFormatPane);
		toolBar.add(cssVisualEffectPane);
		toolBar.add(cssListPane);
		toolBar.add(cssTablePane);
		toolBar.add(Box.createHorizontalGlue());
		toolBar.setFloatable(false);

		return toolBar;
	}

	//--------------------------------------------------------------------------------
	//	ツールバー（RSS）
	//--------------------------------------------------------------------------------
	private JToolBar createRssToolBar() {
		JPanel rssChannelPane = new JPanel(new BorderLayout(0, 1));
		String[] rssChannelStr = {"必須要素設定", "任意要素設定", "itunes要素設定",};

		JComboBox rssChannelBox = new JComboBox(rssChannelStr);
		rssChannelBox.addPopupMenuListener(new PopupMenuListener(){
			public void popupMenuCanceled(PopupMenuEvent e) {
				comboFlag = false;
				setTextFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				comboFlag = true;
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
				if (!comboFlag) return;
				int idx = ((JComboBox)e.getSource()).getSelectedIndex();
				switch(idx) {
					case 0:
						RSSAction.genericRssChannelBasicText(textView);
						break;
					case 1:
						RSSAction.genericRssChannelOptionalText(textView);
						break;
					case 2:
						RSSAction.genericRssChannelItunesText(textView);
						break;
				}
				setTextFocus();
			}
		});
		JLabel rssChannelLabel = new JLabel("チャネル設定", JLabel.CENTER);
		rssChannelLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		rssChannelPane.add(rssChannelBox, BorderLayout.CENTER);
		rssChannelPane.add(rssChannelLabel, BorderLayout.SOUTH);
		rssChannelPane.setMaximumSize(rssChannelPane.getPreferredSize());

		JPanel rssItemPane = new JPanel(new BorderLayout(0, 1));
		String[] rssItemStr = {"item要素", "任意要素設定", "itunes要素設定",};
		JComboBox rssItemBox = new JComboBox(rssItemStr);
		rssItemBox.addPopupMenuListener(new PopupMenuListener(){
			public void popupMenuCanceled(PopupMenuEvent e) {
				comboFlag = false;
				setTextFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				comboFlag = true;
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
				if (!comboFlag) return;
				int idx = ((JComboBox)e.getSource()).getSelectedIndex();
				switch(idx) {
					case 0:
						RSSAction.genericRssItemText(textView);
						break;
					case 1:
						RSSAction.genericRssItemOptionalText(textView);
						break;
					case 2:
						RSSAction.genericRssItemItunesText(textView);
						break;
				}
				setTextFocus();
			}
		});
		JLabel rssItemLabel = new JLabel("項目設定", JLabel.CENTER);
		rssItemLabel.setFont(new Font("Monospaced", Font.PLAIN, 10));
		rssItemPane.add(rssItemBox, BorderLayout.CENTER);
		rssItemPane.add(rssItemLabel, BorderLayout.SOUTH);
		rssItemPane.setMaximumSize(rssItemPane.getPreferredSize());


		JToolBar toolBar = new JToolBar("RSS");
		toolBar.add(rssChannelPane);
		toolBar.add(rssItemPane);
		toolBar.add(Box.createHorizontalGlue());
		toolBar.setFloatable(false);

		return toolBar;
	}

	//--------------------------------------------------------------------------------
	//	タグテーブルからラベル配列を取得
	//--------------------------------------------------------------------------------
	private String[] getElementsLabel(HTMLTag[] array) {
		String[] label = new String[array.length];
			
		for (int i = 0; i < array.length; i++) {
			label[i] = array[i].getLabel();
		}

		return label;
	}

	//--------------------------------------------------------------------------------
	//	ラベルによりタグテーブルからHTMLTagオブジェクトを取得
	//--------------------------------------------------------------------------------
	private HTMLTag getElementsTag(String label, HTMLTag[] array) {
		HTMLTag tag = null;

		for (int i = 0; i < array.length; i++) {
			if (label.equals(array[i].getLabel())) {
				tag = array[i];
				break;
			}
		}

		return tag;
	}

/*
	public int getCaret() {
		return this.textArea.getCaretPosition();
	}

	public Document getDocument() {
		return this.textArea.getDocument();
	}
*/
//================================================================================
//	public メソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	TextArea取得
	//--------------------------------------------------------------------------------
	public JTextArea getDocumentView() {
		return textArea;
	}

	//--------------------------------------------------------------------------------
	//	空要素挿入(TextArea)
	//--------------------------------------------------------------------------------
	public void insert(String str) {
		Document doc = textArea.getDocument();
		int position = textArea.getSelectionStart();

		try {
			int caretPosition = position + str.length();
			doc.insertString(position, str, null);
			textArea.setCaretPosition(caretPosition);
			textArea.requestFocusInWindow();
		} catch (Exception e) {}
	}

	//--------------------------------------------------------------------------------
	//	開始終了タグ挿入(TextArea)
	//--------------------------------------------------------------------------------
	public void insert(String str1, String str2) {
		Document doc = textArea.getDocument();
		int startPosition = textArea.getSelectionStart();
		int endPosition   = textArea.getSelectionEnd();

		try {
			int caretPosition = startPosition + str1.length();
			doc.insertString(endPosition, str2, null);
			doc.insertString(startPosition, str1, null);
			textArea.setCaretPosition(caretPosition);
			textArea.requestFocusInWindow();
		} catch (Exception e) {}
	}

	//--------------------------------------------------------------------------------
	//	TextArea フォーカス (TextArea)
	//--------------------------------------------------------------------------------
	public void setTextFocus() {
		textArea.requestFocusInWindow();
	}
	
	//--------------------------------------------------------------------------------
	//	Window リスナー
	//--------------------------------------------------------------------------------
	public void windowActivated(WindowEvent e) {
		setTextFocus();
	}
	public void	windowClosed(WindowEvent e) { }
	public void	windowClosing(WindowEvent e) {
		TextView v = (TextView)e.getWindow();

		if (v.changeFlag) {
			int ret = JOptionPane.showConfirmDialog(null, v.getTitle() + " を保存しますか?", "保存確認", JOptionPane.YES_NO_CANCEL_OPTION);
			if (ret != JOptionPane.CANCEL_OPTION) {
				v.dispose();
				JHime.ViewVector.remove(v);
				if (TextView.cnt-- == 1) {
					Configuration.save();
					System.exit(0);
				}
			}
		} else {
			v.dispose();
			JHime.ViewVector.remove(v);
			if (TextView.cnt-- == 1) {
				Configuration.save();
				System.exit(0);
			}
		}
	}
	public void	windowDeactivated(WindowEvent e) { }
	public void	windowDeiconified(WindowEvent e) { }
	public void	windowIconified(WindowEvent e) { }
	public void	windowOpened(WindowEvent e)  { }

	public String getUserDir () {
		return this.userDir;
	}

	public void setUserDir (String str) {
		this.userDir = str;
        JHime.USER_DIR = str;
	}
}