/*
 * Copyright (C) 2004 Nakai Yushi
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include<SDL.h>
#include<SDL_mixer.h>
#include<SDL_thread.h>

#include"ruby.h"

//module name
static mMP3Mixer;

static Mix_Music *music;
int current_time = 0;
SDL_Thread *timer_thread;
int kill_timer_thread = 0;

/*###################################################################
  Timer Thread's Function
  ###################################################################*/
int timer_thread_func(void *unused){
  
  while(!kill_timer_thread){
    SDL_Delay(1000);
    current_time++;
  }
  
}
/*###################################################################
  Audio Initialization
  ###################################################################*/
static VALUE MP3Mixer_initialize(VALUE self)
{
  int ret = Qtrue;
  
  if( SDL_Init(SDL_INIT_AUDIO) == -1 ){
    ret = Qfalse;
  }
  
   if( Mix_OpenAudio(44100,MIX_DEFAULT_FORMAT,2,1024) == -1){
    ret = Qfalse;
  }
    
  return ret;
}

/*###################################################################
  Audio Termination
  ###################################################################*/
static VALUE MP3Mixer_terminate(VALUE self)
{
  
  if(music != NULL){
    Mix_FreeMusic(music);
  }
  SDL_Quit();
  
  return Qnil;
}

/*###################################################################
  Play Music
  ###################################################################*/
static VALUE MP3Mixer_play(VALUE self,VALUE filepath, VALUE loop)
{
  int ret = Qtrue;
  
  music = Mix_LoadMUS(STR2CSTR(filepath));
  
  //timer thread start
  if(Mix_PlayingMusic()){
    kill_timer_thread = 1;
    SDL_WaitThread(timer_thread,NULL);
  }
  kill_timer_thread = 0;
  current_time = 0;
  timer_thread = SDL_CreateThread(timer_thread_func,NULL);
  
  
  if( Mix_PlayMusic(music,NUM2INT(loop)) == -1){
    ret = Qfalse;
  }
  
  return ret;
}

/*###################################################################
  Stop Music
  ###################################################################*/
static VALUE MP3Mixer_stop()
{
  Mix_HaltMusic();
  
  //timer thread destroy
  kill_timer_thread = 1;
  SDL_WaitThread(timer_thread,NULL);
  
  return Qtrue;
}

/*###################################################################
  Pause Music
  ###################################################################*/
static VALUE MP3Mixer_pause()
{
  Mix_PauseMusic();
  
  //timer thread destroy
  kill_timer_thread = 1;
  SDL_WaitThread(timer_thread,NULL);

  return Qnil;
}

/*###################################################################
  Resume Music
  ###################################################################*/
static VALUE MP3Mixer_resume()
{
  if(Mix_PausedMusic()){
    Mix_ResumeMusic();
  
    //timer thread resume
    if(Mix_PlayingMusic()){
      kill_timer_thread = 0;
      timer_thread = SDL_CreateThread(timer_thread_func,NULL);
    }

  }
  return Qnil;
}

/*###################################################################
  Set Music Position 
  ###################################################################*/
static VALUE MP3Mixer_set_position(VALUE self,VALUE pos){
  int ret = Qtrue;
  //set music to the start.
  Mix_RewindMusic();
  
  //Jump to <pos> seconds from start.
  if (Mix_SetMusicPosition(NUM2DBL(pos)) == -1){
    ret = Qfalse;
  }else{
    current_time = (int)(NUM2DBL(pos));
  }
  
  return ret;
}

/*###################################################################
  Get Current Time
  ###################################################################*/
static VALUE MP3Mixer_get_current_time(){
  return INT2NUM(current_time);
}

/*###################################################################
  Playing?
  ###################################################################*/
static VALUE MP3Mixer_playing(){
  int ret = Qtrue;
  if( Mix_PlayingMusic() == 0){
    ret = Qfalse;
  }
  return ret;
}
/*###################################################################
  Define Module
  ###################################################################*/
void Init_MP3Mixer()
{
  mMP3Mixer = rb_define_module("MP3Mixer");
  rb_define_module_function(mMP3Mixer,"init",MP3Mixer_initialize,0);
  rb_define_module_function(mMP3Mixer,"terminate",MP3Mixer_terminate,0);
  rb_define_module_function(mMP3Mixer,"play",MP3Mixer_play,2);
  rb_define_module_function(mMP3Mixer,"stop",MP3Mixer_stop,0);
  rb_define_module_function(mMP3Mixer,"pause",MP3Mixer_pause,0);
  rb_define_module_function(mMP3Mixer,"resume",MP3Mixer_resume,0);
  rb_define_module_function(mMP3Mixer,"playing?",MP3Mixer_playing,0);
  rb_define_module_function(mMP3Mixer,"set_position",MP3Mixer_set_position,1);
  rb_define_module_function(mMP3Mixer,"get_current_time",MP3Mixer_get_current_time,0);

  
}
