/*
 * Copyright (C) 2004 Nakai Yushi
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ruby.h"

#include<id3.h>

static mID3Tag;

VALUE get_tag(ID3_FrameID id,VALUE filename){
  VALUE ret = Qnil;
  ID3Tag *tag;
  ID3Frame *frame;
  ID3Field *field;
  
  tag = ID3Tag_New();
  ID3Tag_Link(tag,STR2CSTR(filename));
  
  frame = ID3Frame_New();
  if( !(frame = ID3Tag_FindFrameWithID(tag,id)) ){
    ret = Qnil;
  }else if( !(field = ID3Frame_GetField(frame,ID3FN_TEXT)) ){
    ret = Qnil;
  }else{
    int size = ID3Field_Size(field)+1;
    char text[size];
    ID3Field_GetASCII(field,text,size);

    ret = rb_str_new2(text);
  }
  
  
  return ret;
}

VALUE id3tag_get_title(VALUE self,VALUE filename){
  
  return get_tag(ID3FID_TITLE,filename);

}
VALUE id3tag_get_artist(VALUE self,VALUE filename){
  
  return get_tag(ID3FID_LEADARTIST,filename);

}
void Init_ID3Tag(){
  mID3Tag = rb_define_module("ID3Tag");
  rb_define_module_function(mID3Tag, "get_title", id3tag_get_title,1);
  rb_define_module_function(mID3Tag, "get_artist", id3tag_get_artist,1);
}
