=begin rdoc
 = jimpachi_gui.rb - gui for jimpachi

Author:: Kuzuno Hiroki, Nakai Yushi
Copyright:: Copyright (c) 2004 Kuzuno Hiroki, Nakai Yushi
License:: GNU General Public License version 2, or any later.
=end

require 'libglade2'
require 'player'

class Jimpachi

  # Jimpachi initialize
  # ===Parameters:
  # * path: glade file path.
  def initialize(path)
    @glade = GladeXML.new(path) {|handler| method(handler)}
    @player = Player.new()
    @file_add_fs= @glade.get_widget("file_add_fs")
    @list_add_fs= @glade.get_widget("list_add_fs")
    set_treeview
    @thread
  end

  # Play List Tree View Event
  def on_play_list_treeview_select_all(widget)
    puts "on_play_list_treeview_select_all() is not implemented yet."
  end
  
  # Play list cursor changed
  def on_play_list_treeview_cursor_changed(widget)
    #    p @model.get_value(@model, 0)
    #    p widget.cursor[0], widget.cursor[1]
    #    p @model.get_value( widget.cursor[1])
    #    p @model.get_value(@model.iter_first, 1)
    
    @music_name= @model.get_value( @model.get_iter( widget.cursor[0] ), 2)
    # p @music_name
  end

  # show music name on play list tree
  def show_tree
    p "show_tree called"
    @player.each do |music_file|
      # @model.append(nil).set_value(0, music_file.get_music_name)
      iter = @model.append(nil)
      iter[0] = music_file.get_artist_name
      iter[2] = music_file.get_music_name
      iter[3] = convert_seconds_to_minutes( music_file.get_total_time )
    end
    @treeview.set_model(@model)
  end

  # Main Window Button Event
  def on_pause_button_clicked(widget)
    @player.pause
  end

  # play button clicked event
  def on_play_button_clicked(widget)
    @player.play( @music_name ) unless @music_name == nil
    start_check_music_play( widget )
  end

  # stop button clicked event
  def on_stop_button_clicked(widget)
    @player.stop
  end

  # next button clicked event
  def on_next_button_clicked(widget)
    if next_track_filename= @player.next_music
      start_check_music_play( widget )
      #    p @treeview.cursor[0].next!
      # @treeview.set_cursor(@treeview.cursor[0].next!, nil, true)
    else
      # ꥹȤκǸäʤˤ⤷ʤ
    end
  end

  # prev button clicked event
  def on_prev_button_clicked(widget)
    if prev_track_filename= @player.prev_music
      start_check_music_play( widget )
      # @treeview.set_cursor(@treeview.cursor[0].prev!, nil, true)
    else
      # ꥹȤƬäʤˤ⤷ʤ
    end
  end

  private
  def set_treeview()
    @treeview= @glade.get_widget( "play_list_treeview" )
    @model = Gtk::TreeStore.new(String, Gdk::Color, String, String)
    # column 1 artist name
    renderer = Gtk::CellRendererText.new
    column = Gtk::TreeViewColumn.new("Artist", renderer, {
                                       :text => 0,
                                       :foreground_gdk => 1
                                   })
    @treeview.append_column(column)
    # column 2 music title name
    column = Gtk::TreeViewColumn.new("Title", renderer, {
                                       :text => 2
                                       })
    @treeview.append_column(column)
    # column 3 music total time
    column = Gtk::TreeViewColumn.new("Time", renderer, {
                                       :text => 3
                                   })
    @treeview.append_column(column)
  end

  def reverse_current_music_row
    music_name= @player.get_current_music_name
    @model.each do |model, path, iter|
      if @model.get_value( iter, 2 ) == music_name
        iter[1] = Gdk::Color.new(0, 0, 65535)
      else
        iter[1] = Gdk::Color.new(0, 0, 0)
      end
    end
  end

  def auto_update_time( widget )
    Thread.new do
      loop do
        sleep(1)
        on_total_play_timebar_text_popped(widget, 1, convert_seconds_to_minutes( @player.get_current_music_total_time ))
        on_now_play_timebar_text_popped(widget, 1, convert_seconds_to_minutes( @player.get_current_music_current_time ))
        reverse_current_music_row
      end
    end
  end

  # convert seconds format into minutes format
  # ex. 230 -> 3:50
  # ===Return:
  # minutes format
  def convert_seconds_to_minutes( seconds )
    result = seconds / 60
    remainder = seconds - result * 60
    return "#{result}:#{remainder}"
  end

  # start check current music file play status.
  def start_check_music_play( widget )
    @thread.kill unless @thread == nil
    @thread= auto_update_time( widget )
  end

  public
  # Main Window Menu Bar
  def on_add_file_activate(widget)
    @file_add_fs.show
  end

  def on_add_dir_activate(widget)
    puts "add directory"
    show_tree
  end

  def on_add_list_activate(widget)
    @list_add_fs.show
  end

  def on_del_file_activate(widget)
    puts "on_del_file_activate() is not implemented yet."
  end

  def on_del_all_activate(widget)
    puts "on_del_all_activate() is not implemented yet."
  end
  
  def on_about_activate(widget)
    about_dialog= @glade.get_widget("about_dialog")
    about_dialog.show
  end

  def on_select_all_activate(widget)
    puts "on_select_all_activate() is not implemented yet."
  end

  # Main Window Status Bar
  def on_now_play_timebar_text_pushed(widget, arg0, arg1)
  end
  
  def on_now_play_timebar_text_popped(widget, arg0, arg1)
    hoge= @glade.get_widget("now_play_timebar")
    hoge.push(arg0, arg1)
  end

  def on_total_play_timebar_text_pushed(widget, arg0, arg1)
  end

  def on_total_play_timebar_text_popped(widget, arg0, arg1)
    hoge= @glade.get_widget("total_play_timebar")
    hoge.push(arg0, arg1)
  end

  # Main Window Etc
  def on_Grmp3_destroy(widget)
    @player.stop
    Gtk.main_quit
  end

  def gtk_widget_hide(widget)
    puts "gtk_widget_hide() is not implemented yet."
  end

  # About Dialog event
  def on_about_ok_button_clicked(widget)
    about_dialog= @glade.get_widget("about_dialog")
    about_dialog.hide
  end

  # Music File Selection event
  def on_file_add_fs_cancel_button_clicked(widget)
    @file_add_fs.hide
  end

  def on_file_add_fs_ok_button_clicked(widget)
    puts "Selected filename: #{@file_add_fs.filename}"
#    @player.add_music( @file_add_fs.filename )
    @file_add_fs.hide
    show_tree
  end

  # List File Selection event
  def on_list_add_fs_cancel_button_clicked(widget)
    @list_add_fs.hide
  end

  def on_list_add_fs_ok_button_clicked(widget)
    puts "Selected filename: #{@list_add_fs.filename}"
    @player.add_list( @list_add_fs.filename )
    @list_add_fs.hide
    show_tree
  end

end

#If you use only Ruby/GTK2 widgets, call Gtk.init here. 
Gtk.init
#If you use Ruby/GNOME2 widgets, call Gnome::Program.new here. 
#Gnome::Program.new("Grmp3", "0.0.1")

# Set correct path yourself.
Jimpachi.new("jimpachi.glade")
Gtk.main
