
#mp3_info.rb - mp3 file class

# Author:: Yushi Nakai
# Copyright:: Copyright (c) 2004 Yushi Nakai
# License:: GNU General Public License version 2, or any later.

require "ID3Tag"

$HEADER_SIZE = 5120
$BITRATE_LAYER3 = ["","32","40","48","56","64","80","96","112","128","160","192","224","256","320"]

# MP3եξ뤿Υ饹
class MP3Info
   
   # filenameǤMP3եID3뤿Υ饹
   # ===Parameters
   # * filename: MP3Υե
   def initialize filename

      head = File.new(filename).read($HEADER_SIZE).unpack("B*")[0]
      index = (head =~ /11111111111/) + 12



      @ID = head[index .. index].to_i
      index += 1



      @layer = head[index+1 .. index+1].to_i
      @layer +=head[index .. index].to_i
      index += 2


      @protection_bit = head[index .. index].to_i
      index += 1


      @bitrate = head[index+3 .. index+3].to_i
      @bitrate += 2 * head[index+2 .. index+2].to_i
      @bitrate += 4 * head[index+1 .. index+1].to_i
      @bitrate += 8 * head[index .. index].to_i
      index += 4
      
      @sampling = format("%#i",head[index+1 .. index+1]).to_i
      @sampling += 2 * format("%#i",head[index .. index]).to_i


      @music_name = ID3Tag.get_title(filename)
      @artist_name = ID3Tag.get_artist(filename)
   end

   # ƥ̾
   # ===Return
   # * ƥ̾
   def get_artist_name
      return @artist_name
   end

   
   # ڶ̾
   # ===Return
   # * ڶ̾
   def get_music_name
      return @music_name
   end
   
   # ӥåȥ졼Ȥ
   # ===Return
   # * ӥåȥ졼
   def get_bitrate
      ret_value = nil

      if @layer == 1
         ret_value = $BITRATE_LAYER3[@bitrate]
      end
      
      return  ret_value
   end

   # ץ󥰼ȿ
   # ===Return
   # * ץ󥰼ȿ
   def get_sampling
      ret_value = nil
      if @sampling == 0
         ret_value = 44100
      end
      if @sampling == 1
         ret_value = 48000
      end
      if @sampling == 2
         ret_value = 32000
      end

      return ret_value
   end
end


