
#music_file.rb - mp3 file class

# Author:: Yushi Nakai
# Copyright:: Copyright (c) 2004 Yushi Nakai
# License:: GNU General Public License version 2, or any later.


require "MP3Mixer"
#require "mp3tag"
#require "mp3_header"
require "mp3_info.rb"
require "kconv"

#MP3ե11б륯饹
#
#եμȱդ˴ؤԤ
class MusicFile
   @@init = 0
   # MP3եɽ󥹥󥹤
   # ===Parameters
   # * file_name: ѥե̾
   # * file_path: ե̾ޤХѥ
   def initialize(file_name, file_path)
      @file_name =  GLib.locale_to_utf8( file_name.toeuc )
      @file_path = file_path
      # @id3tag = Mp3Tag::new(file_path)
      # @mp3header = MP3Header::new(file_path)
      @mp3info = MP3Info::new(file_path)
      @total_time = File.size(file_path).to_i * 8 / (@mp3info.get_bitrate.to_i * 1000)
      
   end

   # ʤΥӥåȥ졼Ȥ
   # ===Return
   # * ӥåȥ졼
   def get_bitrate
      #return @mp3header.get_bitrate
      return @mp3info.get_bitrate
   end

   # ʤΥץ󥰼ȿ
   # ===Return
   # * ץ󥰼ȿ
   def get_sampling
      #return @mp3header.get_sampling
      return @mp3info.get_sampling
   end

   # ID3̾
   # ===Return
   # * mp3 إå title ޤޤƤж֤̾
   #   ޤޤƤʤ file_name ֤
   def get_music_name
      if( nil == @mp3info.get_music_name )
        return @file_name
      end
      #return GLib.locale_to_utf8( @id3tag.title.toeuc )
      return GLib.locale_to_utf8( @mp3info.get_music_name.toeuc )
   end

   # ID3饢ƥ̾
   # ===Return
   # * ƥ̾
   def get_artist_name
      return @mp3info.get_artist_name
   end

   # եѥ
   # ===Return
   # *եѥ
   def get_file_path
      return @file_path
   end

   # ʤջ֤
   #===Return
   # *ջ()
   def get_total_time()
      return @total_time
   end
   
   # դƤ֤
   #===Return
   # *հ()
   def get_current_time
      return MP3Mixer.get_current_time
   end
   
   # ʤ
   # ===Parameters
   # * loop: 롼׺Ԥɤ0ʤ롼פʤ1ʤ롼פ롣
   # ===Return
   # * *true*Ԥ*false*
   def play loop
      if @@init == 0
         MP3Mixer.init
         @@init = 1
      end

      return MP3Mixer.play(@file_path,loop)
   end

   # ʤκߤ
   # ===Return
   # * *true*Ԥ*false*
   def stop
      return MP3Mixer.stop
   end
   
   # ʤκߤ
   # ===Return
   # * *true*Ԥ*false*
   def pause
      return MP3Mixer.pause
   end

   # ʤΰߤƳ
   # ===Return
   # * *true*Ԥ*false*
   def restart
      return MP3Mixer.resume
   end
   
   # ʤκ֤ꤹ
   # ===Parameters
   # * pos: ()
   # ===Return
   # * *true*Ԥ*false*
   def set_position(pos)
      return MP3Mixer.set_position(pos)
   end

   private
   def set_bitrate_and_sampling(filename)
      file = File.open(filename)
      byte = [0,0]
      while byte[0] = file.read(1)
        byte[0] = byte[0].unpack("C")
         if(byte[0] >> 5 == 7 && byte[1] == 0xFF)
            byte[1] = byte[0]
         end
      end
      
   end


end
   
