=begin rdoc
 = play_list.rb - Jimpachi play list class

 Author:: Kuzuno Hiroki, Nakai Yushi
 Copyright:: Copyright (c) 2004 Kuzuno Hiroki, Nakai Yushi
 License:: GNU General Public License version 2, or any later.
=end

require 'music_file'

# Grmp3 Play list class, include many MusicFile class
#
# add MusicFile from grmp3 list
class PlayList

  def initialize
    @music_files= []
    @index= 0
  end
  
  # add music file to @music_files.
  # ===Parameters:
  # * music_name: local music file name string
  # * file_path: absolute file path string
  # ===Return:
  # * none
  def add_music_file( music_name, file_path="" )
    if file_path =~ /mp3\z/
      @music_files.push( new_music_file( music_name, file_path ))
    else
      p "ERROR NOT mp3 file!!"
    end
  end

  # add music file from  grmp3 list.
  # ===Parameters:
  # * lst_fname: grmp3 list file name string
  # ===Return:
  # * none
  def add_list( lst_fname )
    p lst_fname
    File.foreach( lst_fname ) do |line|
      # ѥե̾Хѥˤ櫓 6/06
      line.chomp!
      line_split= line.split(",")
      if line_split.size == 2
        add_music_file( line_split[0], line_split[1] ) 
      else
        p "ERROR FORMAT ERROR"
      end
    end
  end

  # delete music file from @music_files.
  # ===Parameters:
  # * music_files: MusicFile class
  def delete_music_file( music_file )
    if @music_files.include?( music_file.get_music_name )
      @music_files.delete( music_file )
    end
  end

  # clear @music_files
  def delete_list
    @music_files.clear
  end

  # return play list at @music_files
  # ===Return:
  # return @music_files.
  def get_list
    return @music_files
  end

  def swap_up
  end

  def swap_down
  end

  # check specific music file or title in play list.
  # ===Parameters:
  # * music_name: music file name string or title string.
  # ===Return:
  # * *true* on music exist, *false* on music does not exist.
  def include?( music_name )
    @music_files.each do | music_file |
      if( music_file.get_music_name == music_name )
        return true
      end
    end
    return false
  end

  # return next music_file
  # ===Return:
  # return false on index is list end, 
  # return music_file on index is not end.
  def get_next
    if @index != @music_files.size
      @index += 1
      return @music_files[@index]
    end
    return false
  end

  # return prev music_file
  # ===Return:
  # return false on index is 0, 
  # return music_file on index is not top.
  def get_prev
    if @index != 0
      @index -= 1
      return @music_files[@index]
    end
    return false
  end

  # set playlist index number
  def set_index( index )
    @index = index
  end

  private
  def new_music_file( music_name="", file_path="")
    return MusicFile.new( music_name, file_path )
  end
end
