=begin rdoc
 = player.rb - Jimpachi core

Author:: Kuzuno Hiroki, Nakai Yushi
Copyright:: Copyright (c) 2004 Kuzuno Hiroki, Nakai Yushi
License:: GNU General Public License version 2, or any later.

=end

require 'play_list'
require 'MP3Mixer'
require 'thread'

class Player

  def initialize
    @playlists = []
    @playlist_index = 0
    @music_file
    @loop = 0
    @thread
  end

  # play next music file in current playlist
  # ===Return:
  # @music_file.get_music_name: if playlist is not end
  # next music file title.
  # flase on playlist index is end.
  def next_music
    if @music_file= @playlists[@playlist_index].get_next
      play_music_file
      return @music_file.get_music_name
    end
    return false
  end

  # play prev music file in current playlist
  # ===Return:
  # @music_file.get_music_name: if playlist is not top
  # next music file title.
  # false on index in playlist is top.
  def prev_music
    if @music_file= @playlists[@playlist_index].get_prev
      play_music_file
      return @music_file.get_music_name
    end
    return false
  end

  # play music file
  # ===Parameters:
  # * music_name: music_file title in playlist.
  def play( music_name )
    index = 0
    @music_files= @playlists[@playlist_index].get_list
    @music_files.each do |music_file|
      if music_file.get_music_name == music_name
        @playlists[@playlist_index].set_index( index )
        @music_file = music_file
        play_music_file
        break
      end
      index += 1
    end
  end

  def stop
    if MP3Mixer::playing? 
      @music_file.stop 
      @thread.kill
    end
  end

  def pause
    @music_file.pause
  end

  def seek
  end

  def change_list
  end

  def each
    music_files= @playlists[@playlist_index].get_list
    music_files.each do |music_file|
      yield( music_file )
    end
  end

  # Add new jimpachilist
  # ===Parameters:
  # * list_name: list file path
  def add_list( list_name )
    playlist= PlayList.new()
    playlist.add_list( list_name )
    @playlists.push( playlist )
  end

  # return current play music file name.
  def get_current_music_name
    return @music_file.get_music_name
  end

  def get_current_music_total_time
    return @music_file.get_total_time
  end

  def get_current_music_current_time
    return @music_file.get_current_time
  end

  private
  # if current play music exit, auto play next music 
  def auto_next
    Thread.new do
      loop do
        sleep(0.1)
        next_music until MP3Mixer::playing? 
      end
    end
  end

  # play music file
  def play_music_file
    @music_file.stop unless @music_file == nil
    @music_file.play(@loop)
    @thread.kill unless @thread == nil
    @thread = auto_next
  end

end
