/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Highlighter;
import jp.sourceforge.jindolf.AnchorListener;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.JdfEditorKit;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.TopicFilter;
import jp.sourceforge.jindolf.Village;

public class JdfBrowser
extends JEditorPane {
    private static final Highlighter.HighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(0xD02020));
    private Village village;
    private Period period;
    private TopicFilter.FilterContext filterContext;

    public JdfBrowser(Period period) {
        this.setEditable(false);
        this.setContentType("text/html");
        this.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        this.setPeriod(period);
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        HyperlinkListener[] listeners;
        if (period == this.period) {
            return;
        }
        this.period = period;
        this.setText("");
        this.filterContext = null;
        if (this.period == null) {
            return;
        }
        if (period.getVillage() == this.village) {
            return;
        }
        this.village = period.getVillage();
        JdfEditorKit kit = new JdfEditorKit(this.village);
        this.setEditorKit(kit);
        for (HyperlinkListener listener : listeners = this.getHyperlinkListeners()) {
            this.removeHyperlinkListener(listener);
        }
        this.addHyperlinkListener(new AnchorListener(this.village));
    }

    public void applyFilter(TopicFilter filter, boolean force) {
        if (!force && filter.isSame(this.filterContext)) {
            return;
        }
        CharSequence html = this.period.buildJdfHTML(filter);
        this.setCharSequence(html);
        this.filterContext = filter.getFilterContext();
    }

    private void setCharSequence(CharSequence html) {
        Document doc;
        block4: {
            StringReader reader = html != null ? new StringReader(((Object)html).toString()) : new StringReader("");
            EditorKit kit = this.getEditorKit();
            doc = kit.createDefaultDocument();
            try {
                kit.read(reader, doc, 0);
            }
            catch (IOException e) {
                assert (false);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        this.setDocument(doc);
    }

    public void highlightRegex(Pattern pattern) {
        int endPos;
        int startPos;
        String text;
        Highlighter.Highlight[] highlights;
        if (pattern == null) {
            return;
        }
        Highlighter highlighter = this.getHighlighter();
        for (Highlighter.Highlight highlight : highlights = highlighter.getHighlights()) {
            if (highlight.getPainter() != highlightPainter) continue;
            highlighter.removeHighlight(highlight);
        }
        Document doc = this.getDocument();
        int docLength = doc.getLength();
        try {
            text = doc.getText(0, docLength);
        }
        catch (BadLocationException e) {
            assert (false);
            return;
        }
        Matcher matcher = pattern.matcher(text);
        matcher.region(0, docLength);
        while (matcher.find() && (startPos = matcher.start()) != (endPos = matcher.end())) {
            matcher.region(endPos, docLength);
            try {
                highlighter.addHighlight(startPos, endPos, highlightPainter);
            }
            catch (BadLocationException e) {
                assert (false);
                return;
            }
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(GUIUtils.getDefaultHints());
        super.paint(g);
    }
}

