/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.StyleSheet;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Talk;

public class TopicView
extends BlockView {
    private static int ROUNDRADIUS = 8;
    private static int BALOONTIP_WIDTH = 16;
    private static int BALOONTIP_HEIGHT = 8;
    private static Color COLOR_PUBLIC = new Color(0xFFFFFF);
    private static Color COLOR_WOLFONLY = new Color(0xFF7777);
    private static Color COLOR_PRIVATE = new Color(0x939393);
    private static Color COLOR_GRAVE = new Color(10467279);
    private static Color COLOR_TRANS = new Color(0, 0, 0, 0);
    private static RenderingHints renderHints = GUIUtils.getQualityHints();
    private static BufferedImage BALOON_PUBLIC = TopicView.createWedgeImage(COLOR_PUBLIC);
    private static BufferedImage BALOON_WOLFONLY = TopicView.createBubbleImage(COLOR_WOLFONLY);
    private static BufferedImage BALOON_GRAVE;
    private static BufferedImage BALOON_PRIVATE;
    private Talk.Type type;

    private static BufferedImage createWedgeImage(Color color) {
        BufferedImage image = new BufferedImage(BALOONTIP_WIDTH, BALOONTIP_HEIGHT, 2);
        Graphics2D g2 = image.createGraphics();
        g2.addRenderingHints(renderHints);
        g2.setColor(COLOR_TRANS);
        g2.fillRect(0, 0, BALOONTIP_WIDTH, BALOONTIP_HEIGHT);
        g2.setColor(color);
        Polygon poly = new Polygon();
        poly.addPoint(8, 8);
        poly.addPoint(16, 8);
        poly.addPoint(16, 0);
        g2.fillPolygon(poly);
        return image;
    }

    private static BufferedImage createBubbleImage(Color color) {
        BufferedImage image = new BufferedImage(BALOONTIP_WIDTH, BALOONTIP_HEIGHT, 2);
        Graphics2D g2 = image.createGraphics();
        g2.addRenderingHints(renderHints);
        g2.setColor(COLOR_TRANS);
        g2.fillRect(0, 0, BALOONTIP_WIDTH, BALOONTIP_HEIGHT);
        g2.setColor(color);
        g2.fillOval(2, 4, 4, 4);
        g2.fillOval(8, 2, 6, 6);
        return image;
    }

    public TopicView(Element elem, Talk.Type type) {
        super(elem, 1);
        this.type = type;
    }

    public TopicView(Element elem) {
        this(elem, null);
    }

    private void drawBaloon(Graphics2D g2, Rectangle bounds) {
        BufferedImage tip;
        StyleSheet styleSheet = this.getStyleSheet();
        AttributeSet vattr = styleSheet.getViewAttributes(this);
        Color bgColor = styleSheet.getBackground(vattr);
        g2.setColor(bgColor);
        g2.fillRoundRect(bounds.x + BALOONTIP_WIDTH, bounds.y, bounds.width - BALOONTIP_WIDTH, bounds.height, ROUNDRADIUS * 2, ROUNDRADIUS * 2);
        switch (this.type) {
            case WOLFONLY: {
                tip = BALOON_WOLFONLY;
                break;
            }
            case PUBLIC: {
                tip = BALOON_PUBLIC;
                break;
            }
            case GRAVE: {
                tip = BALOON_GRAVE;
                break;
            }
            case PRIVATE: {
                tip = BALOON_PRIVATE;
                break;
            }
            default: {
                tip = null;
                assert (false);
                break;
            }
        }
        g2.drawImage((Image)tip, bounds.x, bounds.y + (bounds.height - BALOONTIP_HEIGHT) / 2, null);
    }

    private void drawBorder(Graphics2D g2, Rectangle bounds) {
        StyleSheet styleSheet = this.getStyleSheet();
        AttributeSet vattr = styleSheet.getViewAttributes(this);
        Color fgColor = styleSheet.getForeground(vattr);
        g2.setColor(fgColor);
        g2.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    private void drawContent(Graphics2D g2, Rectangle bounds) {
        int ix = bounds.x + this.getLeftInset();
        int iy = bounds.y + this.getTopInset();
        Rectangle clip = g2.getClipBounds();
        Rectangle allocChild = new Rectangle();
        int viewMax = this.getViewCount();
        for (int viewNo = 0; viewNo < viewMax; ++viewNo) {
            allocChild.setBounds(ix + this.getOffset(0, viewNo), iy + this.getOffset(1, viewNo), this.getSpan(0, viewNo), this.getSpan(1, viewNo));
            if (!allocChild.intersects(clip)) continue;
            this.paintChild(g2, allocChild, viewNo);
        }
    }

    public void paint(Graphics g, Shape allocation) {
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(GUIUtils.getDefaultHints());
        Rectangle bounds = allocation.getBounds();
        g2.setColor(COLOR_TRANS);
        g2.fill(bounds);
        if (this.type != null) {
            this.drawBaloon(g2, bounds);
        } else {
            this.drawBorder(g2, bounds);
        }
        this.drawContent(g2, bounds);
    }

    static {
        BALOON_PRIVATE = TopicView.createBubbleImage(COLOR_PRIVATE);
        BALOON_GRAVE = TopicView.createBubbleImage(COLOR_GRAVE);
    }
}

