/*
 * characters in village
 * 
 * Copyright(c) 2008 olyutorskii
 * $Id: Avatar.java 3 2008-06-11 15:08:13Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Avatar またの名をキャラクター
 */
public class Avatar {
    
    private static final List<Avatar> predefinedAvatars =
            Collections.unmodifiableList( Arrays.asList(
    new Avatar("楽天家 ゲルト", 1),
    new Avatar("村長 ヴァルター", 2),
    new Avatar("老人 モーリッツ", 3),
    new Avatar("神父 ジムゾン", 4),
    new Avatar("木こり トーマス", 5),
    new Avatar("旅人 ニコラス", 6),
    new Avatar("ならず者 ディーター", 7),
    new Avatar("少年 ペーター", 8),
    new Avatar("少女 リーザ", 9),
    new Avatar("行商人 アルビン", 10),
    new Avatar("羊飼い カタリナ", 11),
    new Avatar("パン屋 オットー", 12),
    new Avatar("青年 ヨアヒム", 13),
    new Avatar("村娘 パメラ", 14),
    new Avatar("農夫 ヤコブ", 15),
    new Avatar("宿屋の女主人 レジーナ", 16),
    new Avatar("シスター フリーデル", 17),
    new Avatar("仕立て屋 エルナ", 18),
    new Avatar("司書 クララ", 19),
    new Avatar("負傷兵 シモン", 20)
    ) );

    private static final Map<String, Avatar> avatarMap;

    static{
        Map<String, Avatar> map = new HashMap<String,Avatar>();
        for(Avatar avatar : predefinedAvatars){
            String fullName = avatar.getFullName();
            map.put(fullName, avatar);
        }
        avatarMap = Collections.unmodifiableMap(map);
    }

    private final String fullName;
    private final String jobTitle;
    private final String name;
    private final int idNum;
    // TODO 識別子用のシンプルなアルファベット表記も欲しい
    
    /**
     * 定義済みAvatar群のリストを返す。
     * @return Avatarのリスト
     */
    public static List<Avatar> getPredefinedAvatars(){
        return predefinedAvatars;
    }
    
    /**
     * 定義済みAvatarを返す。
     * @param fullName Avatarのフルネーム
     * @return Avatar
     */
    public static Avatar getPredefinedAvatar(String fullName){
        return avatarMap.get(fullName);
    }
    
    /**
     * Avatarを生成する。
     * @param fullName フルネーム
     * @param idNum 通し番号
     */
    private Avatar(String fullName, int idNum){
        if(fullName == null) throw new NullPointerException();
        this.fullName = fullName;
        this.idNum = idNum;
        
        String[] tokens = this.fullName.split("\\p{Blank}+", 2);
        if(tokens.length == 1){
            this.jobTitle = null;
            this.name = this.fullName;
        }else if(tokens.length == 2){
            this.jobTitle = tokens[0];
            this.name = tokens[1];
        }else{
            this.jobTitle = null;
            this.name = null;
            assert false;
        }

        return;
    }
    
    /**
     * Avatarを生成する
     * @param fullName フルネーム
     */
    public Avatar(String fullName){
        this(fullName, -1);
        return;
    }
    
    /**
     * フルネームを取得する。
     * @return フルネーム
     */
    public String getFullName(){
        return this.fullName;
    }
    
    /**
     * 職業名を取得する。
     * @return 職業名
     */
    public String getJobTitle(){
        return this.jobTitle;
    }
    
    /**
     * 通常名を取得する。
     * @return 通常名
     */
    public String getName(){
        return this.name;
    }
    
    /**
     * 内部ブラウザ向けにIMGタグを生成する。
     * @return HTML断片
     */
    public CharSequence buildJdfHTMLImg(){
        StringBuilder imgTag = new StringBuilder();

        imgTag.append("<img avatar=\"");
        imgTag.append(getFullName());
        imgTag.append("\">");
        imgTag.append("</img>");

        return imgTag;
    }
}
