/*
 * HTML Utilities
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: HTMLUtils.java 3 2008-06-11 15:08:13Z olyutorskii $
 */

package jp.sourceforge.jindolf;

/**
 * HTML ユーティリティ群
 */
public class HTMLUtils{

    /**
     * 隠しコンストラクタ
     */
    private HTMLUtils(){
        super();
        return;
    }

    /**
     * 任意の文字列を任意の属性値を持つ任意の名前のタグで囲む。
     * @param elementName タグ名
     * @param attrName 属性名
     * @param attrValue 属性値
     * @param content 囲まれる文字列
     * @return 囲まれた文字列
     */
    public static StringBuilder elemented(CharSequence elementName,
                                             CharSequence attrName,
                                             CharSequence attrValue,
                                             CharSequence content){
        StringBuilder result = new StringBuilder();

        result.append("<").append(elementName);
        if(attrName != null){
            result.append(" ").append(attrName).append("=\"");
            if(attrValue != null){
                result.append(attrValue);
            }else{
                result.append(attrName);
            }
            result.append("\"");
        }
        result.append(">");
        result.append(content);  // TODO need &amp; encoding
        result.append("</").append(elementName).append(">");

        return result;
    }

    /**
     * 任意の文字列を任意のクラス名を持つ任意の名前のタグで囲む。
     * @param elementName タグ名
     * @param className クラス名
     * @param content 囲まれる文字列
     * @return 囲まれた文字列
     */
    public static StringBuilder elemented(CharSequence elementName,
                                           CharSequence className,
                                           CharSequence content){
        return elemented(elementName, "class", className, content);
    }

    /**
     * 任意の文字列を任意の名前のタグで囲む。
     * @param elementName タグ名
     * @param content 囲まれる文字列
     * @return 囲まれた文字列
     */
    public static StringBuilder elemented(CharSequence elementName,
                                           CharSequence content){
        return elemented(elementName, null, null, content);
    }
}
