/*
 * Jindolf view-factory
 * 
 * Copyright(c) 2008 olyutorskii
 * $Id: JdfViewFactory.java 3 2008-06-11 15:08:13Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Image;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit.HTMLFactory;

/**
 * 内部ブラウザ向けに HTML Element -> View 変換を行う。
 */
public class JdfViewFactory extends HTMLFactory{
    private Village village;

    /**
     * 村指定と共にファクトリ生成。
     * @param village 村
     */
    public JdfViewFactory(Village village){
        super();
        this.village = village;
        return;
    }

    /**
     * Element から View への変換。
     * @param elem 内部ブラウザ向けHTML Element
     * @return View（カスタム化したものを含む）
     */
    @Override
    public View create(Element elem){
        AttributeSet attr = elem.getAttributes();
        
        AttributeSet attrAnchor = (AttributeSet)( attr.getAttribute(HTML.Tag.A) );
        if(attrAnchor != null){
            String href = (String)( attrAnchor.getAttribute(HTML.Attribute.HREF) );
            if(href == null){
                return super.create(elem);
            }
            return new AnchorView(elem);
        }
        
        Object obj = attr.getAttribute(StyleConstants.NameAttribute);
        if(obj instanceof HTML.Tag){
            HTML.Tag kind = (HTML.Tag) obj;
            if(kind == HTML.Tag.IMG){
                Object objClass = attr.getAttribute("avatar");
                String fullName = (String) objClass;
                if(fullName == null){
                    return super.create(elem);
                }
                Image image;
                if(fullName.equals("GRAVE")){
                    image = village.getGraveImage();
                }else{
                    Avatar avatar = village.getAvatar(fullName);
                    image = village.getAvatarFaceImage(avatar);
                }
                return new AvatarView(elem, image);
            }
            if(kind == HTML.Tag.DIV){
                Object objClass = attr.getAttribute(HTML.Attribute.CLASS);
                String attrClass = (String) objClass;
                if(attrClass == null){
                    return super.create(elem);
                }
                if(attrClass.equals("topic")){
                    View view = new TopicView(elem);
                    return view;
                }
                if(attrClass.equals("public")){
                    View view = new TopicView(elem, Talk.Type.PUBLIC);
                    return view;
                }
                if(attrClass.equals("grave")){
                    View view = new TopicView(elem, Talk.Type.GRAVE);
                    return view;
                }
                if(attrClass.equals("wolfonly")){
                    View view = new TopicView(elem, Talk.Type.WOLFONLY);
                    return view;
                }
                if(attrClass.equals("private")){
                    View view = new TopicView(elem, Talk.Type.PRIVATE);
                    return view;
                }
            }
        }

        return super.create(elem);
    }
}
