/* 
 * Network Utilities
 * 
 * Copyright(c) 2008 olyutorskii
 * $Id: NetUtil.java 3 2008-06-11 15:08:13Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * ネットワーク関連のユーティリティ
 */
// TODO はっきりいって、もうなくしたい
public class NetUtil {
    
    /**
     * AタグのHREF属性値からクエリー部を抽出する。
     * @param hrefValue HREF属性値
     * @return クエリー文字列
     */
    public static String getQueryFromHREF(CharSequence hrefValue){
        if(hrefValue == null) return null;
        
        // HTML 4.01 B.2.2 rule
        String pureHREF = hrefValue.toString().replace("&amp;","&");

        URI uri;
        try{
            uri = new URI(pureHREF);
        }catch(URISyntaxException e){
            return null;
        }

        String allQuery = uri.getRawQuery();

        return allQuery;
    }
    
    /**
     * 隠しコンストラクタ
     */
    private NetUtil(){
        super();
        return;
    }
}
