/*
 * Topic filter
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: TopicFilter.java 3 2008-06-11 15:08:13Z olyutorskii $
 */

package jp.sourceforge.jindolf;

/**
 * 発言Topicのフィルタリングを行うインタフェース。
 */
public interface TopicFilter {
    
    /**
     * フィルタの状態を表すインタフェース
     */
    public interface FilterContext{}

    /**
     * 与えられたTopic発言をフィルタリングする。
     * @param topic Topic発言
     * @return フィルタリングするならtrue
     */
    public boolean isFiltered(Topic topic);
    
    /**
     * フィルタの内部状態を表すインスタンスを取得する。
     * @return フィルタの内部状態
     */
    public FilterContext getFilterContext();
    
    /**
     * 以前得られたフィルタ内部状態と同じフィルタリング条件を
     * 現在も保っているか判別する。
     * @param context フィルタの内部状態
     * @return 同じ状態ならtrue
     */
    public boolean isSame(FilterContext context);
}
