/*
 * unshare-styled HTML Editor kit
 * 
 * Copyright(c) 2008 olyutorskii
 * $Id: UnshareStyleEditorKit.java 3 2008-06-11 15:08:13Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

/**
 * インスタンス間でスタイルシートを共有しないHTMLEDitorKit。
 */
@SuppressWarnings("serial")
public class UnshareStyleEditorKit extends HTMLEditorKit{
    
    private StyleSheet styleSheet;

    /**
     * インスタンスを生成する。
     */
    // TODO StyleSheetのcloneはできないものか...シリアライズ経由？
    public UnshareStyleEditorKit(){
        super();

        // とりあえず最初は共有
        StyleSheet originalStyle = super.getStyleSheet();
        if(originalStyle == null) originalStyle = new StyleSheet();
        
        this.styleSheet = originalStyle;

        return;
    }

    /**
     * スタイルシートを取り出す。
     * @return スタイルシート
     */
    @Override
    public StyleSheet getStyleSheet(){
        return this.styleSheet;
    }

    /**
     * スタイルシートを設定する。
     * @param s スタイルシート
     */
    @Override
    public void setStyleSheet(StyleSheet s){
        this.styleSheet = s;
        return;
    }
}
