/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import jp.sourceforge.jindolf.AccountPanel;
import jp.sourceforge.jindolf.FilterPanel;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.JdfBrowser;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.LandsModel;
import jp.sourceforge.jindolf.MenuManager;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.TabBrowser;
import jp.sourceforge.jindolf.TopFrameView;
import jp.sourceforge.jindolf.UnshareStyleEditorKit;
import jp.sourceforge.jindolf.Village;

public class Controller
implements ActionListener,
TreeWillExpandListener,
TreeSelectionListener,
ChangeListener {
    private MenuManager menuManager;
    private TopFrameView topFrame;
    private LandsModel model;
    private JFrame helpFrame;
    private FilterPanel filterFrame;
    private AccountPanel accountFrame;

    public Controller(MenuManager menuManager, TopFrameView topFrame, LandsModel model) {
        this.menuManager = menuManager;
        this.topFrame = topFrame;
        this.model = model;
        this.menuManager.addActionListener(this);
        JTree treeView = topFrame.getLandTree();
        treeView.setModel(model);
        treeView.addTreeWillExpandListener(this);
        treeView.addTreeSelectionListener(this);
        topFrame.getTabBrowser().addChangeListener(this);
        topFrame.getReloadButton().addActionListener(this);
        topFrame.getSearchButton().addActionListener(this);
        this.filterFrame = new FilterPanel();
        this.filterFrame.addChangeListener(this);
        this.filterFrame.pack();
        this.filterFrame.setVisible(false);
    }

    private void searchPeriod() {
        this.updatePeriod(false);
    }

    private Pattern currentPattern() {
        Pattern pattern;
        JComboBox box = this.topFrame.getFindBox();
        Object selected = box.getSelectedItem();
        if (selected == null) {
            return null;
        }
        String searchString = selected.toString();
        if (searchString.length() <= 0) {
            return null;
        }
        try {
            pattern = Pattern.compile(searchString, 32);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        return pattern;
    }

    private void updatePeriod(final boolean force) {
        final Village village = this.topFrame.currentVillage();
        if (village == null) {
            return;
        }
        this.topFrame.setFrameTitle(village.getVillageName());
        final TabBrowser tabBrowser = this.topFrame.getTabBrowser();
        final JdfBrowser browser = this.topFrame.currentJdfBrowser();
        if (browser == null) {
            return;
        }
        final Period period = browser.getPeriod();
        if (period == null) {
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.topFrame.setEnabled(false);
                try {
                    boolean wasHot = this.loadPeriod();
                    Thread.yield();
                    if (wasHot && !period.isHot()) {
                        village.updatePeriodList();
                        tabBrowser.setVillage(village);
                    }
                    Thread.yield();
                    this.renderBrowser();
                }
                finally {
                    Controller.this.topFrame.setEnabled(true);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean loadPeriod() {
                boolean wasHot;
                Controller.this.topFrame.setBusy("1\u65e5\u5206\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059\u2026", true);
                try {
                    wasHot = period.isHot();
                    period.loadPeriod(force);
                }
                finally {
                    Controller.this.topFrame.setBusy("1\u65e5\u5206\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u7d42\u308f\u308a\u307e\u3057\u305f", false);
                }
                return wasHot;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void renderBrowser() {
                Controller.this.topFrame.setBusy("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u4e2d\u2026", true);
                try {
                    browser.showTopics(Controller.this.filterFrame, force);
                    browser.highlightRegex(Controller.this.currentPattern());
                }
                finally {
                    Controller.this.topFrame.setBusy("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u5b8c\u4e86", false);
                }
            }
        }.start();
        Thread.yield();
    }

    private void filterChanged() {
        final JdfBrowser jdfBrowser = this.topFrame.currentJdfBrowser();
        if (jdfBrowser == null) {
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.topFrame.setEnabled(false);
                Controller.this.topFrame.setBusy("\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u4e2d\u2026", true);
                try {
                    jdfBrowser.filtering(Controller.this.filterFrame);
                }
                finally {
                    Controller.this.topFrame.setBusy("\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u5b8c\u4e86", false);
                    Controller.this.topFrame.setEnabled(true);
                }
            }
        }.start();
    }

    private void changeLandF() {
        LookAndFeel lnf;
        String className = this.menuManager.getSelectedLookAndFeel();
        try {
            Class<?> lnfClass = Class.forName(className);
            Object lnfObj = lnfClass.newInstance();
            if (!(lnfObj instanceof LookAndFeel)) {
                return;
            }
            lnf = (LookAndFeel)lnfObj;
        }
        catch (ClassNotFoundException e) {
            return;
        }
        catch (InstantiationException e) {
            return;
        }
        catch (IllegalAccessException e) {
            return;
        }
        try {
            UIManager.setLookAndFeel(lnf);
        }
        catch (UnsupportedLookAndFeelException e) {
            return;
        }
        SwingUtilities.updateComponentTreeUI(this.topFrame);
        this.topFrame.validate();
        if (this.helpFrame != null) {
            SwingUtilities.updateComponentTreeUI(this.helpFrame);
            this.helpFrame.validate();
        }
        if (this.filterFrame != null) {
            SwingUtilities.updateComponentTreeUI(this.filterFrame);
            this.filterFrame.validate();
            this.filterFrame.pack();
        }
        if (this.accountFrame != null) {
            SwingUtilities.updateComponentTreeUI(this.accountFrame);
            this.accountFrame.validate();
            this.accountFrame.pack();
        }
    }

    private void doExit() {
        Jindolf.exit(0);
    }

    private void toggleFrame(JFrame frame) {
        if (frame == null) {
            return;
        }
        if (frame.isVisible()) {
            frame.setVisible(false);
            frame.dispose();
        } else {
            frame.setVisible(true);
        }
    }

    private void showFilter() {
        this.toggleFrame(this.filterFrame);
    }

    private void showAccount() {
        if (this.accountFrame != null) {
            this.toggleFrame(this.accountFrame);
            return;
        }
        this.accountFrame = new AccountPanel(this.model);
        this.accountFrame.pack();
        this.accountFrame.setVisible(true);
    }

    private void showHelp() {
        if (this.helpFrame != null) {
            this.toggleFrame(this.helpFrame);
            return;
        }
        this.helpFrame = new JFrame(Jindolf.title + " \u30d8\u30eb\u30d7");
        this.helpFrame.setResizable(true);
        Toolkit kit = this.helpFrame.getToolkit();
        kit.setDynamicLayout(false);
        this.helpFrame.setIconImage(GUIUtils.getWindowIconImage());
        this.helpFrame.setLocationByPlatform(true);
        UnshareStyleEditorKit editorKit = new UnshareStyleEditorKit();
        JEditorPane edit = new JEditorPane();
        edit.setEditorKit(editorKit);
        edit.setEditable(false);
        edit.setContentType("text/html");
        edit.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        edit.setBorder(new EmptyBorder(0, 0, 0, 0));
        URL htmlurl = this.getClass().getResource("resources/help.html");
        try {
            edit.setPage(htmlurl);
        }
        catch (IOException e) {
            this.helpFrame = null;
            return;
        }
        JScrollPane sc = new JScrollPane(edit);
        Container content = this.helpFrame.getContentPane();
        content.add(sc);
        this.helpFrame.pack();
        this.helpFrame.setSize(450, 450);
        this.helpFrame.setVisible(true);
    }

    private void showAbout() {
        String message = Jindolf.title + "   Version " + "2.1.8" + "\n" + Jindolf.copyright + "\n" + "\u30e9\u30a4\u30bb\u30f3\u30b9: " + "The MIT License" + "\n" + "\u9023\u7d61\u5148: " + "http://jindolf.sourceforge.jp/";
        JOptionPane pane = new JOptionPane(message, 1, -1, GUIUtils.getLogoIcon());
        JDialog dialog = pane.createDialog(this.topFrame, Jindolf.title + "\u306b\u3064\u3044\u3066");
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getNewLeadSelectionPath();
        Object selobj = path.getLastPathComponent();
        if (selobj instanceof Land) {
            Land land = (Land)selobj;
            this.topFrame.showLandInfo(land);
            return;
        }
        if (selobj instanceof Village) {
            Village village = (Village)selobj;
            village.updatePeriodList();
            this.topFrame.showVillageInfo(village);
        }
    }

    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source == this.filterFrame) {
            this.filterChanged();
        } else if (source instanceof TabBrowser) {
            this.updatePeriod(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ABOUT")) {
            this.showAbout();
        } else if (cmd.equals("EXIT")) {
            this.doExit();
        } else if (cmd.equals("LANDF")) {
            this.changeLandF();
        } else if (cmd.equals("HELPDOC")) {
            this.showHelp();
        } else if (cmd.equals("FILTER")) {
            this.showFilter();
        } else if (cmd.equals("ACCOUNT")) {
            this.showAccount();
        } else if (cmd.equals("RELOAD")) {
            this.updatePeriod(true);
        } else if (cmd.equals("SEARCH")) {
            this.searchPeriod();
        }
    }

    public void treeWillCollapse(TreeExpansionEvent event) {
    }

    public void treeWillExpand(TreeExpansionEvent event) {
        if (!(event.getSource() instanceof JTree)) {
            return;
        }
        TreePath path = event.getPath();
        Object lastObj = path.getLastPathComponent();
        if (!(lastObj instanceof Land)) {
            return;
        }
        final Land land = (Land)lastObj;
        if (land.getVillageCount() > 0) {
            return;
        }
        new Thread(){

            public void run() {
                Controller.this.topFrame.setEnabled(false);
                Controller.this.topFrame.setBusy("\u6751\u4e00\u89a7\u3092\u8aad\u307f\u8fbc\u307f\u4e2d\u2026", true);
                Controller.this.model.loadVillageList(land);
                Controller.this.topFrame.setBusy("\u6751\u4e00\u89a7\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86", false);
                Controller.this.topFrame.setEnabled(true);
            }
        }.start();
    }
}

