/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Jindolf;

public class HttpUtils {
    private static String tokenRegex = "([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)";
    private static String mtypeRegex = "[\\p{Blank}]*" + tokenRegex + "/" + tokenRegex + "[\\p{Blank}]*";
    private static String paramRegex = "[\\p{Blank}]*;[\\p{Blank}]*" + tokenRegex + "[\\p{Blank}]*=[\\p{Blank}]*" + "(" + tokenRegex + "|" + "(\"[^\\p{Cntrl}\\\"]*\")" + ")";
    private static Pattern mtypePattern = Pattern.compile(mtypeRegex);
    private static Pattern attrPattern = Pattern.compile(paramRegex);
    public static String httpImplement = HttpUtils.getHttpImplementName();

    public static String getHttpImplementName() {
        URL dummyURL = null;
        try {
            dummyURL = new URL("http://0.0.0.0/");
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        URLConnection connection = null;
        try {
            connection = dummyURL.openConnection();
        }
        catch (IOException e) {
            // empty catch block
        }
        Class<?> klass = connection.getClass();
        String implement = klass.getName();
        return implement;
    }

    public static String getUserAgentName() {
        String arch = null;
        String osname = null;
        String osver = null;
        String jrever = null;
        String jrevendor = null;
        try {
            arch = System.getProperty("os.arch");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            osver = System.getProperty("os.version");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            osname = System.getProperty("os.name");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            jrever = System.getProperty("java.version");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            jrevendor = System.getProperty("java.vendor");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        String agent = Jindolf.title + "/" + "2.1.8";
        return agent;
    }

    public static String getHTMLCharset(URLConnection connection) {
        String contentType = connection.getContentType();
        if (contentType == null) {
            return null;
        }
        return HttpUtils.getHTMLCharset(contentType);
    }

    public static String getHTMLCharset(String contentType) {
        Matcher matcher = mtypePattern.matcher(contentType);
        boolean matchResult = matcher.lookingAt();
        if (!matchResult) {
            return null;
        }
        int lastPos = matcher.end();
        String type = matcher.group(1);
        String subtype = matcher.group(2);
        if (!type.equalsIgnoreCase("text")) {
            return null;
        }
        if (!subtype.equalsIgnoreCase("html")) {
            return null;
        }
        matcher.usePattern(attrPattern);
        String charset = null;
        while (matchResult = matcher.find(lastPos)) {
            lastPos = matcher.end();
            String attribute = matcher.group(1);
            String value = matcher.group(2);
            if (!attribute.equalsIgnoreCase("charset")) continue;
            charset = value;
        }
        return charset;
    }

    private HttpUtils() {
    }
}

