/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import jp.sourceforge.jindolf.JdfBrowser;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Village;

public class TabBrowser
extends JTabbedPane {
    private Village village;
    private final JTextArea villageInfo = new JTextArea();

    public TabBrowser() {
        this.setTabPlacement(1);
        this.setTabLayoutPolicy(0);
        this.villageInfo.setEditable(false);
        this.addTab("\u6751\u60c5\u5831", this.villageInfo);
        this.setVillage(null);
    }

    private void updateVillageInfo() {
        if (this.getVillage() == null) {
            this.villageInfo.setText("no village");
            return;
        }
        StringBuilder info = new StringBuilder();
        Land land = this.getVillage().getParentLand();
        Village target = this.getVillage();
        info.append("\u56fd\u540d :\t").append(land.getLandName()).append('\n');
        info.append("\u6751\u540d :\t").append(target.getVillageName()).append('\n');
        info.append("\u6751ID :\t").append(target.getVillageID()).append('\n');
        info.append("\u72b6\u614b :\t");
        switch (this.getVillage().getState()) {
            case PROLOGUE: {
                info.append("\u30d7\u30ed\u30ed\u30fc\u30b0\u4e2d");
                break;
            }
            case PROGRESS: {
                info.append("\u30b2\u30fc\u30e0\u9032\u884c\u4e2d");
                break;
            }
            case EPILOGUE: {
                info.append("\u30a8\u30d4\u30ed\u30fc\u30b0\u4e2d");
                break;
            }
            case GAMEOVER: {
                info.append("\u30b2\u30fc\u30e0\u7d42\u4e86");
                break;
            }
            case UNKNOWN: {
                info.append("\u4e0d\u660e");
                break;
            }
            default: {
                info.append("???");
                assert (false);
                break;
            }
        }
        info.append('\n');
        info.append("\u6240\u8981\u65e5\u6570 :\t").append(this.getVillage().getPeriodSize()).append('\n');
        this.villageInfo.setText(info.toString());
    }

    public void selectVillageInfoTab() {
        this.setSelectedIndex(0);
    }

    public Village getVillage() {
        return this.village;
    }

    public void setVillage(Village village) {
        if (village == null) {
            this.village = null;
            this.selectVillageInfoTab();
            this.modifyTabCount(0);
            this.updateVillageInfo();
            return;
        }
        if (village != this.village) {
            this.selectVillageInfoTab();
        }
        this.village = village;
        this.updateVillageInfo();
        int periodNum = this.village.getPeriodSize();
        this.modifyTabCount(periodNum);
        for (int periodDays = 0; periodDays < periodNum; ++periodDays) {
            Period period = this.village.getPeriod(periodDays);
            int tabIndex = this.periodDaysToTabIndex(periodDays);
            JdfBrowser browser = this.getJdfBrowser(tabIndex);
            if (browser == null) {
                Component tabComponent = this.createTabComponent(period);
                this.setComponentAt(tabIndex, tabComponent);
                browser = this.getJdfBrowser(tabIndex);
            }
            String caption = period.getCaption();
            this.setTitleAt(tabIndex, caption);
            if (period == browser.getPeriod()) continue;
            browser.setPeriod(period);
        }
    }

    private void modifyTabCount(int periods) {
        int maxTabIndex;
        int maxPeriodDays = periods - 1;
        while (this.tabIndexToPeriodDays(maxTabIndex = this.getTabCount() - 1) < maxPeriodDays) {
            String title = "";
            JPanel component = new JPanel();
            this.addTab(title, component);
        }
        while (this.tabIndexToPeriodDays(maxTabIndex = this.getTabCount() - 1) > maxPeriodDays) {
            this.remove(maxTabIndex);
        }
    }

    private Component createTabComponent(Period period) {
        JdfBrowser browser = new JdfBrowser(period);
        browser.setBorder(new EmptyBorder(0, 0, 0, 0));
        JScrollPane scrollPane = new JScrollPane(browser);
        scrollPane.setHorizontalScrollBarPolicy(31);
        return scrollPane;
    }

    private int periodDaysToTabIndex(int days) {
        int tabIndex = days + 1;
        if (tabIndex >= this.getTabCount()) {
            return -1;
        }
        return tabIndex;
    }

    private int tabIndexToPeriodDays(int tabIndex) {
        if (tabIndex >= this.getTabCount()) {
            return -1;
        }
        int days = tabIndex - 1;
        return days;
    }

    public JdfBrowser currentJdfBrowser() {
        int tabIndex = this.getSelectedIndex();
        JdfBrowser result = this.getJdfBrowser(tabIndex);
        return result;
    }

    private JdfBrowser getJdfBrowser(int tabIndex) {
        if (this.tabIndexToPeriodDays(tabIndex) < 0) {
            return null;
        }
        if (tabIndex >= this.getTabCount()) {
            return null;
        }
        Component component = this.getComponentAt(tabIndex);
        if (component == null) {
            return null;
        }
        if (!(component instanceof JScrollPane)) {
            return null;
        }
        JScrollPane scrollPane = (JScrollPane)component;
        JViewport viewport = scrollPane.getViewport();
        if (viewport == null) {
            return null;
        }
        Component view = viewport.getView();
        if (view == null) {
            return null;
        }
        if (!(view instanceof JdfBrowser)) {
            return null;
        }
        JdfBrowser result = (JdfBrowser)view;
        return result;
    }
}

