/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.text.DateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.HTMLUtils;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Topic;

public class Talk
implements Topic {
    private static DateFormat dform = DateFormat.getDateTimeInstance(2, 2);
    private final Period homePeriod;
    private final Type talkType;
    private final Avatar avatar;
    private final String messageID;
    private final int hour;
    private final int minute;
    private final String dialog;

    public Talk(Period homePeriod, Type talkType, Avatar avatar, String messageID, int hour, int minute, String dialog) {
        if (homePeriod == null || talkType == null || avatar == null || messageID == null || dialog == null) {
            throw new NullPointerException();
        }
        if (hour < 0 || 23 < hour) {
            throw new IllegalArgumentException();
        }
        if (minute < 0 || 59 < minute) {
            throw new IllegalArgumentException();
        }
        this.homePeriod = homePeriod;
        this.talkType = talkType;
        this.avatar = avatar;
        this.messageID = messageID;
        this.hour = hour;
        this.minute = minute;
        this.dialog = dialog.replace("<br />", "\n");
    }

    public Type getTalkType() {
        return this.talkType;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public String getMessageID() {
        return this.messageID;
    }

    private long getTimeFromID() {
        String epoch = this.messageID.replace("mes", "");
        long result = Long.parseLong(epoch) * 1000L;
        return result;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public String getDialog() {
        return this.dialog.replace("\n", "<br></br>");
    }

    private String getAnchor() {
        int day = this.homePeriod.getDay();
        String hstr = "0" + this.hour;
        hstr = hstr.substring(hstr.length() - 2);
        String mstr = "0" + this.minute;
        mstr = mstr.substring(mstr.length() - 2);
        return String.valueOf(day) + "d" + hstr + ":" + mstr;
    }

    public String getTime() {
        StringBuilder result = new StringBuilder();
        if (this.hour <= 11) {
            result.append("\u5348\u524d&nbsp;").append(this.hour);
        } else {
            result.append("\u5348\u5f8c&nbsp;").append(this.hour - 12);
        }
        result.append("\u6642&nbsp;").append(this.minute).append("\u5206");
        return result.toString();
    }

    public static Type decodeType(String encoded) {
        Type type;
        if (encoded.equals("say")) {
            type = Type.PUBLIC;
        } else if (encoded.equals("think")) {
            type = Type.PRIVATE;
        } else if (encoded.equals("whisper")) {
            type = Type.WOLFONLY;
        } else if (encoded.equals("groan")) {
            type = Type.GRAVE;
        } else {
            return null;
        }
        return type;
    }

    public static Type decodeIntlType(String encoded) {
        Type type;
        if (encoded.equals("public")) {
            type = Type.PUBLIC;
        } else if (encoded.equals("private")) {
            type = Type.PRIVATE;
        } else if (encoded.equals("wolfonly")) {
            type = Type.WOLFONLY;
        } else if (encoded.equals("grave")) {
            type = Type.GRAVE;
        } else {
            return null;
        }
        return type;
    }

    public static String encodeIntlType(Type type) {
        String result;
        switch (type) {
            case PUBLIC: {
                result = "public";
                break;
            }
            case PRIVATE: {
                result = "private";
                break;
            }
            case WOLFONLY: {
                result = "wolfonly";
                break;
            }
            case GRAVE: {
                result = "grave";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return result;
    }

    private CharSequence buildJdfHTMLDiv() {
        StringBuilder div = new StringBuilder();
        String mesClass = Talk.encodeIntlType(this.getTalkType());
        String content = this.getDialog();
        Pattern anchorRegex = Pattern.compile("(([0-9]?[0-9])(?:[dD]|\u65e5|\u65e5\u76ee))?([0-2]?[0-9]):([0-5]?[0-9])", 32);
        Matcher matcher = anchorRegex.matcher(content);
        StringBuffer newContent = new StringBuffer();
        while (matcher.find()) {
            String anchor = matcher.group();
            String dd = matcher.group(2);
            String hh = matcher.group(3);
            String mm = matcher.group(4);
            if (dd == null) {
                dd = Integer.toString(this.homePeriod.getDay());
            }
            StringBuilder href = new StringBuilder();
            href.append(dd).append("d");
            href.append(hh).append(":");
            href.append(mm);
            anchor = "<a href=\"" + href + "\">" + anchor + "</a>";
            matcher.appendReplacement(newContent, anchor);
        }
        matcher.appendTail(newContent);
        div.append("<div class=\"");
        div.append(mesClass);
        div.append("\">");
        div.append(newContent);
        div.append("</div>");
        return div;
    }

    private CharSequence buildTimeSpans() {
        StringBuilder result = new StringBuilder(" ");
        String simple = this.getTime();
        String anchor = this.getAnchor();
        long epoch = this.getTimeFromID();
        String decoded = dform.format(epoch);
        result.append((CharSequence)HTMLUtils.elemented("span", "time", simple)).append(" ");
        result.append((CharSequence)HTMLUtils.elemented("span", "time", anchor)).append(" ");
        result.append((CharSequence)HTMLUtils.elemented("span", "time", decoded)).append(" ");
        return result;
    }

    public CharSequence buildJdfHTML() {
        StringBuilder html = new StringBuilder();
        StringBuilder aElem = HTMLUtils.elemented("a", "name", this.getMessageID(), this.avatar.getFullName());
        CharSequence timeInfo = this.buildTimeSpans();
        CharSequence imgElem = this.getTalkType() == Type.GRAVE ? HTMLUtils.elemented("img", "avatar", "", "") : this.avatar.buildJdfHTMLImg();
        imgElem = HTMLUtils.elemented("td", imgElem);
        CharSequence content = this.buildJdfHTMLDiv();
        content = HTMLUtils.elemented("td", content);
        StringBuilder table = new StringBuilder();
        table = table.append(imgElem).append(content);
        table = HTMLUtils.elemented("tr", table);
        table = HTMLUtils.elemented("table", table);
        StringBuilder msgDiv = new StringBuilder();
        msgDiv.append("<div class=\"message\"");
        msgDiv.append(" avatar=\"").append(this.getAvatar().getFullName()).append("\"");
        msgDiv.append(" talktype=\"").append(Talk.encodeIntlType(this.getTalkType())).append("\"");
        msgDiv.append(">");
        msgDiv.append((CharSequence)aElem).append(timeInfo).append((CharSequence)table);
        msgDiv.append("</div>");
        html.append((CharSequence)msgDiv).append("\n<!-- -->\n");
        return html;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.avatar.getFullName());
        if (this.talkType == Type.PUBLIC) {
            result.append(" says ");
        } else if (this.talkType == Type.PRIVATE) {
            result.append(" think ");
        } else if (this.talkType == Type.WOLFONLY) {
            result.append(" howl ");
        } else if (this.talkType == Type.GRAVE) {
            result.append(" groan ");
        }
        result.append(this.dialog);
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PUBLIC,
        WOLFONLY,
        PRIVATE,
        GRAVE;

    }
}

