/*
 * 発言アンカー view
 * 
 * Copyright(c) 2008 olyutorskii
 * $Id: AnchorView.java 18 2008-06-15 13:00:34Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.StyleSheet;

/**
 * 発言アンカーのView
 */
public class AnchorView extends InlineView{

    /**
     * Viewの生成。
     * @param elem HTML要素
     */
    public AnchorView(Element elem){
        super(elem);
        return;
    }

    /**
     * 背景を返す。
     * @return 背景
     */
    @Override
    public Color getBackground(){
        StyleSheet styleSheet = getStyleSheet();
        View parent = getParent();
        Color bgColor = null;
        for(;;){
            AttributeSet vattr = styleSheet.getViewAttributes(parent);
            bgColor = styleSheet.getBackground(vattr);
            if(bgColor != null){
                break;
            }
            parent = parent.getParent();
        }
        return bgColor.darker();//.brighter();
    }
}
