/*
 * Baloon view
 * 
 * Copyright(c) 2008 olyutorskii
 * $Id: BaloonView.java 25 2008-06-19 16:31:08Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.StyleSheet;

/**
 * JdfViewFactory用のフキダシ描画用ビュー
 */
public class BaloonView extends BlockView{

    private static int ROUNDRADIUS = 8;
    private static int BALOONTIP_WIDTH = 16;
    private static int BALOONTIP_HEIGHT = 8;
    private static Color COLOR_PUBLIC = new Color(0xffffff);
    private static Color COLOR_WOLFONLY = new Color(0xff7777);
    private static Color COLOR_PRIVATE = new Color(0x939393);
    private static Color COLOR_GRAVE = new Color(0x9fb7cf);
    private static Color COLOR_TRANS = new Color(0, 0, 0, 0);
    private static RenderingHints renderHints = GUIUtils.getQualityHints();
    private static BufferedImage BALOON_PUBLIC;
    private static BufferedImage BALOON_WOLFONLY;
    private static BufferedImage BALOON_GRAVE;
    private static BufferedImage BALOON_PRIVATE;

    static{
        BALOON_PUBLIC   = createWedgeImage(COLOR_PUBLIC);
        BALOON_WOLFONLY = createBubbleImage(COLOR_WOLFONLY);
        BALOON_PRIVATE  = createBubbleImage(COLOR_PRIVATE);
        BALOON_GRAVE    = createBubbleImage(COLOR_GRAVE);
    }
    
    /**
     * 指定した色で描画したクサビイメージを取得する。
     * @param color 色
     * @return クサビイメージ
     */
    private static BufferedImage createWedgeImage(Color color){
        BufferedImage image;
        image = new BufferedImage(BALOONTIP_WIDTH,
                                  BALOONTIP_HEIGHT,
                                  BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = image.createGraphics();
        g2.addRenderingHints(renderHints);
        g2.setColor(COLOR_TRANS);
        g2.fillRect(0, 0, BALOONTIP_WIDTH, BALOONTIP_HEIGHT);
        g2.setColor(color);
        Polygon poly = new Polygon();
        poly.addPoint(8, 8);
        poly.addPoint(16, 8);
        poly.addPoint(16, 0);
        g2.fillPolygon(poly);
        return image;
    }
    
    /**
     * 指定した色で描画した泡イメージを取得する。
     * @param color 色
     * @return 泡イメージ
     */
    private static BufferedImage createBubbleImage(Color color){
        BufferedImage image;
        image = new BufferedImage(BALOONTIP_WIDTH,
                                  BALOONTIP_HEIGHT,
                                  BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = image.createGraphics();
        g2.addRenderingHints(renderHints);
        g2.setColor(COLOR_TRANS);
        g2.fillRect(0, 0, BALOONTIP_WIDTH, BALOONTIP_HEIGHT);
        g2.setColor(color);
        g2.fillOval(2, 4, 4, 4);
        g2.fillOval(8, 2, 6, 6);
        return image;
    }
    
    private Talk.Type type;
    
    /**
     * フキダシビューを生成する。
     *
     * @param elem HTML要素
     * @param type 発言種別
     */
    public BaloonView(Element elem, Talk.Type type){
        super(elem, View.Y_AXIS);
        this.type = type;
        return;
    }

    /**
     * 発言種別を返す。
     * @return 発言種別
     */
    public Talk.Type getType(){
        return this.type;
    }
    
    /**
     * フキダシを描画
     * @param g2 グラフィックコンテキスト
     * @param bounds 描画領域
     */
    private void drawBaloon(Graphics2D g2, Rectangle bounds){
        StyleSheet styleSheet = getStyleSheet();
        AttributeSet vattr = styleSheet.getViewAttributes(this);
        Color bgColor = styleSheet.getBackground(vattr);
        g2.setColor(bgColor);
        g2.fillRoundRect(bounds.x + BALOONTIP_WIDTH,
                         bounds.y,
                         bounds.width - BALOONTIP_WIDTH,
                         bounds.height,
                         ROUNDRADIUS * 2, ROUNDRADIUS * 2);

        BufferedImage tip;
        switch(this.type){
        case WOLFONLY:
            tip = BALOON_WOLFONLY;
            break;
        case PUBLIC:
            tip = BALOON_PUBLIC;
            break;
        case GRAVE:
            tip = BALOON_GRAVE;
            break;
        case PRIVATE:
            tip = BALOON_PRIVATE;
            break;
        default:
            tip = null;
            assert false;
            break;
        }

        g2.drawImage(tip,
                     bounds.x,
                     bounds.y + (bounds.height - BALOONTIP_HEIGHT) / 2,
                     null);
        return;
    }

    /**
     * 子ビューを描画
     * @param g2 グラフィックコンテキスト
     * @param bounds 描画領域
     */
    private void drawContent(Graphics2D g2, Rectangle bounds){
        int ix = bounds.x + getLeftInset();
        int iy = bounds.y + getTopInset();
        Rectangle clip = g2.getClipBounds();
        Rectangle allocChild = new Rectangle();
        int viewMax = getViewCount();
        for(int viewNo = 0; viewNo < viewMax; viewNo++){
            allocChild.setBounds(ix + getOffset(X_AXIS, viewNo),
                                 iy + getOffset(Y_AXIS, viewNo),
                                 getSpan(X_AXIS, viewNo),
                                 getSpan(Y_AXIS, viewNo));
            if(!allocChild.intersects(clip)){
                continue;
            }
            paintChild(g2, allocChild, viewNo);
        }
        return;
    }
    
    /**
     * バルーンビューを描画
     * @param g グラフィックコンテキスト
     * @param allocation 描画領域
     */
    @Override
    public void paint(Graphics g, Shape allocation){
        Graphics2D g2 = (Graphics2D) g;
        g2.addRenderingHints(GUIUtils.getDefaultHints());

        Rectangle bounds = allocation.getBounds();
        g2.setColor(COLOR_TRANS);
        g2.fill(bounds);

        // ignore BoxPainter !
        drawBaloon(g2, bounds);
        drawContent(g2, bounds);
        
        return;
    }
}
