/*
 * GUI utilities
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: GUIUtils.java 18 2008-06-15 13:00:34Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/**
 * GUI関連のユーティリティクラス。
 */
public class GUIUtils{

    private static final String logoSource = "resources/logo.png";
    private static final String windowIconSource = "resources/winicon.png";
    private static Image logoImage;
    private static Icon logoIcon;
    private static Image windowIconImage;
    
    private static final RenderingHints normalHints;
    private static final RenderingHints qualityHints;
    private static final RenderingHints speedyHints;

    static{
        normalHints = new RenderingHints(null);
        qualityHints = new RenderingHints(null);
        speedyHints = new RenderingHints(null);

        qualityHints.put(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
        speedyHints.put(RenderingHints.KEY_ANTIALIASING,
                        RenderingHints.VALUE_ANTIALIAS_OFF);

        qualityHints.put(RenderingHints.KEY_RENDERING,
                         RenderingHints.VALUE_RENDER_QUALITY);
        speedyHints.put(RenderingHints.KEY_RENDERING,
                        RenderingHints.VALUE_RENDER_SPEED);

        qualityHints.put(RenderingHints.KEY_DITHERING,
                         RenderingHints.VALUE_DITHER_ENABLE);
        speedyHints.put(RenderingHints.KEY_DITHERING,
                        RenderingHints.VALUE_DITHER_DISABLE);

        qualityHints.put(RenderingHints.KEY_TEXT_ANTIALIASING,
                         RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        speedyHints.put(RenderingHints.KEY_TEXT_ANTIALIASING,
                        RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);

        qualityHints.put(RenderingHints.KEY_FRACTIONALMETRICS,
                         RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        speedyHints.put(RenderingHints.KEY_FRACTIONALMETRICS,
                        RenderingHints.VALUE_FRACTIONALMETRICS_OFF);

        qualityHints.put(RenderingHints.KEY_INTERPOLATION,
                         RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        speedyHints.put(RenderingHints.KEY_INTERPOLATION,
                        RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);

        qualityHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION,
                         RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        speedyHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION,
                        RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);

        qualityHints.put(RenderingHints.KEY_COLOR_RENDERING,
                         RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        speedyHints.put(RenderingHints.KEY_COLOR_RENDERING,
                        RenderingHints.VALUE_COLOR_RENDER_SPEED);

        qualityHints.put(RenderingHints.KEY_STROKE_CONTROL,
                         RenderingHints.VALUE_STROKE_PURE);
        speedyHints.put(RenderingHints.KEY_STROKE_CONTROL,
                        RenderingHints.VALUE_STROKE_NORMALIZE);
    }

    /**
     * Jindolf デフォルトの描画ヒントを返す。
     * @return 描画ヒント
     */
    public static RenderingHints getDefaultHints(){
        return normalHints;
//      return qualityHints;
//      return speedyHints;
    }

    /**
     * ノーマルな描画ヒントを返す。
     * @return 描画ヒント
     */
    public static RenderingHints getNormalHints(){
        return normalHints;
    }

    /**
     * 描画品質優先の描画ヒントを返す。
     * @return 描画ヒント
     */
    public static RenderingHints getQualityHints(){
        return qualityHints;
    }

    /**
     * 描画速度優先の描画ヒントを返す。
     * @return 描画ヒント
     */
    public static RenderingHints getSpeedyHints(){
        return speedyHints;
    }

    /**
     * ロゴイメージを得る。
     * @return ロゴイメージ
     */
    public static Image getLogoImage(){
        if(logoImage != null){
            return logoImage;
        }

        URL url = Jindolf.selfClass.getResource(logoSource);
        Image image;
        try{
            image = ImageIO.read(url);
        }catch(IOException e){
            warnMessage(e);
            image = new BufferedImage(100, 100, BufferedImage.TYPE_INT_ARGB);
            // TODO デカく "狼" とでも描くか？
        }
      
        logoImage = image;
        
        return logoImage;
    }
    
    /**
     * 各種ウィンドウのアイコンイメージを得る。
     * @return アイコンイメージ
     */
    public static Image getWindowIconImage(){
        if(windowIconImage != null){
            return windowIconImage;
        }

        URL url = Jindolf.selfClass.getResource(windowIconSource);
        Image image;
        try{
            image = ImageIO.read(url);
        }catch(IOException e){
            warnMessage(e);
            image = getLogoImage();
        }

        windowIconImage = image;

        return windowIconImage;
    }

    /**
     * ロゴアイコンを得る。
     * @return ロゴアイコン
     */
    public static Icon getLogoIcon(){
        if(logoIcon != null){
            return logoIcon;
        }
        
        Icon icon = new ImageIcon(getLogoImage());
        
        logoIcon = icon;
        
        return logoIcon;
    }

    /**
     * 警告を出力する。
     * @param message 警告内容
     */
    private static void warnMessage(Object message){
        System.out.println(message);
        return;
    }

    /**
     * hidden constructor
     */
    private GUIUtils(){
        super();
        return;
    }
}
