/*
 * HTTP utilities
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: HttpUtils.java 18 2008-06-15 13:00:34Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * HTTP関連のユーティリティ群
 */
public class HttpUtils{

    private static String tokenRegex
            = "([^\\(\\)<>@,;:\\\"/\\[\\]\\?=\\{\\}\\p{Blank}\\p{Cntrl}]+)";
    private static String mtypeRegex =
            "[\\p{Blank}]*"
            + tokenRegex + "/" + tokenRegex
            + "[\\p{Blank}]*";
    private static String paramRegex =
            "[\\p{Blank}]*;[\\p{Blank}]*"
            + tokenRegex
            + "[\\p{Blank}]*=[\\p{Blank}]*"
            + "(" + tokenRegex + "|" + "(\"[^\\p{Cntrl}\\\"]*\")" + ")";
    private static Pattern mtypePattern = Pattern.compile(mtypeRegex);
    private static Pattern attrPattern = Pattern.compile(paramRegex);

    public static String httpImplement = getHttpImplementName();

    /**
     * HttpURLConnectinインプリメントのクラス名を返す。
     * @return クラス名
     */
    public static String getHttpImplementName(){
        URL dummyURL = null;
        try{
            dummyURL = new URL("http://0.0.0.0/");
        }catch(MalformedURLException e){
        }

        URLConnection connection = null;
        try{
            connection = dummyURL.openConnection();
        }catch(IOException e){
        }

        Class klass = connection.getClass();
        String implement = klass.getName();

        return implement;
    }

    /**
     * ユーザエージェント名を返す。
     * @return ユーザエージェント名
     */
    public static String getUserAgentName() {
        String arch = null;
        String osname = null;
        String osver = null;
        String jrever = null;
        String jrevendor = null;

        try{
            arch = System.getProperty("os.arch");
        }catch(SecurityException e){
        }

        try{
            osver = System.getProperty("os.version");
        }catch(SecurityException e){
        }

        try{
            osname = System.getProperty("os.name");
        }catch(SecurityException e){
        }

        try{
            jrever = System.getProperty("java.version");
        }catch(SecurityException e){
        }

        try{
            jrevendor = System.getProperty("java.vendor");
        }catch(SecurityException e){
        }

        String agent = Jindolf.title + "/" + Jindolf.version;
//        agent += " ("+arch+"; "+osname+"; "+osver+")";
//        agent += " JRE"+jrever +" "+ jrevendor +" "+ getHttpImplementName();
// Jindolf/0.1 (x86; WinXP; JDK1.6)";

        return agent;
    }

    /**
     * HTTP応答からCharsetを取得する。
     * @param connection HTTP接続
     * @return Charset文字列
     */
    public static String getHTMLCharset(URLConnection connection){
        String contentType = connection.getContentType();
        if(contentType == null) return null;
        return getHTMLCharset(contentType);
    }

    /**
     * ContentTypeからCharsetを取得する。
     * @param contentType ContentType
     * @return Charset文字列
     */
    public static String getHTMLCharset(String contentType){
        Matcher matcher;
        boolean matchResult;
        int lastPos;

        matcher = mtypePattern.matcher(contentType);
        matchResult = matcher.lookingAt();
        if(!matchResult) return null;
        lastPos = matcher.end();
        String type = matcher.group(1);
        String subtype = matcher.group(2);

        if(!type.equalsIgnoreCase("text")) return null;
        if(!subtype.equalsIgnoreCase("html")) return null;

        matcher.usePattern(attrPattern);

        String charset = null;
        for(;;){
            matchResult = matcher.find(lastPos);
            if(!matchResult) break;
            lastPos = matcher.end();
            String attribute = matcher.group(1);
            String value = matcher.group(2);
            if(attribute.equalsIgnoreCase("charset")) charset = value;
        }
        return charset;
    }
    
    /**
     * 隠れコンストラクタ
     */
    private HttpUtils(){
        super();
        return;
    }
}
