/*
 * Jindolf Editor kit
 * 
 * Copyright(c) 2008 olyutorskii
 * $Id: JdfEditorKit.java 18 2008-06-15 13:00:34Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import javax.swing.text.StyleContext;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.StyleSheet;

/**
 * 内部ブラウザ向けEditorKit
 */
@SuppressWarnings("serial")
public class JdfEditorKit extends UnshareStyleEditorKit{

    private static final String cssSrc = "resources/jindolf.css";
    private static final String cssContent;
    
    static{
        Class klass = JdfEditorKit.class;
        InputStream is = klass.getResourceAsStream(cssSrc);
        Reader reader = new InputStreamReader(is);
        reader = new BufferedReader(reader);

        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[256];
        try{
            for(;;){
                int chs = reader.read(buffer);
                if(chs <= 0) break;
                sb.append(buffer, 0, chs);
            }
        }catch(IOException e){
            sb.delete(0, sb.length());
        }

        try{
            reader.close();
        }catch(IOException e){
        }
        
        cssContent = sb.toString();
    }
    
    private ViewFactory defaultFactory;

    /**
     * 村指定と共にEditorKitを生成。
     * @param village 村
     */
    public JdfEditorKit(Village village){
        super();
        
        this.defaultFactory = new JdfViewFactory(village);
        
        StyleSheet originalStyle = new StyleSheet();

        Reader reader = new StringReader(cssContent);
        try{
            originalStyle.loadRules(reader, null);
            reader.close();
        }catch(IOException e){
        }
        
        setStyleSheet(originalStyle);

        return;
    }
    
    /**
     * ViewFactoryを取得する。
     * @return ViewFactoryインスタンス
     */
    @Override
    public ViewFactory getViewFactory(){
        return this.defaultFactory;
    }

    /**
     * スタイルシート情報をダンプ出力する。
     * @param out 出力ストリーム
     */
    public void dumpStyleSheet(PrintStream out){
        StyleSheet sheet = getStyleSheet();
        
        Enumeration styleNames = sheet.getStyleNames();

        while (styleNames.hasMoreElements()) {
            String stylename = (String) styleNames.nextElement();
            out.println("stylename="+stylename);

            StyleContext.NamedStyle style =
                    (StyleContext.NamedStyle)
                    ( sheet.getStyle(stylename) );
            String styleName = style.getName();
            out.println("rulename=" + styleName);
            
            Enumeration attrs = style.getAttributeNames();
            while (attrs.hasMoreElements()) {
                Object key = attrs.nextElement();
                Object value = style.getAttribute(key);
                out.println("key="+key+"   value="+value);
            }
        }
        
        return;
    }
}
