/*
 * system event in game
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: SysEvent.java 18 2008-06-15 13:00:34Z olyutorskii $
 */

package jp.sourceforge.jindolf;

/**
 * 人狼BBSシステムが生成する各種メッセージ。
 * Topicの具体化。
 */
// TODO 狼の襲撃先表示は Talk か SysEvent どちらにしよう...
public class SysEvent implements Topic{

    /** イベント種別。 現時点では無意味。そのうち増やす。 */
    public static enum Type{
        STARTPROLOGUE,
        ONSTAGE,
        WINVILLAGE,
        WINWOLF,
        WINHAMSTER,
        GAMEOVER,
        UNKNOWN,
        // 開村
        // アバター初登場
        // 鏡
        // 役職確定
        // ゲルト死亡
        // 最初の犠牲者
        // 現在の生存者
        // 突然死
        // 誰が誰を占ったか
        // 誰が誰を守ったか
        // 誰が誰に投票したか&誰が処刑されたか
        // 誰が誰を襲おうと試みたか
        // 誰が襲撃されたか
        // 襲撃は行われなかったか
        // 村側勝利
        // 狼勝利
        // 役職&ログイン名公開
        // 終了しました。もう誰も書き込めません。
        // 日付更新
        // ハムスター勝利?
        // ハムスターが溶けた？
        // ORDER
        // まだ発言していないもの
        // 更新時刻の通知と投票促し
        // 閉村時刻の通知と投稿促し
    }
    
    private String message;
    private Type type = Type.UNKNOWN;
    
    /**
     * システムイベントを生成する。
     * @param type イベント種別。現時点では無意味。
     * @param message イベントメッセージ（HTMLタグ含む）
     */
    public SysEvent(String type, String message){
        super();
        message = message.replace("<br />","\n");
        this.message = message;
        return;
    }

    /**
     * イベントメッセージを取得する。
     * @return イベントメッセージ
     */
    public String getMessage(){
        return this.message;
    }
    
    /**
     * 内部ブラウザ用のHTML文字列を生成する。
     * @return 内部ブラウザ用のHTML文字列
     */
    public CharSequence buildJdfHTML(){
        StringBuilder html = new StringBuilder();
        String talk = getMessage();
        talk = talk.replace("\n","<br></br>");
        html.append(HTMLUtils.elemented("div", "topic", talk));
        html.append("<br></br>");
        html.append("\n<!-- -->\n");
        return html;
    }
}
