/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.Village;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LandsModel
implements TreeModel {
    private static final String KEY_PREFIX = "land.order.";
    private static final String ROOT = "ROOT";
    private final List<Land> landList = new Vector<Land>();
    private boolean isLandListLoaded = false;
    private final EventListenerList listeners = new EventListenerList();

    public void loadVillageList(Land land) throws IOException {
        land.updateVillageList();
        List<Village> villageList = land.getVillageList();
        int[] childIndices = new int[villageList.size()];
        for (int ct = 0; ct < childIndices.length; ++ct) {
            childIndices[ct] = ct;
        }
        Object[] children = villageList.toArray();
        Object[] path = new Object[]{ROOT, land};
        TreePath treePath = new TreePath(path);
        TreeModelEvent event = new TreeModelEvent((Object)this, treePath, childIndices, children);
        this.fireTreeNodesInserted(event);
    }

    public void loadLandList() throws IOException {
        String key;
        if (this.isLandListLoaded) {
            return;
        }
        InputStream is = this.getClass().getResourceAsStream("resources/land.properties");
        Properties properties = new Properties();
        properties.load(is);
        is.close();
        String codeCheck = properties.getProperty("codeCheck");
        if (codeCheck == null || codeCheck.length() != 1 || codeCheck.charAt(0) != '\u72fc') {
            Jindolf.logger.severe("\u56fd\u5b9a\u7fa9\u4e00\u89a7\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u304a\u304b\u3057\u3044\u3088\u3046\u3067\u3059\u3002native2ascii \u306f\u6b63\u3057\u304f\u9069\u7528\u3057\u307e\u3057\u305f\u304b\uff1f");
            Jindolf.exit(1);
            return;
        }
        Set<Object> keySet = properties.keySet();
        TreeSet<Integer> orderSet = new TreeSet<Integer>();
        for (Object keyObj : keySet) {
            Integer order;
            if (keyObj == null || !(key = keyObj.toString()).startsWith(KEY_PREFIX)) continue;
            key = key.replace(KEY_PREFIX, "");
            try {
                order = new Integer(key);
            }
            catch (NumberFormatException e) {
                continue;
            }
            orderSet.add(order);
        }
        this.landList.clear();
        for (Integer order : orderSet) {
            String landId;
            if (order == null || (landId = properties.getProperty(key = KEY_PREFIX + order.toString())) == null || landId.length() <= 0) continue;
            Land land = new Land(landId, properties);
            this.landList.add(land);
        }
        this.isLandListLoaded = true;
        int[] childIndices = new int[this.landList.size()];
        for (int ct = 0; ct < childIndices.length; ++ct) {
            childIndices[ct] = ct;
        }
        Object[] children = this.landList.toArray();
        TreePath treePath = new TreePath(ROOT);
        TreeModelEvent event = new TreeModelEvent((Object)this, treePath, childIndices, children);
        this.fireTreeNodesInserted(event);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(TreeModelListener.class, l);
    }

    private TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class);
    }

    protected void fireTreeNodesInserted(TreeModelEvent event) {
        for (TreeModelListener listener : this.getTreeModelListeners()) {
            listener.treeNodesInserted(event);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.getChildCount(parent)) {
            return null;
        }
        if (parent == ROOT) {
            return this.getLandList().get(index);
        }
        if (parent instanceof Land) {
            Land land = (Land)parent;
            return land.getVillage(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == ROOT) {
            return this.getLandList().size();
        }
        if (parent instanceof Land) {
            Land land = (Land)parent;
            return land.getVillageCount();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (child == null) {
            return -1;
        }
        if (parent == ROOT) {
            return this.getLandList().indexOf(child);
        }
        if (parent instanceof Land) {
            Land land = (Land)parent;
            return land.getIndexOfVillage(child);
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return ROOT;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == ROOT) {
            return false;
        }
        if (node instanceof Land) {
            return false;
        }
        if (node instanceof Village) {
            return true;
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<Land> getLandList() {
        return this.landList;
    }
}

