/*
 * avatar-image view
 * 
 * Copyright(c) 2008 olyutorskii
 * $Id: AvatarView.java 18 2008-06-15 13:00:34Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.html.ImageView;

/**
 * Avatar の顔イメージ表示のためのView
 */
public class AvatarView extends ImageView{

    private Image image;
    private float width;
    private float height;

    /**
     * ビュー生成。
     * @param elem HTML要素
     * @param image 顔イメージ
     */
    public AvatarView(Element elem, Image image){
        super(elem);
        this.image = image;
        this.width = (float)( image.getWidth(null) );
        this.height = (float)( image.getHeight(null) );
        setPropertiesFromAttributes();
        return;
    }
    
    /**
     * 顔イメージを取得する。
     * @return 顔イメージ
     */
    @Override
    public Image getImage(){
        return image;
    }

    /**
     * 顔イメージの描画。
     * @param g グラフィックコンテキスト
     * @param a 描画領域
     */
    @Override
    public void paint(Graphics g, Shape a){
        Rectangle rect = a.getBounds();
        g.drawImage(getImage(), rect.x, rect.y, null);
        return;
    }
    
    /**
     * 最小寸法を返す。
     * @param axis 向き
     * @return 寸法
     */
    @Override
    public float getMinimumSpan(int axis){
        switch(axis){
        case X_AXIS:
            return width;
        case Y_AXIS:
            return height;
        default:
            break;
        }
        return 0.0f;
    }
    
    /**
     * 望ましい寸法を返す。
     * @param axis 向き
     * @return 寸法
     */
    @Override
    public float getPreferredSpan(int axis){
        return getMinimumSpan(axis);
    }
    
    /**
     * 最大寸法を返す。
     * @param axis 向き
     * @return 寸法
     */
    @Override
    public float getMaximumSpan(int axis){
        return getMinimumSpan(axis);
    }
}
