/*
 * system event in game
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: SysEvent.java 50 2008-06-27 16:46:43Z olyutorskii $
 */

package jp.sourceforge.jindolf;

/**
 * 人狼BBSシステムが生成する各種メッセージ。
 * Topicの具体化。
 */
// TODO 狼の襲撃先表示は Talk か SysEvent どちらにしよう...
public class SysEvent implements Topic{

    /** イベントのおおまかな種別 */
    public static enum EventClass{
        /** &lt;div class="announce"&gt;に対応 */
        ANNOUNCE,
        /** &lt;div class="order"&gt;に対応 */
        ORDER,
        /** &lt;div class="extra"&gt;に対応 */
        EXTRA,
    }
    
    /** イベント種別。 現時点では無意味。そのうち増やす。 */
    public static enum Type{
        STARTPROLOGUE,
        ONSTAGE,
        WINVILLAGE,
        WINWOLF,
        WINHAMSTER,
        GAMEOVER,
        UNKNOWN,
        // 開村
        // アバター初登場
        // 鏡
        // 役職確定
        // ゲルト死亡
        // 最初の犠牲者
        // 現在の生存者
        // 突然死
        // 誰が誰を占ったか
        // 誰が誰を守ったか
        // 誰が誰に投票したか&誰が処刑されたか
        // 誰が誰を襲おうと試みたか
        // 誰が襲撃されたか
        // 襲撃は行われなかったか
        // 村側勝利
        // 狼勝利
        // 役職&ログイン名公開
        // 終了しました。もう誰も書き込めません。
        // 日付更新
        // ハムスター勝利?
        // ハムスターが溶けた？
        // ORDER
        // まだ発言していないもの
        // 更新時刻の通知と投票促し
        // 閉村時刻の通知と投稿促し
    }
    
    /**
     * イベントクラス文字列をデコードする。
     * @param eventClass イベントクラス文字列
     * @return デコードしたEventClass
     */
    public static EventClass decodeEventClass(CharSequence eventClass){
        EventClass result;
        if("announce".contentEquals(eventClass)){
            result = EventClass.ANNOUNCE;
        }else if("order".contentEquals(eventClass)){
            result = EventClass.ORDER;
        }else if("extra".contentEquals(eventClass)){
            result = EventClass.EXTRA;
        }else{
            assert false;
            return null;
        }

        return result;
    }
    
    /**
     * イベントクラスを文字列にエンコードする。
     * @param eventClass イベントクラス
     * @return エンコードされた文字列
     */
    public static CharSequence encodeEventClass(EventClass eventClass){
        CharSequence result;
        switch(eventClass){
        case ANNOUNCE:
            result = "announce";
            break;
        case ORDER:
            result = "order";
            break;
        case EXTRA:
            result = "extra";
            break;
        default:
            assert false;
            return null;
        }
        
        return result;
    }
    
    private EventClass eventClass;
    private String message;
    private Type type = Type.UNKNOWN;
    
    /**
     * システムイベントを生成する。
     * @param eventClass イベント種別。
     * @param message イベントメッセージ（HTMLタグ含む）
     */
    public SysEvent(EventClass eventClass, String message)
            throws NullPointerException{
        super();
        if(eventClass == null || message == null){
            throw new NullPointerException();
        }
        this.eventClass = eventClass;
        message = message.replace("<br />","\n");
        this.message = message;
        return;
    }

    /**
     * イベントメッセージを取得する。
     * @return イベントメッセージ
     */
    public String getMessage(){
        return this.message;
    }
    
    /**
     * 内部ブラウザ用のHTML文字列を生成する。
     * @return 内部ブラウザ用のHTML文字列
     */
    public CharSequence buildJdfHTML(){
        StringBuilder html = new StringBuilder();
        String talk = getMessage();
        talk = talk.replace("\n","<br></br>");
        html.append(HTMLUtils.elemented("div",
                                        encodeEventClass(this.eventClass),
                                        talk)
                   );
        html.append("<br></br>");
        html.append("\n<!-- -->\n");
        return html;
    }
}
