/*
 * talk view
 * 
 * Copyright(c) 2008 olyutorskii
 * $Id: TalkView.java 26 2008-06-20 12:51:53Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import javax.swing.text.Element;

/**
 * JdfViewFactory用のTalk描画用ビュー
 */
public class TalkView extends TopicView{

    private Avatar avatar;
    private Talk.Type type;

    /**
     * Talk用のViewを生成する。
     * @param elem HTML要素
     * @param avatar Avatar
     * @param type 発言種別
     */
    public TalkView(Element elem, Avatar avatar, Talk.Type type){
        super(elem);
        this.avatar = avatar;
        this.type = type;
        return;
    }
    
    /**
     * Avatarを得る。
     * @return Avatar
     */
    public Avatar getAvatar(){
        return this.avatar;
    }

    /**
     * 発言種別を得る。
     * @return 発言種別
     */
    public Talk.Type getTalkType(){
        return this.type;
    }
}
