/*
 * Topic filter
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: TopicFilter.java 26 2008-06-20 12:51:53Z olyutorskii $
 */

package jp.sourceforge.jindolf;

/**
 * 発言Topicのフィルタリングを行うインタフェース。
 */
public interface TopicFilter {
    
    /**
     * フィルタの状態を表すインタフェース
     */
    public interface FilterContext{}

    /**
     * 与えられたTopicViewをフィルタリングする。
     * @param topicView TopicView
     * @return フィルタリングするならtrue
     */
    public boolean isFiltered(TopicView topicView);
    
    /**
     * フィルタの内部状態を表すインスタンスを取得する。
     * @return フィルタの内部状態
     */
    public FilterContext getFilterContext();
    
    /**
     * 以前得られたフィルタ内部状態と同じフィルタリング条件を
     * 現在も保っているか判別する。
     * @param context フィルタの内部状態
     * @return 同じ状態ならtrue
     */
    public boolean isSame(FilterContext context);
}
