/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Highlighter;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import jp.sourceforge.jindolf.AnchorListener;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.JdfEditorKit;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.TopicFilter;
import jp.sourceforge.jindolf.TopicView;
import jp.sourceforge.jindolf.Village;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdfBrowser
extends JEditorPane
implements CaretListener {
    private static final Highlighter.HighlightPainter regexPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
    private final JPopupMenu popup = new JPopupMenu();
    private final TextAction copyAction;
    private final TextAction selAllAction;
    private String internalText = "";
    private Village village;
    private Period period;
    private TopicFilter topicFilter = null;
    private TopicFilter.FilterContext filterContext;
    private boolean hasShown = false;
    private Pattern searchRegex = null;

    public JdfBrowser(Period period) {
        this.setEditable(false);
        this.setContentType("text/html");
        this.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        this.copyAction = new DefaultEditorKit.CopyAction();
        this.selAllAction = new TextAction(""){

            public void actionPerformed(ActionEvent event) {
                JdfBrowser.this.selectAll();
            }
        };
        this.copyAction.putValue("Name", "\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc");
        this.selAllAction.putValue("Name", "\u5168\u9078\u629e");
        this.popup.add(this.copyAction);
        this.popup.addSeparator();
        this.popup.add(this.selAllAction);
        this.setComponentPopupMenu(this.popup);
        this.addCaretListener(this);
        this.setPeriod(period);
    }

    public Period getPeriod() {
        return this.period;
    }

    public synchronized void setPeriod(Period period) {
        HyperlinkListener[] listeners;
        if (period == this.period) {
            return;
        }
        this.period = period;
        this.hasShown = false;
        this.filterContext = null;
        this.setText("");
        if (this.period == null) {
            return;
        }
        if (period.getVillage() == this.village) {
            return;
        }
        this.village = period.getVillage();
        JdfEditorKit kit = new JdfEditorKit(this.village);
        this.setEditorKit(kit);
        for (HyperlinkListener listener : listeners = this.getHyperlinkListeners()) {
            this.removeHyperlinkListener(listener);
        }
        this.addHyperlinkListener(new AnchorListener(this.village));
    }

    public synchronized void showTopics(boolean force) {
        if (force || !this.hasShown) {
            CharSequence html = this.period.buildJdfHTML();
            this.setHTML(html);
            this.hasShown = true;
            this.filterContext = null;
        }
        this.highlightRegex();
        this.filtering();
    }

    private void setHTML(CharSequence html) {
        block7: {
            Document doc;
            block6: {
                StringReader reader = html != null ? new StringReader(((Object)html).toString()) : new StringReader("");
                EditorKit kit = this.getEditorKit();
                doc = kit.createDefaultDocument();
                try {
                    kit.read(reader, doc, 0);
                }
                catch (IOException e) {
                    assert (false);
                }
                catch (BadLocationException e) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            this.setDocument(doc);
            int docLength = doc.getLength();
            try {
                this.internalText = doc.getText(0, docLength);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
    }

    public void setTopicFilter(TopicFilter filter) {
        this.topicFilter = filter;
    }

    public synchronized void filtering() {
        if (this.topicFilter != null && this.topicFilter.isSame(this.filterContext)) {
            return;
        }
        List<TopicView> viewList = this.getTopicViewList(null, null);
        for (TopicView view : viewList) {
            if (this.topicFilter != null && this.topicFilter.isFiltered(view)) {
                view.setVisible(false);
            } else {
                view.setVisible(true);
            }
            View parentView = view.getParent();
            if (parentView == null) continue;
            parentView.preferenceChanged(view, true, true);
        }
        this.filterContext = this.topicFilter != null ? this.topicFilter.getFilterContext() : null;
    }

    public void setSearchRegex(Pattern searchRegex) {
        if (this.searchRegex == searchRegex) {
            return;
        }
        this.searchRegex = searchRegex;
    }

    public synchronized void highlightRegex() {
        int endPos;
        int startPos;
        this.clearHighlight();
        if (this.searchRegex == null) {
            return;
        }
        Highlighter highlighter = this.getHighlighter();
        int docLength = this.internalText.length();
        Matcher matcher = this.searchRegex.matcher(this.internalText);
        matcher.region(0, docLength);
        while (matcher.find() && (startPos = matcher.start()) != (endPos = matcher.end())) {
            matcher.region(endPos, docLength);
            try {
                highlighter.addHighlight(startPos, endPos, regexPainter);
            }
            catch (BadLocationException e) {
                assert (false);
                return;
            }
        }
    }

    private void clearHighlight() {
        Highlighter.Highlight[] highlights;
        Highlighter highlighter = this.getHighlighter();
        for (Highlighter.Highlight highlight : highlights = highlighter.getHighlights()) {
            if (highlight.getPainter() != regexPainter) continue;
            highlighter.removeHighlight(highlight);
        }
    }

    private View getRootView() {
        TextUI textUI = this.getUI();
        View root = textUI.getRootView(this);
        return root;
    }

    private List<TopicView> getTopicViewList(View parent, List<TopicView> list) {
        if (parent == null) {
            parent = this.getRootView();
            list = new LinkedList<TopicView>();
        }
        int childNo = parent.getViewCount();
        for (int ct = 0; ct <= childNo - 1; ++ct) {
            View child = parent.getView(ct);
            if (child instanceof TopicView) {
                list.add((TopicView)child);
                continue;
            }
            this.getTopicViewList(child, list);
        }
        return list;
    }

    @Override
    public void caretUpdate(CaretEvent event) {
        int mark;
        int dot = event.getDot();
        if (dot == (mark = event.getMark())) {
            this.copyAction.setEnabled(false);
        } else {
            this.copyAction.setEnabled(true);
        }
    }

    @Override
    public synchronized void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(GUIUtils.getDefaultHints());
        super.paint(g);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.highlightRegex();
    }
}

