/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jp.sourceforge.jindolf.Controller;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.LandsModel;
import jp.sourceforge.jindolf.MenuManager;
import jp.sourceforge.jindolf.TopFrameView;

public class Jindolf {
    public static final String version = "2.4.2";
    public static final String license = "The MIT License";
    public static final String contact = "http://jindolf.sourceforge.jp/";
    public static final Date initDate;
    public static final long initNano;
    public static final ClassLoader loader;
    public static final Class selfClass;
    public static final Package selfPackage;
    public static final Package jrePackage;
    public static final Runtime runtime;
    public static SecurityManager secManager;
    public static final Logger logger;
    public static final String title;
    public static final String author;
    public static final String copyright;
    private static Dimension initGeometry;

    public static InputStream getResourceAsStream(String name) {
        return selfClass.getResourceAsStream(name);
    }

    public static URL getResource(String name) {
        return selfClass.getResource(name);
    }

    private static void preLoadClass() throws LinkageError, ExceptionInInitializerError {
        String[] classes;
        for (String className : classes = new String[]{"java.lang.Object", "jp.sourceforge.jindolf.JdfEditorKit", "jp.sourceforge.jindolf.TabBrowser", "jp.sourceforge.jindolf.TopFrameView", "java.net.HttpURLConnection", "java.text.SimpleDateFormat", "javax.swing.JEditorPane", "javax.swing.text.html.CSS", "javax.swing.text.html.StyleSheet", "javax.swing.text.html.HTMLDocument", "javax.swing.text.html.BlockView", "javax.swing.text.html.ParagraphView", "javax.swing.text.html.InlineView", "javax.swing.text.html.parser.DocumentParser"}) {
            try {
                if (loader != null) {
                    Class.forName(className, true, loader);
                    continue;
                }
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.WARNING, "\u30af\u30e9\u30b9\u306e\u660e\u793a\u7684\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
        }
    }

    public static boolean hasRuntime5() {
        boolean result;
        try {
            result = jrePackage.isCompatibleWith("1.5");
        }
        catch (NumberFormatException e) {
            assert (false);
            return false;
        }
        return result;
    }

    public static boolean hasRuntime6() {
        boolean result;
        try {
            result = jrePackage.isCompatibleWith("1.6");
        }
        catch (NumberFormatException e) {
            assert (false);
            return false;
        }
        return result;
    }

    public static void exit(int exitCode) throws SecurityException {
        try {
            runtime.exit(exitCode);
        }
        catch (SecurityException e) {
            logger.log(Level.WARNING, "VM\u3092\u7d42\u4e86\u3067\u304d\u307e\u305b\u3093\u3002", e);
            throw e;
        }
    }

    private static void testEnvironment() {
        if (!Jindolf.hasRuntime5()) {
            logger.severe(title + " needs JRE1.5 platform or later.");
            Jindolf.exit(1);
        }
        if (GraphicsEnvironment.isHeadless()) {
            logger.severe(title + " needs bit-map display, keyboard, & pointing-device.");
            Jindolf.exit(1);
        }
    }

    public static void main(final String[] args) {
        runtime.addShutdownHook(new Thread(){

            public void run() {
                System.out.flush();
                System.err.flush();
                runtime.runFinalization();
                Thread.yield();
                runtime.gc();
                Thread.yield();
            }
        });
        Jindolf.testEnvironment();
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Jindolf.startGUI(args);
            }
        });
        Thread.yield();
    }

    private static void startGUI(String[] args) {
        Window splashWindow;
        if (!Jindolf.hasRuntime6()) {
            splashWindow = Jindolf.createSplashWindow();
            splashWindow.setVisible(true);
            Thread.yield();
        } else {
            splashWindow = null;
        }
        Jindolf.preLoadClass();
        LandsModel model = new LandsModel();
        try {
            model.loadLandList();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "\u56fd\u5b9a\u7fa9\u4e00\u89a7\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            Jindolf.exit(1);
        }
        TopFrameView topFrame = Jindolf.buildMVC(model);
        topFrame.setDefaultCloseOperation(3);
        topFrame.setResizable(true);
        topFrame.setIconImage(GUIUtils.getWindowIconImage());
        topFrame.pack();
        topFrame.setSize(initGeometry);
        topFrame.setLocationByPlatform(true);
        Toolkit kit = topFrame.getToolkit();
        kit.setDynamicLayout(false);
        if (splashWindow != null) {
            splashWindow.setVisible(false);
            splashWindow.dispose();
            splashWindow = null;
        }
        topFrame.setVisible(true);
        Thread.yield();
    }

    private static Window createSplashWindow() {
        JWindow splashWindow = new JWindow();
        JLabel splashLabel = new JLabel(GUIUtils.getLogoIcon());
        splashWindow.add(splashLabel);
        splashWindow.pack();
        splashWindow.setLocationRelativeTo(null);
        return splashWindow;
    }

    private static TopFrameView buildMVC(LandsModel model) {
        MenuManager menuManager = new MenuManager();
        TopFrameView topFrame = new TopFrameView();
        topFrame.setJMenuBar(menuManager.createMenuBar());
        new Controller(menuManager, topFrame, model);
        return topFrame;
    }

    private Jindolf() {
    }

    static {
        ClassLoader thisLoader;
        initGeometry = new Dimension(800, 600);
        initDate = new Date();
        initNano = System.nanoTime();
        selfClass = Jindolf.class;
        selfPackage = selfClass.getPackage();
        jrePackage = Object.class.getPackage();
        runtime = Runtime.getRuntime();
        secManager = System.getSecurityManager();
        logger = Logger.getLogger(selfPackage.getName());
        try {
            thisLoader = selfClass.getClassLoader();
        }
        catch (SecurityException e) {
            logger.log(Level.WARNING, "\u30af\u30e9\u30b9\u30ed\u30fc\u30c0\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            thisLoader = null;
        }
        loader = thisLoader;
        String implTitle = selfPackage.getImplementationTitle();
        title = implTitle != null ? implTitle : "Jindolf";
        String implVersion = selfPackage.getImplementationVersion();
        if (implVersion != null && !version.equals(implVersion)) {
            logger.severe("\u30d0\u30fc\u30b8\u30e7\u30f3\u5b9a\u7fa9\u4e0a\u306e\u30b3\u30f3\u30d1\u30a4\u30eb\u30df\u30b9\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f");
            throw new ExceptionInInitializerError("unmatch package version");
        }
        String implVendor = selfPackage.getImplementationVendor();
        author = implVendor != null ? implVendor : "olyutorskii";
        copyright = "Copyright(c) 2008 " + author;
        logger.info(title + "/" + version + " " + copyright + " (" + license + ")" + " \u304c " + initDate + " \u306b\u30ed\u30fc\u30c9\u3055\u308c\u307e\u3057\u305f\u3002 ");
    }
}

