/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import jp.sourceforge.jindolf.JdfBrowser;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Village;

public class TabBrowser
extends JTabbedPane {
    private Village village;
    private final JPanel villageInfo = new JPanel();

    public TabBrowser() {
        this.setTabPlacement(1);
        this.setTabLayoutPolicy(0);
        this.villageInfo.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.addTab("\u6751\u60c5\u5831", new JScrollPane(this.villageInfo));
        this.setVillage(null);
    }

    private void updateVillageInfo() {
        String days;
        String status;
        this.villageInfo.removeAll();
        Village target = this.getVillage();
        if (target == null) {
            this.villageInfo.add(new JLabel("\u3048\u3063\u3068\u2026\u3069\u306e\u6751\uff1f"));
            return;
        }
        String landName = target.getParentLand().getLandName();
        String villageName = "\u300c" + target.getVillageName() + "\u300d";
        String villageID = target.getVillageID();
        int progressDays = target.getProgressDays();
        switch (target.getState()) {
            case PROLOGUE: {
                status = "\u30d7\u30ed\u30ed\u30fc\u30b0\u4e2d";
                days = "\u30d7\u30ed\u30ed\u30fc\u30b0\u4e2d";
                break;
            }
            case PROGRESS: {
                status = "\u30b2\u30fc\u30e0\u9032\u884c\u4e2d";
                days = "\u30d7\u30ed\u30ed\u30fc\u30b0 + " + progressDays + "\u65e5\u76ee";
                break;
            }
            case EPILOGUE: {
                status = "\u30a8\u30d4\u30ed\u30fc\u30b0\u4e2d";
                days = "\u30d7\u30ed\u30ed\u30fc\u30b0 + " + progressDays + "\u65e5 + \u30a8\u30d4\u30ed\u30fc\u30b0\u4e2d";
                break;
            }
            case GAMEOVER: {
                status = "\u30b2\u30fc\u30e0\u7d42\u4e86";
                days = "\u30d7\u30ed\u30ed\u30fc\u30b0 + " + progressDays + "\u65e5 + \u30a8\u30d4\u30ed\u30fc\u30b0";
                break;
            }
            case UNKNOWN: {
                status = "\u4e0d\u660e";
                days = "\u4e0d\u660e";
                break;
            }
            default: {
                assert (false);
                status = "???";
                days = "???";
            }
        }
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.villageInfo.setLayout(layout);
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.villageInfo.add((Component)new JLabel("\u56fd\u540d : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.villageInfo.add((Component)new JLabel(landName), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.villageInfo.add((Component)new JLabel("\u6751\u540d : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.villageInfo.add((Component)new JLabel(villageName), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.villageInfo.add((Component)new JLabel("\u6751ID : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.villageInfo.add((Component)new JLabel(villageID), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.villageInfo.add((Component)new JLabel("\u72b6\u614b : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.villageInfo.add((Component)new JLabel(status), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.villageInfo.add((Component)new JLabel("\u6240\u8981\u65e5\u6570 : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.villageInfo.add((Component)new JLabel(days), constraints);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        this.villageInfo.add((Component)new JPanel(), constraints);
    }

    public void selectVillageInfoTab() {
        this.setSelectedIndex(0);
    }

    public Village getVillage() {
        return this.village;
    }

    public void setVillage(Village village) {
        if (village == null) {
            this.village = null;
            this.selectVillageInfoTab();
            this.modifyTabCount(0);
            this.updateVillageInfo();
            return;
        }
        if (village != this.village) {
            this.selectVillageInfoTab();
        }
        this.village = village;
        this.updateVillageInfo();
        int periodNum = this.village.getPeriodSize();
        this.modifyTabCount(periodNum);
        for (int periodDays = 0; periodDays < periodNum; ++periodDays) {
            Period period = this.village.getPeriod(periodDays);
            int tabIndex = this.periodDaysToTabIndex(periodDays);
            JdfBrowser browser = this.getJdfBrowser(tabIndex);
            if (browser == null) {
                Component tabComponent = this.createTabComponent(period);
                this.setComponentAt(tabIndex, tabComponent);
                browser = this.getJdfBrowser(tabIndex);
            }
            String caption = period.getCaption();
            this.setTitleAt(tabIndex, caption);
            if (period == browser.getPeriod()) continue;
            browser.setPeriod(period);
        }
    }

    private void modifyTabCount(int periods) {
        int maxTabIndex;
        int maxPeriodDays = periods - 1;
        while (this.tabIndexToPeriodDays(maxTabIndex = this.getTabCount() - 1) < maxPeriodDays) {
            String title = "";
            JPanel component = new JPanel();
            this.addTab(title, component);
        }
        while (this.tabIndexToPeriodDays(maxTabIndex = this.getTabCount() - 1) > maxPeriodDays) {
            this.remove(maxTabIndex);
        }
    }

    private Component createTabComponent(Period period) {
        JdfBrowser browser = new JdfBrowser(period);
        browser.setBorder(new EmptyBorder(0, 0, 0, 0));
        JScrollPane scrollPane = new JScrollPane(browser);
        scrollPane.setHorizontalScrollBarPolicy(31);
        return scrollPane;
    }

    private int periodDaysToTabIndex(int days) {
        int tabIndex = days + 1;
        if (tabIndex >= this.getTabCount()) {
            return -1;
        }
        return tabIndex;
    }

    private int tabIndexToPeriodDays(int tabIndex) {
        if (tabIndex >= this.getTabCount()) {
            return -1;
        }
        int days = tabIndex - 1;
        return days;
    }

    public JdfBrowser currentJdfBrowser() {
        int tabIndex = this.getSelectedIndex();
        JdfBrowser result = this.getJdfBrowser(tabIndex);
        return result;
    }

    private JdfBrowser getJdfBrowser(int tabIndex) {
        if (this.tabIndexToPeriodDays(tabIndex) < 0) {
            return null;
        }
        if (tabIndex >= this.getTabCount()) {
            return null;
        }
        Component component = this.getComponentAt(tabIndex);
        if (component == null) {
            return null;
        }
        if (!(component instanceof JScrollPane)) {
            return null;
        }
        JScrollPane scrollPane = (JScrollPane)component;
        JViewport viewport = scrollPane.getViewport();
        if (viewport == null) {
            return null;
        }
        Component view = viewport.getView();
        if (view == null) {
            return null;
        }
        if (!(view instanceof JdfBrowser)) {
            return null;
        }
        JdfBrowser result = (JdfBrowser)view;
        return result;
    }
}

