/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import jp.sourceforge.jindolf.JdfBrowser;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.TabBrowser;
import jp.sourceforge.jindolf.Village;

public class TopFrameView
extends JFrame {
    private static final String INITCARD = "INITCARD";
    private static final String LANDCARD = "LANDINFO";
    private static final String BROWSECARD = "BROWSER";
    private static DateFormat dform = DateFormat.getDateTimeInstance(0, 0);
    private final JComponent cards;
    private final CardLayout cardLayout = new CardLayout();
    private final JTree landSelectView = new JTree();
    private final JPanel landInfo = new JPanel();
    private final JTextField sysMessage = new JTextField();
    private final JProgressBar progressBar = new JProgressBar();
    private final TabBrowser tabBrowser = new TabBrowser();
    private final JButton reloadButton = new JButton("Reload");
    private final JComboBox findBox = new JComboBox();
    private final JButton searchButton = new JButton("Search");

    public TopFrameView() {
        this.setFrameTitle(null);
        JComponent landSelector = this.createLandSelector();
        this.cards = this.createCards();
        JComponent split = this.createSplitPane(landSelector, this.cards);
        JComponent statusBar = this.createStatusBar();
        Container content = this.getContentPane();
        BorderLayout layout = new BorderLayout();
        content.setLayout(layout);
        content.add((Component)split, "Center");
        content.add((Component)statusBar, "South");
    }

    private JComponent createLandSelector() {
        this.landSelectView.setRootVisible(false);
        EmptyBorder border = new EmptyBorder(5, 5, 5, 5);
        this.landSelectView.setBorder(border);
        JScrollPane landSelector = new JScrollPane(this.landSelectView);
        return landSelector;
    }

    private JComponent createCards() {
        JPanel panel = new JPanel();
        panel.setLayout(this.cardLayout);
        panel.add(INITCARD, this.createInitPanel());
        panel.add(LANDCARD, this.createLandInfo());
        panel.add(BROWSECARD, this.createBrowsePanel());
        return panel;
    }

    private JComponent createInitPanel() {
        JLabel initMessage = new JLabel("\u6751\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044");
        initMessage.setHorizontalAlignment(0);
        initMessage.setVerticalAlignment(0);
        JScrollPane scrollPane = new JScrollPane(initMessage);
        return scrollPane;
    }

    private JComponent createLandInfo() {
        this.landInfo.setBorder(new EmptyBorder(5, 5, 5, 5));
        JScrollPane scrollPane = new JScrollPane(this.landInfo);
        return scrollPane;
    }

    private JComponent createBrowsePanel() {
        JPanel panel = new JPanel();
        BorderLayout layout = new BorderLayout();
        panel.setLayout(layout);
        JComponent buttons = this.createButtons();
        panel.add((Component)buttons, "North");
        panel.add((Component)this.tabBrowser, "Center");
        return panel;
    }

    private JComponent createButtons() {
        this.reloadButton.setActionCommand("RELOAD");
        this.findBox.setEditable(true);
        this.findBox.addItem("");
        this.findBox.addItem("\u3010[^\u3011]*\u3011");
        this.findBox.addItem("[\u25a0\u25cf\u25bc]");
        this.searchButton.setActionCommand("SEARCH");
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(layout);
        constraints.insets = new Insets(1, 1, 1, 1);
        constraints.fill = 0;
        constraints.anchor = 17;
        panel.add((Component)this.reloadButton, constraints);
        constraints.anchor = 13;
        constraints.weightx = 1.0;
        panel.add((Component)this.findBox, constraints);
        constraints.weightx = 0.0;
        panel.add((Component)this.searchButton, constraints);
        return panel;
    }

    private JComponent createSplitPane(JComponent left, JComponent right) {
        JSplitPane split = new JSplitPane();
        split.setLeftComponent(left);
        split.setRightComponent(right);
        split.setOrientation(1);
        split.setContinuousLayout(false);
        split.setOneTouchExpandable(true);
        split.setDividerLocation(200);
        return split;
    }

    private JComponent createStatusBar() {
        this.sysMessage.setText(Jindolf.title + " \u3092\u4f7f\u3063\u3066\u304f\u308c\u3066\u3042\u308a\u304c\u3068\u3046 !");
        this.sysMessage.setEditable(false);
        AbstractBorder border = new BevelBorder(1);
        border = new CompoundBorder(border, new EmptyBorder(2, 5, 2, 2));
        this.sysMessage.setBorder(border);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setOrientation(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(99);
        this.progressBar.setValue(0);
        JPanel statusBar = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        statusBar.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.fill = 2;
        statusBar.add((Component)this.sysMessage, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        statusBar.add((Component)this.progressBar, constraints);
        return statusBar;
    }

    public JTree getLandTree() {
        return this.landSelectView;
    }

    public TabBrowser getTabBrowser() {
        return this.tabBrowser;
    }

    public JButton getReloadButton() {
        return this.reloadButton;
    }

    public JComboBox getFindBox() {
        return this.findBox;
    }

    public JButton getSearchButton() {
        return this.searchButton;
    }

    public JdfBrowser currentJdfBrowser() {
        JdfBrowser result = this.tabBrowser.currentJdfBrowser();
        return result;
    }

    public Village currentVillage() {
        return this.tabBrowser.getVillage();
    }

    public void setFrameTitle(CharSequence villageName) {
        String title = Jindolf.title;
        if (villageName != null && villageName.length() > 0) {
            title = villageName + " - " + title;
        }
        this.setTitle(title);
    }

    public void setBusy(String message, boolean busy) {
        this.updateSysMessage(message);
        if (busy) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.progressBar.setIndeterminate(true);
            this.progressBar.setValue(0);
        } else {
            this.setCursor(Cursor.getDefaultCursor());
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(0);
        }
    }

    protected void updateSysMessage(String message) {
        if (message == null) {
            return;
        }
        if (message.length() <= 0) {
            message = " ";
        }
        this.sysMessage.setText(message);
    }

    public void showVillageInfo(Village village) {
        this.setFrameTitle(village.getVillageName());
        this.tabBrowser.setVillage(village);
        this.cardLayout.show(this.cards, BROWSECARD);
        this.tabBrowser.repaint();
        this.tabBrowser.revalidate();
    }

    public void showLandInfo(Land land) {
        String status;
        this.setFrameTitle(land.getLandName());
        this.landInfo.removeAll();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.landInfo.setLayout(layout);
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u56fd\u540d : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(land.getLandName()), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u8b58\u5225\u540d : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(land.getLandIdentifier()), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u30d9\u30fc\u30b9URL : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        JTextField baseURL = new JTextField(land.getServerAccess().getBaseURL().toString());
        baseURL.setEditable(false);
        baseURL.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.landInfo.add((Component)baseURL, constraints);
        Date start = land.getStartDate();
        String startStr = start.equals(Land.DATE_UNKNOWN) ? "(\u4e0d\u660e)" : dform.format(start);
        Date end = land.getEndDate();
        String endStr = end.equals(Land.DATE_UNKNOWN) ? "\u307e\u3060\u307e\u3060" : dform.format(end);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u5efa\u56fd : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(startStr), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u4ea1\u56fd : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(endStr), constraints);
        switch (land.getType()) {
            case CLOSED: {
                status = "\u30b5\u30fc\u30d3\u30b9\u7d42\u4e86";
                break;
            }
            case HISTORICAL: {
                status = "\u904e\u53bb\u30ed\u30b0\u63d0\u4f9b\u306e\u307f";
                break;
            }
            case ACTIVE: {
                status = "\u7a3c\u52d5\u4e2d";
                break;
            }
            default: {
                assert (false);
                status = "";
            }
        }
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u72b6\u614b : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(status), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u30ed\u30b1\u30fc\u30eb : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(land.getLocale().toString()), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u6642\u9593\u5e2f : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(land.getTimeZone().getDisplayName()), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u9023\u7d61\u5148 : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        JTextField contact = new JTextField(land.getContactInfo());
        contact.setEditable(false);
        contact.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.landInfo.add((Component)contact, constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u8aac\u660e : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(land.getDescription()), constraints);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        this.landInfo.add((Component)new JPanel(), constraints);
        this.cardLayout.show(this.cards, LANDCARD);
        this.landInfo.repaint();
        this.landInfo.revalidate();
    }
}

