/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.Village;

public class AnchorListener
implements HyperlinkListener {
    private Village village;
    private Map<Element, Element> anchorMap = new HashMap<Element, Element>();

    public AnchorListener(Village village) {
        this.village = village;
    }

    private String buildAnchorDiv(String href) throws IOException {
        StringBuilder content = new StringBuilder();
        Pattern anchorRegex = Pattern.compile("([0-9]?[0-9])d([0-2]?[0-9]):([0-5]?[0-9])");
        Matcher matcher = anchorRegex.matcher(href);
        if (!matcher.matches()) {
            content.append("[\u898b\u3064\u304b\u308a\u307e\u305b\u3093]");
        }
        String dayStr = matcher.group(1);
        String hourStr = matcher.group(2);
        String minuteStr = matcher.group(3);
        int day = Integer.parseInt(dayStr);
        int hour = Integer.parseInt(hourStr);
        int minute = Integer.parseInt(minuteStr);
        Period period = this.village.getPeriod(day);
        period.updatePeriod();
        for (Topic topic : period.getTopicList()) {
            Talk talk;
            if (!(topic instanceof Talk) || (talk = (Talk)topic).getHour() != hour || talk.getMinute() != minute) continue;
            Avatar avatar = talk.getAvatar();
            if (this.village.getAvatarFaceImage(avatar) == null) {
                Period prologue = this.village.getPrologue();
                prologue.updatePeriod();
                if (this.village.getAvatarFaceImage(avatar) == null) assert (false);
            }
            String fullName = avatar.getFullName();
            content.append("<img avatar=\"").append(fullName).append("\"></img>");
            content.append(fullName).append(" ");
            content.append(talk.getTime()).append("<br>");
            content.append(talk.getDialog()).append("<br>");
        }
        String start = "<div style=\"margin-left: 32px; font-size: 18px; color: #ffff99;\" class=\"anchorDiv\" origin=\"" + href + "\">";
        String close = "</div>";
        return start + content + close;
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        String newDiv;
        String name;
        HyperlinkEvent.EventType eType = event.getEventType();
        if (eType != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        Element sourceElem = event.getSourceElement();
        if (sourceElem == null) {
            return;
        }
        AttributeSet attrSrc = sourceElem.getAttributes();
        if (attrSrc == null) {
            return;
        }
        AttributeSet attrAnchor = (AttributeSet)attrSrc.getAttribute(HTML.Tag.A);
        if (attrAnchor == null) {
            return;
        }
        String href = (String)attrAnchor.getAttribute(HTML.Attribute.HREF);
        if (href == null) {
            return;
        }
        Element prevElem = sourceElem;
        while (!(name = prevElem.getName()).equalsIgnoreCase("table")) {
            if ((prevElem = prevElem.getParentElement()) != null) continue;
            return;
        }
        HTMLDocument doc = (HTMLDocument)sourceElem.getDocument();
        Element anchorDiv = this.anchorMap.get(prevElem);
        String origin = null;
        if (anchorDiv != null) {
            AttributeSet attrAnchorDiv = anchorDiv.getAttributes();
            origin = (String)attrAnchorDiv.getAttribute("origin");
            int start = anchorDiv.getStartOffset();
            int end = anchorDiv.getEndOffset();
            int length = end - start;
            try {
                doc.remove(start, length);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            this.anchorMap.remove(prevElem);
        }
        if (href.equals(origin)) {
            return;
        }
        try {
            newDiv = this.buildAnchorDiv(href);
        }
        catch (IOException e) {
            Jindolf.logger.log(Level.WARNING, "\u30a2\u30f3\u30ab\u30fc\u5148\u306e\u767a\u8a00\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            return;
        }
        try {
            doc.insertAfterEnd(prevElem, newDiv);
        }
        catch (IOException e) {
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        int prevEnd = prevElem.getEndOffset();
        anchorDiv = doc.getParagraphElement(prevEnd);
        this.anchorMap.put(prevElem, anchorDiv);
    }
}

