/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import jp.sourceforge.jindolf.AnchorListener;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.JdfEditorKit;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.TopicFilter;
import jp.sourceforge.jindolf.TopicView;
import jp.sourceforge.jindolf.Village;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdfBrowser
extends JEditorPane
implements CaretListener,
ActionListener,
MouseListener {
    private static final Highlighter.HighlightPainter regexPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
    private final JPopupMenu popup;
    private final JMenuItem menuCopy = new JMenuItem("\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc");
    private final JMenuItem menuSelTalk = new JMenuItem("\u3053\u306e\u767a\u8a00\u3092\u30b3\u30d4\u30fc");
    private final JMenuItem menuPrint = new JMenuItem("\u5370\u5237");
    private final JMenuItem menuSelAll = new JMenuItem("\u5168\u9078\u629e");
    private String internalText = "";
    private Village village;
    private Period period;
    private TopicFilter topicFilter = null;
    private TopicFilter.FilterContext filterContext;
    private boolean hasShown = false;
    private Pattern searchRegex = null;
    private Element talkElem;

    public JdfBrowser(Period period) {
        this.setEditable(false);
        this.setContentType("text/html");
        this.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        this.popup = this.createPopupMenu();
        this.addMouseListener(this);
        this.addCaretListener(this);
        this.setPeriod(period);
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu result = new JPopupMenu();
        this.menuCopy.addActionListener(this);
        this.menuSelTalk.addActionListener(this);
        this.menuPrint.addActionListener(this);
        this.menuSelAll.addActionListener(this);
        this.menuCopy.setActionCommand("COPY");
        this.menuSelTalk.setActionCommand("SELTALK");
        this.menuPrint.setActionCommand("PRINT");
        this.menuSelAll.setActionCommand("SELALL");
        result.add(this.menuCopy);
        result.add(this.menuSelTalk);
        result.add(this.menuSelAll);
        return result;
    }

    public Period getPeriod() {
        return this.period;
    }

    public synchronized void setPeriod(Period period) {
        HyperlinkListener[] listeners;
        if (period == this.period) {
            return;
        }
        this.period = period;
        this.hasShown = false;
        this.filterContext = null;
        this.setText("");
        if (this.period == null) {
            return;
        }
        if (period.getVillage() == this.village) {
            return;
        }
        this.village = period.getVillage();
        JdfEditorKit kit = new JdfEditorKit(this.village);
        this.setEditorKit(kit);
        for (HyperlinkListener listener : listeners = this.getHyperlinkListeners()) {
            this.removeHyperlinkListener(listener);
        }
        this.addHyperlinkListener(new AnchorListener(this.village));
    }

    public synchronized void showTopics(boolean force) {
        if (force || !this.hasShown) {
            CharSequence html = this.period.buildJdfHTML();
            this.setHTML(html);
            this.hasShown = true;
            this.filterContext = null;
        }
        this.highlightRegex();
        this.filtering();
    }

    private void setHTML(CharSequence html) {
        block7: {
            Document doc;
            block6: {
                StringReader reader = html != null ? new StringReader(((Object)html).toString()) : new StringReader("");
                EditorKit kit = this.getEditorKit();
                doc = kit.createDefaultDocument();
                try {
                    kit.read(reader, doc, 0);
                }
                catch (IOException e) {
                    assert (false);
                }
                catch (BadLocationException e) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            this.setDocument(doc);
            int docLength = doc.getLength();
            try {
                this.internalText = doc.getText(0, docLength);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
    }

    public void setTopicFilter(TopicFilter filter) {
        this.topicFilter = filter;
    }

    public synchronized void filtering() {
        if (this.topicFilter != null && this.topicFilter.isSame(this.filterContext)) {
            return;
        }
        List<TopicView> viewList = this.getTopicViewList(null, null);
        for (TopicView view : viewList) {
            if (this.topicFilter != null && this.topicFilter.isFiltered(view)) {
                view.setVisible(false);
            } else {
                view.setVisible(true);
            }
            View parentView = view.getParent();
            if (parentView == null) continue;
            parentView.preferenceChanged(view, true, true);
        }
        this.filterContext = this.topicFilter != null ? this.topicFilter.getFilterContext() : null;
    }

    public void setSearchRegex(Pattern searchRegex) {
        if (this.searchRegex == searchRegex) {
            return;
        }
        this.searchRegex = searchRegex;
    }

    public synchronized int highlightRegex() {
        int endPos;
        int startPos;
        this.clearHighlight();
        if (this.searchRegex == null) {
            return 0;
        }
        int hits = 0;
        Highlighter highlighter = this.getHighlighter();
        int docLength = this.internalText.length();
        Matcher matcher = this.searchRegex.matcher(this.internalText);
        matcher.region(0, docLength);
        while (matcher.find() && (startPos = matcher.start()) != (endPos = matcher.end())) {
            ++hits;
            matcher.region(endPos, docLength);
            try {
                highlighter.addHighlight(startPos, endPos, regexPainter);
            }
            catch (BadLocationException e) {
                assert (false);
                return 0;
            }
        }
        return hits;
    }

    private void clearHighlight() {
        Highlighter.Highlight[] highlights;
        Highlighter highlighter = this.getHighlighter();
        for (Highlighter.Highlight highlight : highlights = highlighter.getHighlights()) {
            if (highlight.getPainter() != regexPainter) continue;
            highlighter.removeHighlight(highlight);
        }
    }

    private View getRootView() {
        TextUI textUI = this.getUI();
        View root = textUI.getRootView(this);
        return root;
    }

    private List<TopicView> getTopicViewList(View parent, List<TopicView> list) {
        if (parent == null) {
            parent = this.getRootView();
            list = new LinkedList<TopicView>();
        }
        int childNo = parent.getViewCount();
        for (int ct = 0; ct <= childNo - 1; ++ct) {
            View child = parent.getView(ct);
            if (child instanceof TopicView) {
                list.add((TopicView)child);
                continue;
            }
            this.getTopicViewList(child, list);
        }
        return list;
    }

    @Override
    public void caretUpdate(CaretEvent event) {
        int mark;
        int dot = event.getDot();
        if (dot == (mark = event.getMark())) {
            this.menuCopy.setEnabled(false);
        } else {
            this.menuCopy.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("COPY")) {
            this.copy();
        } else if (cmd.equals("SELTALK")) {
            if (this.talkElem == null) {
                return;
            }
            int startPos = this.talkElem.getStartOffset();
            int endPos = this.talkElem.getEndOffset();
            this.select(startPos, endPos);
            this.copy();
        } else if (!cmd.equals("PRINT") && cmd.equals("SELALL")) {
            this.selectAll();
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.mouseReleased(event);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (!event.isPopupTrigger()) {
            return;
        }
        Point point = event.getPoint();
        int offset = this.viewToModel(point);
        Element element = Utilities.getParagraphElement(this, offset);
        this.talkElem = this.findTalkDivElem(element);
        if (this.talkElem != null) {
            this.menuSelTalk.setEnabled(true);
        } else {
            this.menuSelTalk.setEnabled(false);
        }
        this.popup.show(this, event.getX(), event.getY());
    }

    private Element findTalkDivElem(Element child) {
        Element element;
        for (element = child; element != null && !this.isTalkDivElem(element); element = element.getParentElement()) {
        }
        return element;
    }

    private boolean isTalkDivElem(Element element) {
        if (element == null) {
            return false;
        }
        AttributeSet attr = element.getAttributes();
        Object obj = attr.getAttribute(StyleConstants.NameAttribute);
        if (!(obj instanceof HTML.Tag)) {
            return false;
        }
        HTML.Tag kind = (HTML.Tag)obj;
        if (kind != HTML.Tag.DIV) {
            return false;
        }
        Object objClass = attr.getAttribute(HTML.Attribute.CLASS);
        String attrClass = (String)objClass;
        if (attrClass == null) {
            return false;
        }
        return attrClass.equals("message");
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (this.topicFilter != null && this.filterContext == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JdfBrowser.this.filtering();
                }
            });
            this.repaint();
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(GUIUtils.getDefaultHints());
        super.paint(g);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.popup != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
        this.filterContext = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JdfBrowser.this.highlightRegex();
            }
        });
    }
}

